---
layout: news_item
date: "2021-05-18 08:30:00 +0000"
author: francischuang
version: 1.18.0
categories: [release]
tag: v1-18-0
sha: a7cfca4
component: avatica
---
<!--
{% comment %}
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to you under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
{% endcomment %}
-->

Apache Calcite Avatica 1.18.0 includes a few dependency updates, bug fixes and
a breaking change. In addition, the Gradle wrapper has been removed from the source
distribution in order to comply with ASF policy. See the list of [bug fixes and new features]({{ site.baseurl }}/docs/history.html#v1-18-0)
for more information.

**Breaking change (<a href="https://issues.apache.org/jira/browse/CALCITE-4503">CALCITE-4503</a>)**: Order of fields in records should follow that of the SQL types

`Meta#deduce(List<ColumnMetaData> columns, Class resultClazz)` now only derives the order of the fields from the list of provided column metadata `columns` when generating a record from the given Java class `resultClazz`, instead of relying on the field order provided by `Object#getFields()`, which is a JVM-dependent feature.

Before, the field names where not checked against the field names of the provided class. Now, if `resultClazz` is not null, the provided field names are expected to match existing fields in that class. If a column metadata has name `column`, and no public field in `resultClazz` with that name exists, the following exception is thrown:
`java.lang.RuntimeException: java.lang.NoSuchFieldException: C`.
