/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.state;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.repair.CommonRange;
import org.apache.cassandra.repair.RepairRunnable;
import org.apache.cassandra.repair.messages.RepairOption;
import org.apache.cassandra.repair.state.AbstractCompletable;
import org.apache.cassandra.repair.state.AbstractState;
import org.apache.cassandra.repair.state.SessionState;
import org.apache.cassandra.utils.TimeUUID;

public class CoordinatorState
extends AbstractState<State, TimeUUID> {
    public final int cmd;
    public final String keyspace;
    public final RepairOption options;
    private final ConcurrentMap<TimeUUID, SessionState> sessions = new ConcurrentHashMap<TimeUUID, SessionState>();
    private List<ColumnFamilyStore> columnFamilies = null;
    private RepairRunnable.NeighborsAndRanges neighborsAndRanges = null;
    public final Phase phase = new Phase();

    public CoordinatorState(int cmd, String keyspace, RepairOption options) {
        super(TimeUUID.Generator.nextTimeUUID(), State.class);
        this.cmd = cmd;
        this.keyspace = Objects.requireNonNull(keyspace);
        this.options = Objects.requireNonNull(options);
    }

    public Collection<SessionState> getSessions() {
        return this.sessions.values();
    }

    public Set<TimeUUID> getSessionIds() {
        return this.sessions.keySet();
    }

    public void register(SessionState state) {
        this.sessions.put((TimeUUID)state.id, state);
    }

    public List<ColumnFamilyStore> getColumnFamilies() {
        return this.columnFamilies;
    }

    public String[] getColumnFamilyNames() {
        if (this.columnFamilies == null) {
            return null;
        }
        return (String[])this.columnFamilies.stream().map(ColumnFamilyStore::getTableName).toArray(String[]::new);
    }

    public RepairRunnable.NeighborsAndRanges getNeighborsAndRanges() {
        return this.neighborsAndRanges;
    }

    public Set<InetAddressAndPort> getParticipants() {
        if (this.neighborsAndRanges == null) {
            return null;
        }
        return this.neighborsAndRanges.participants;
    }

    public List<CommonRange> getCommonRanges() {
        if (this.neighborsAndRanges == null) {
            return null;
        }
        return this.neighborsAndRanges.commonRanges;
    }

    public List<CommonRange> getFilteredCommonRanges() {
        if (this.neighborsAndRanges == null) {
            return null;
        }
        return this.neighborsAndRanges.filterCommonRanges(this.keyspace, this.getColumnFamilyNames());
    }

    public final class Phase
    extends AbstractCompletable.BaseSkipPhase {
        public void setup() {
            CoordinatorState.this.updateState(State.SETUP);
        }

        public void start(List<ColumnFamilyStore> columnFamilies, RepairRunnable.NeighborsAndRanges neighborsAndRanges) {
            CoordinatorState.this.columnFamilies = Objects.requireNonNull(columnFamilies);
            CoordinatorState.this.neighborsAndRanges = Objects.requireNonNull(neighborsAndRanges);
            CoordinatorState.this.updateState(State.START);
        }

        public void prepareStart() {
            CoordinatorState.this.updateState(State.PREPARE_START);
        }

        public void prepareComplete() {
            CoordinatorState.this.updateState(State.PREPARE_COMPLETE);
        }

        public void repairSubmitted() {
            CoordinatorState.this.updateState(State.REPAIR_START);
        }

        public void repairCompleted() {
            CoordinatorState.this.updateState(State.REPAIR_COMPLETE);
        }
    }

    public static enum State {
        SETUP,
        START,
        PREPARE_START,
        PREPARE_COMPLETE,
        REPAIR_START,
        REPAIR_COMPLETE;

    }
}

