/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming.messages;

import java.io.IOException;
import java.util.Objects;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.streaming.IncomingStream;
import org.apache.cassandra.streaming.StreamManager;
import org.apache.cassandra.streaming.StreamReceiveException;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.StreamingChannel;
import org.apache.cassandra.streaming.StreamingDataOutputPlus;
import org.apache.cassandra.streaming.messages.StreamMessage;
import org.apache.cassandra.streaming.messages.StreamMessageHeader;

public class IncomingStreamMessage
extends StreamMessage {
    public static StreamMessage.Serializer<IncomingStreamMessage> serializer = new StreamMessage.Serializer<IncomingStreamMessage>(){

        @Override
        public IncomingStreamMessage deserialize(DataInputPlus input, int version) throws IOException {
            StreamMessageHeader header = StreamMessageHeader.serializer.deserialize(input, version);
            StreamSession session = StreamManager.instance.findSession(header.sender, header.planId, header.sessionIndex, header.sendByFollower);
            if (session == null) {
                throw new IllegalStateException(String.format("unknown stream session: %s - %d", header.planId, header.sessionIndex));
            }
            ColumnFamilyStore cfs = ColumnFamilyStore.getIfExists(header.tableId);
            if (cfs == null) {
                throw new StreamReceiveException(session, "CF " + header.tableId + " was dropped during streaming");
            }
            try {
                IncomingStream incomingData = cfs.getStreamManager().prepareIncomingStream(session, header);
                incomingData.read(input, version);
                return new IncomingStreamMessage(incomingData, header);
            }
            catch (Throwable t) {
                if (t instanceof StreamReceiveException) {
                    throw (StreamReceiveException)t;
                }
                throw new StreamReceiveException(session, t);
            }
        }

        @Override
        public void serialize(IncomingStreamMessage message, StreamingDataOutputPlus out, int version, StreamSession session) {
            throw new UnsupportedOperationException("Not allowed to call serialize on an incoming stream");
        }

        @Override
        public long serializedSize(IncomingStreamMessage message, int version) {
            throw new UnsupportedOperationException("Not allowed to call serializedSize on an incoming stream");
        }
    };
    public final StreamMessageHeader header;
    public final IncomingStream stream;

    public IncomingStreamMessage(IncomingStream stream, StreamMessageHeader header) {
        super(StreamMessage.Type.STREAM);
        this.stream = stream;
        this.header = header;
    }

    @Override
    public StreamSession getOrCreateAndAttachInboundSession(StreamingChannel channel, int messagingVersion) {
        this.stream.session().attachInbound(channel);
        return this.stream.session();
    }

    public String toString() {
        return "IncomingStreamMessage{header=" + this.header + ", stream=" + this.stream + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncomingStreamMessage that = (IncomingStreamMessage)o;
        return Objects.equals(this.header, that.header) && Objects.equals(this.stream, that.stream);
    }

    public int hashCode() {
        return Objects.hash(this.header, this.stream);
    }
}

