/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace.analytics;

import java.io.IOException;
import org.gridkit.jvmtool.stacktrace.CounterCollection;
import org.gridkit.jvmtool.stacktrace.ReaderProxy;
import org.gridkit.jvmtool.stacktrace.StackFrameList;
import org.gridkit.jvmtool.stacktrace.StackTraceReader;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadSnapshotFilter;

public class FilteredStackTraceReader
extends ReaderProxy
implements StackTraceReader {
    private final ThreadSnapshotFilter filter;
    private final StackTraceReader reader;

    public FilteredStackTraceReader(ThreadSnapshotFilter filter, StackTraceReader reader) throws IOException {
        super(null);
        this.filter = filter;
        this.reader = reader;
        if (reader.isLoaded()) {
            reader.loadNext();
        }
        this.seek();
    }

    @Override
    protected StackTraceReader getReader() {
        return this;
    }

    @Override
    public boolean isLoaded() {
        return this.reader.isLoaded();
    }

    @Override
    public long getThreadId() {
        return this.reader.getThreadId();
    }

    @Override
    public long getTimestamp() {
        return this.reader.getTimestamp();
    }

    @Override
    public String getThreadName() {
        return this.reader.getThreadName();
    }

    @Override
    public Thread.State getThreadState() {
        return this.reader.getThreadState();
    }

    @Override
    public CounterCollection getCounters() {
        return this.reader.getCounters();
    }

    @Override
    public StackTraceElement[] getTrace() {
        return this.reader.getTrace();
    }

    @Override
    public StackFrameList getStackTrace() {
        return this.reader.getStackTrace();
    }

    private void seek() throws IOException {
        while (this.reader.isLoaded()) {
            if (this.filter.evaluate(this)) {
                return;
            }
            this.reader.loadNext();
        }
    }

    @Override
    public boolean loadNext() throws IOException {
        this.reader.loadNext();
        this.seek();
        return this.reader.isLoaded();
    }
}

