/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.generator;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.FrameType;
import org.eclipse.jetty.http2.frames.PingFrame;
import org.eclipse.jetty.http2.generator.FrameGenerator;
import org.eclipse.jetty.http2.generator.HeaderGenerator;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;

public class PingGenerator
extends FrameGenerator {
    public PingGenerator(HeaderGenerator headerGenerator) {
        super(headerGenerator);
    }

    @Override
    public int generate(ByteBufferPool.Accumulator accumulator, Frame frame) {
        PingFrame pingFrame = (PingFrame)frame;
        return this.generatePing(accumulator, pingFrame.getPayload(), pingFrame.isReply());
    }

    public int generatePing(ByteBufferPool.Accumulator accumulator, byte[] payload, boolean reply) {
        if (payload.length != 8) {
            throw new IllegalArgumentException("Invalid payload length: " + payload.length);
        }
        RetainableByteBuffer header = this.generateHeader(FrameType.PING, 8, reply ? 1 : 0, 0);
        ByteBuffer byteBuffer = header.getByteBuffer();
        byteBuffer.put(payload);
        BufferUtil.flipToFlush(byteBuffer, 0);
        accumulator.append(header);
        return 17;
    }
}

