/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.generator;

import java.nio.ByteBuffer;
import java.util.Map;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.FrameType;
import org.eclipse.jetty.http2.frames.SettingsFrame;
import org.eclipse.jetty.http2.generator.FrameGenerator;
import org.eclipse.jetty.http2.generator.HeaderGenerator;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;

public class SettingsGenerator
extends FrameGenerator {
    public SettingsGenerator(HeaderGenerator headerGenerator) {
        super(headerGenerator);
    }

    @Override
    public int generate(ByteBufferPool.Accumulator accumulator, Frame frame) {
        SettingsFrame settingsFrame = (SettingsFrame)frame;
        return this.generateSettings(accumulator, settingsFrame.getSettings(), settingsFrame.isReply());
    }

    public int generateSettings(ByteBufferPool.Accumulator accumulator, Map<Integer, Integer> settings, boolean reply) {
        int entryLength = 6;
        int length = entryLength * settings.size();
        if (length > this.getMaxFrameSize()) {
            throw new IllegalArgumentException("Invalid settings, too big");
        }
        RetainableByteBuffer header = this.generateHeader(FrameType.SETTINGS, length, reply ? 1 : 0, 0);
        ByteBuffer byteBuffer = header.getByteBuffer();
        for (Map.Entry<Integer, Integer> entry : settings.entrySet()) {
            byteBuffer.putShort(entry.getKey().shortValue());
            byteBuffer.putInt(entry.getValue());
        }
        BufferUtil.flipToFlush(byteBuffer, 0);
        accumulator.append(header);
        return 9 + length;
    }
}

