/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned.rebalance.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.partitioned.rebalance.model.AddressComparor;
import org.apache.geode.internal.cache.partitioned.rebalance.model.Bucket;
import org.apache.geode.internal.cache.partitioned.rebalance.model.BucketRollup;
import org.apache.geode.internal.cache.partitioned.rebalance.model.Member;
import org.apache.geode.internal.cache.partitioned.rebalance.model.RefusalReason;

class MemberRollup
extends Member {
    private final Map<String, Member> colocatedMembers = new HashMap<String, Member>();

    MemberRollup(AddressComparor addressComparor, InternalDistributedMember memberId, boolean isCritical, boolean enforceLocalMaxMemory) {
        super(addressComparor, memberId, isCritical, enforceLocalMaxMemory);
    }

    public boolean isInvalid() {
        return false;
    }

    public void addColocatedMember(String region, Member member) {
        if (!this.getColocatedMembers().containsKey(region)) {
            this.getColocatedMembers().put(region, member);
            this.weight += member.weight;
            this.changeLocalMaxMemory(member.getConfiguredMaxMemory());
        }
    }

    public Member getColocatedMember(String region) {
        return this.getColocatedMembers().get(region);
    }

    public void updateLoad(float load, float primaryLoad, float bytes) {
        this.changeTotalLoad(load);
        this.changePrimaryLoad(primaryLoad);
        this.changeTotalBytes(bytes);
    }

    @Override
    public boolean addBucket(Bucket bucket) {
        if (super.addBucket(bucket)) {
            BucketRollup bucketRollup = (BucketRollup)bucket;
            for (Map.Entry<String, Member> entry : this.getColocatedMembers().entrySet()) {
                String region = entry.getKey();
                Member member = entry.getValue();
                Bucket colocatedBucket = bucketRollup.getColocatedBuckets().get(region);
                if (colocatedBucket == null) continue;
                member.addBucket(colocatedBucket);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeBucket(Bucket bucket) {
        if (super.removeBucket(bucket)) {
            BucketRollup bucketRollup = (BucketRollup)bucket;
            for (Map.Entry<String, Member> entry : this.getColocatedMembers().entrySet()) {
                String region = entry.getKey();
                Member member = entry.getValue();
                Bucket colocatedBucket = bucketRollup.getColocatedBuckets().get(region);
                if (colocatedBucket == null) continue;
                member.removeBucket(colocatedBucket);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean addPrimary(Bucket bucket) {
        if (super.addPrimary(bucket)) {
            BucketRollup bucketRollup = (BucketRollup)bucket;
            for (Map.Entry<String, Member> entry : this.getColocatedMembers().entrySet()) {
                String region = entry.getKey();
                Member member = entry.getValue();
                Bucket colocatedBucket = bucketRollup.getColocatedBuckets().get(region);
                if (colocatedBucket == null) continue;
                member.addPrimary(colocatedBucket);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removePrimary(Bucket bucket) {
        if (super.removePrimary(bucket)) {
            BucketRollup bucketRollup = (BucketRollup)bucket;
            for (Map.Entry<String, Member> entry : this.getColocatedMembers().entrySet()) {
                String region = entry.getKey();
                Member member = entry.getValue();
                Bucket colocatedBucket = bucketRollup.getColocatedBuckets().get(region);
                if (colocatedBucket == null) continue;
                member.removePrimary(colocatedBucket);
            }
            return true;
        }
        return false;
    }

    @Override
    public RefusalReason willAcceptBucket(Bucket bucket, Member source, boolean checkIPAddress) {
        RefusalReason reason = super.willAcceptBucket(bucket, source, checkIPAddress);
        if (reason.willAccept()) {
            BucketRollup bucketRollup = (BucketRollup)bucket;
            MemberRollup sourceRollup = (MemberRollup)source;
            for (Map.Entry<String, Member> entry : this.getColocatedMembers().entrySet()) {
                Member colocatedSource;
                String region = entry.getKey();
                Member member = entry.getValue();
                Bucket colocatedBucket = bucketRollup.getColocatedBuckets().get(region);
                Member member2 = colocatedSource = sourceRollup == null ? null : sourceRollup.getColocatedMembers().get(region);
                if (colocatedBucket == null || (reason = member.willAcceptBucket(colocatedBucket, colocatedSource, checkIPAddress)).willAccept()) continue;
                return reason;
            }
            return RefusalReason.NONE;
        }
        return reason;
    }

    Map<String, Member> getColocatedMembers() {
        return this.colocatedMembers;
    }
}

