/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.persistence;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.util.UUID;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.persistence.PersistentID;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.net.SocketCreator;

public class PersistentMemberPattern
implements PersistentID,
Comparable<PersistentMemberPattern> {
    private InetAddress host;
    private String directory;
    private UUID diskStoreID;
    private long revokedTime;

    public PersistentMemberPattern(PersistentMemberID id) {
        this(id.getHost(), id.getDirectory(), id.getDiskStoreId().toUUID(), 0L);
    }

    public PersistentMemberPattern(InetAddress host, String directory) {
        this(host, directory, null, 0L);
    }

    public PersistentMemberPattern(InetAddress host, String directory, long revokedTime) {
        this(host, directory, null, revokedTime);
    }

    public PersistentMemberPattern(UUID id) {
        this(null, null, id, 0L);
    }

    public PersistentMemberPattern(InetAddress host, String directory, UUID diskStoreID, long revokedTime) {
        this.host = host;
        this.directory = directory;
        this.revokedTime = revokedTime;
        this.diskStoreID = diskStoreID;
    }

    public PersistentMemberPattern() {
    }

    public boolean matches(PersistentMemberID id) {
        if (id == null) {
            return false;
        }
        boolean matches = true;
        matches &= this.host == null || this.host.equals(id.getHost());
        matches &= this.directory == null || this.directory.equals(id.getDirectory());
        matches &= this.diskStoreID == null || id.getDiskStoreId().getMostSignificantBits() == this.diskStoreID.getMostSignificantBits() && id.getDiskStoreId().getLeastSignificantBits() == this.diskStoreID.getLeastSignificantBits();
        if (this.diskStoreID == null) {
            matches &= this.revokedTime > id.getTimeStamp();
        }
        return matches;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.diskStoreID);
        if (this.host != null) {
            result.append(" [");
            result.append(SocketCreator.getHostName(this.host));
            result.append(":");
            result.append(this.directory);
            result.append(",revoked@").append(this.revokedTime);
            result.append("]");
        }
        return result.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.directory == null ? 0 : this.directory.hashCode());
        result = 31 * result + (this.diskStoreID == null ? 0 : this.diskStoreID.hashCode());
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (int)(this.revokedTime ^ this.revokedTime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PersistentMemberPattern other = (PersistentMemberPattern)obj;
        if (this.directory == null ? other.directory != null : !this.directory.equals(other.directory)) {
            return false;
        }
        if (this.diskStoreID == null ? other.diskStoreID != null : !this.diskStoreID.equals(other.diskStoreID)) {
            return false;
        }
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        return this.revokedTime == other.revokedTime;
    }

    @Override
    public InetAddress getHost() {
        return this.host;
    }

    @Override
    public String getDirectory() {
        return this.directory;
    }

    @Override
    public UUID getUUID() {
        return this.diskStoreID;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        boolean hasDirectory;
        boolean hasHost = in.readBoolean();
        if (hasHost) {
            this.host = DataSerializer.readInetAddress(in);
        }
        if (hasDirectory = in.readBoolean()) {
            this.directory = DataSerializer.readString(in);
        }
        this.diskStoreID = (UUID)DataSerializer.readObject(in);
        this.revokedTime = in.readLong();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeBoolean(this.host != null);
        if (this.host != null) {
            DataSerializer.writeInetAddress(this.host, out);
        }
        out.writeBoolean(this.directory != null);
        if (this.directory != null) {
            DataSerializer.writeString(this.directory, out);
        }
        DataSerializer.writeObject(this.diskStoreID, out);
        out.writeLong(this.revokedTime);
    }

    @Override
    public int compareTo(PersistentMemberPattern o) {
        int result = this.compare(this.diskStoreID, o.diskStoreID);
        if (result != 0) {
            return result;
        }
        result = this.compare((Comparable)((Object)(this.host == null ? null : this.host.getCanonicalHostName())), (Object)(o.host == null ? null : o.host.getCanonicalHostName()));
        if (result != 0) {
            return result;
        }
        result = this.compare((Comparable)((Object)this.directory), (Object)o.directory);
        if (result != 0) {
            return result;
        }
        result = Long.signum(this.revokedTime - o.revokedTime);
        return result;
    }

    private <X> int compare(Comparable<X> a, X b) {
        if (a == null) {
            if (b == null) {
                return 0;
            }
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return a.compareTo(b);
    }
}

