/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.geode.GemFireException;
import org.apache.geode.GemFireIOException;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.io.RollingFileHandler;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.statistics.ResourceInstance;
import org.apache.geode.internal.statistics.ResourceType;
import org.apache.geode.internal.statistics.SampleCollector;
import org.apache.geode.internal.statistics.SampleHandler;
import org.apache.geode.internal.statistics.StatArchiveDescriptor;
import org.apache.geode.internal.statistics.StatArchiveHandlerConfig;
import org.apache.geode.internal.statistics.StatArchiveWriter;
import org.apache.geode.logging.internal.log4j.LogWriterLogger;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.logging.internal.spi.LogFile;
import org.apache.logging.log4j.Logger;

public class StatArchiveHandler
implements SampleHandler {
    private static final Logger logger = LogService.getLogger();
    private final StatArchiveHandlerConfig config;
    private final SampleCollector collector;
    private final RollingFileHandler rollingFileHandler;
    private volatile boolean disabledArchiving = false;
    private StatArchiveWriter archiver = null;
    private File archiveDir = null;
    private int mainArchiveId = -1;
    private int archiveId = -1;

    public StatArchiveHandler(StatArchiveHandlerConfig config, SampleCollector sampleCollector, RollingFileHandler rollingFileHandler) {
        this.config = config;
        this.collector = sampleCollector;
        this.rollingFileHandler = rollingFileHandler;
    }

    public void initialize(long nanosTimeStamp) {
        this.changeArchiveFile(false, nanosTimeStamp);
        this.assertInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws GemFireException {
        StatArchiveHandler statArchiveHandler = this;
        synchronized (statArchiveHandler) {
            if (this.archiver != null) {
                this.archiver.close();
            }
        }
    }

    private void handleArchiverException(GemFireException ex) {
        block4: {
            if (this.archiver.getSampleCount() > 0) {
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter((Writer)sw, true));
                logger.warn(LogMarker.STATISTICS_MARKER, "Statistic archiver shutting down because: {}", (Object)sw);
            }
            try {
                this.archiver.close();
            }
            catch (GemFireException e) {
                if (this.archiver.getSampleCount() <= 0) break block4;
                logger.warn(LogMarker.STATISTICS_MARKER, "Statistic archiver shutdown failed because: {}", (Object)e.getMessage());
            }
        }
        if (this.archiver.getSampleCount() == 0 && this.archiveId != -1) {
            --this.archiveId;
        }
        this.archiver = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sampled(long nanosTimeStamp, List<ResourceInstance> resourceInstances) {
        StatArchiveHandler statArchiveHandler = this;
        synchronized (statArchiveHandler) {
            if (logger.isTraceEnabled(LogMarker.STATISTICS_VERBOSE)) {
                logger.trace(LogMarker.STATISTICS_VERBOSE, "StatArchiveHandler#sampled resourceInstances={}", resourceInstances);
            }
            if (this.archiver != null) {
                long bytesWritten;
                long byteLimit;
                try {
                    this.archiver.sampled(nanosTimeStamp, resourceInstances);
                    if (this.archiver.getSampleCount() == 1) {
                        logger.info(LogMarker.STATISTICS_MARKER, "Archiving statistics to {}.", (Object)this.archiver.getArchiveName());
                    }
                }
                catch (IllegalArgumentException e) {
                    logger.warn(LogMarker.STATISTICS_MARKER, "Use of java.lang.System.nanoTime() resulted in a non-positive timestamp delta. Skipping archival of statistics sample.", (Throwable)e);
                }
                catch (GemFireException ex) {
                    this.handleArchiverException(ex);
                }
                if (this.archiver != null && (byteLimit = this.config.getArchiveFileSizeLimit()) != 0L && (bytesWritten = this.archiver.bytesWritten()) > byteLimit) {
                    try {
                        this.changeArchiveFile(true, nanosTimeStamp);
                    }
                    catch (GemFireIOException gemFireIOException) {}
                }
            } else if (!this.config.getArchiveFileName().getPath().equals("")) {
                try {
                    this.changeArchiveFile(true, nanosTimeStamp);
                }
                catch (GemFireIOException gemFireIOException) {
                    // empty catch block
                }
            }
        }
    }

    void assertInitialized() {
        if (this.archiver == null && !this.config.getArchiveFileName().getPath().equals("")) {
            throw new IllegalStateException("This " + this + " was not initialized");
        }
    }

    @Override
    public void allocatedResourceType(ResourceType resourceType) {
        if (logger.isTraceEnabled(LogMarker.STATISTICS_VERBOSE)) {
            logger.trace(LogMarker.STATISTICS_VERBOSE, "StatArchiveHandler#allocatedResourceType resourceType={}", (Object)resourceType);
        }
        if (this.archiver != null) {
            try {
                this.archiver.allocatedResourceType(resourceType);
            }
            catch (GemFireException ex) {
                this.handleArchiverException(ex);
            }
        }
    }

    @Override
    public void allocatedResourceInstance(ResourceInstance resourceInstance) {
        if (logger.isTraceEnabled(LogMarker.STATISTICS_VERBOSE)) {
            logger.trace(LogMarker.STATISTICS_VERBOSE, "StatArchiveHandler#allocatedResourceInstance resourceInstance={}", (Object)resourceInstance);
        }
        if (this.archiver != null) {
            try {
                this.archiver.allocatedResourceInstance(resourceInstance);
            }
            catch (GemFireException ex) {
                this.handleArchiverException(ex);
            }
        }
    }

    @Override
    public void destroyedResourceInstance(ResourceInstance resourceInstance) {
        if (logger.isTraceEnabled(LogMarker.STATISTICS_VERBOSE)) {
            logger.trace(LogMarker.STATISTICS_VERBOSE, "StatArchiveHandler#destroyedResourceInstance resourceInstance={}", (Object)resourceInstance);
        }
        if (this.archiver != null) {
            try {
                this.archiver.destroyedResourceInstance(resourceInstance);
            }
            catch (GemFireException ex) {
                this.handleArchiverException(ex);
            }
        }
    }

    public StatArchiveHandlerConfig getStatArchiveHandlerConfig() {
        return this.config;
    }

    public String toString() {
        return this.getClass().getName() + "@" + System.identityHashCode(this) + "{config=" + this.config + ", archiveDir=" + this.archiveDir + ", mainArchiveId=" + this.mainArchiveId + ", archiveId=" + this.archiveId + ", archiver=" + this.archiver + "}";
    }

    protected void changeArchiveFile(File newFile, long nanosTimeStamp) {
        this.changeArchiveFile(newFile, true, nanosTimeStamp);
    }

    protected boolean isArchiving() {
        return this.archiver != null && this.archiver.bytesWritten() > 0L;
    }

    private void changeArchiveFile(boolean resetHandler, long nanosTimeStamp) {
        this.changeArchiveFile(this.config.getArchiveFileName(), resetHandler, nanosTimeStamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeArchiveFile(File newFile, boolean resetHandler, long nanosTimeStamp) {
        StatArchiveHandler statArchiveHandler;
        boolean isDebugEnabled_STATISTICS = logger.isTraceEnabled(LogMarker.STATISTICS_VERBOSE);
        if (isDebugEnabled_STATISTICS) {
            logger.trace(LogMarker.STATISTICS_VERBOSE, "StatArchiveHandler#changeArchiveFile newFile={}, nanosTimeStamp={}", (Object)newFile, (Object)nanosTimeStamp);
        }
        StatArchiveWriter newArchiver = null;
        boolean archiveClosed = false;
        if (newFile.getPath().equals("")) {
            if (!this.disabledArchiving) {
                this.disabledArchiving = true;
                logger.info(LogMarker.STATISTICS_MARKER, "Disabling statistic archival.");
            }
        } else {
            this.disabledArchiving = false;
            if (this.config.getArchiveFileSizeLimit() != 0L && this.archiver != null) {
                archiveClosed = true;
                statArchiveHandler = this;
                synchronized (statArchiveHandler) {
                    if (resetHandler) {
                        if (isDebugEnabled_STATISTICS) {
                            logger.trace(LogMarker.STATISTICS_VERBOSE, "StatArchiveHandler#changeArchiveFile removing handler");
                        }
                        this.collector.removeSampleHandler(this);
                    }
                    try {
                        this.archiver.close();
                    }
                    catch (GemFireException e) {
                        logger.warn(LogMarker.STATISTICS_MARKER, "Statistic archive close failed because: {}", (Object)e.getMessage());
                    }
                }
            }
            if (newFile.exists()) {
                File oldFile = this.config.getArchiveFileSizeLimit() != 0L ? this.getRollingArchiveName(newFile, archiveClosed) : this.getRenameArchiveName(newFile);
                if (!newFile.renameTo(oldFile)) {
                    logger.warn(LogMarker.STATISTICS_MARKER, "Could not rename {} to {}.", new Object[]{newFile, oldFile});
                } else {
                    logger.info(LogMarker.STATISTICS_MARKER, "Renamed old existing archive to {}.", (Object)oldFile);
                }
            } else {
                if (!newFile.getAbsoluteFile().getParentFile().equals(this.archiveDir)) {
                    this.archiveDir = newFile.getAbsoluteFile().getParentFile();
                    if (!this.archiveDir.exists()) {
                        this.archiveDir.mkdirs();
                    }
                }
                if (this.config.getArchiveFileSizeLimit() != 0L) {
                    this.initMainArchiveId(newFile);
                }
            }
            try {
                StatArchiveDescriptor archiveDescriptor = new StatArchiveDescriptor.Builder().setArchiveName(newFile.getAbsolutePath()).setSystemId(this.config.getSystemId()).setSystemStartTime(this.config.getSystemStartTime()).setSystemDirectoryPath(this.config.getSystemDirectoryPath()).setProductDescription(this.config.getProductDescription()).build();
                newArchiver = new StatArchiveWriter(archiveDescriptor);
                newArchiver.initialize(nanosTimeStamp);
            }
            catch (GemFireIOException ex) {
                logger.warn(LogMarker.STATISTICS_MARKER, "Could not open statistic archive {}. Cause: {}", new Object[]{newFile, ex.getLocalizedMessage()});
                throw ex;
            }
        }
        statArchiveHandler = this;
        synchronized (statArchiveHandler) {
            if (archiveClosed) {
                if (this.archiver != null) {
                    this.removeOldArchives(newFile, this.config.getArchiveDiskSpaceLimit());
                }
            } else {
                if (resetHandler) {
                    if (isDebugEnabled_STATISTICS) {
                        logger.trace(LogMarker.STATISTICS_VERBOSE, "StatArchiveHandler#changeArchiveFile removing handler");
                    }
                    this.collector.removeSampleHandler(this);
                }
                if (this.archiver != null) {
                    try {
                        this.archiver.close();
                    }
                    catch (GemFireException e) {
                        logger.warn(LogMarker.STATISTICS_MARKER, "Statistic archive close failed because: {}", (Object)e.getMessage());
                    }
                    this.removeOldArchives(newFile, this.config.getArchiveDiskSpaceLimit());
                }
            }
            this.archiver = newArchiver;
            if (resetHandler && newArchiver != null) {
                if (isDebugEnabled_STATISTICS) {
                    logger.trace(LogMarker.STATISTICS_VERBOSE, "StatArchiveHandler#changeArchiveFile adding handler");
                }
                this.collector.addSampleHandler(this);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    File getRollingArchiveName(File archive, boolean archiveClosed) {
        String buf;
        File marker;
        int dotIdx;
        String markerName;
        StringBuilder buf2;
        if (this.mainArchiveId == -1) {
            LogFile logFile;
            File logDir;
            this.archiveDir = archive.getAbsoluteFile().getParentFile();
            boolean mainArchiveIdCalculated = false;
            if (this.config.getLogFile().isPresent() && this.archiveDir.equals(logDir = (logFile = this.config.getLogFile().get()).getLogDir())) {
                this.mainArchiveId = logFile.getMainLogId();
                if (this.mainArchiveId > 1 && logFile.useChildLogging()) {
                    --this.mainArchiveId;
                }
                mainArchiveIdCalculated = true;
            }
            if (!mainArchiveIdCalculated) {
                if (!this.archiveDir.exists()) {
                    this.archiveDir.mkdirs();
                }
                this.mainArchiveId = this.rollingFileHandler.calcNextMainId(this.archiveDir, false);
                mainArchiveIdCalculated = true;
            }
            if (this.mainArchiveId == 0) {
                this.mainArchiveId = 1;
            }
            this.archiveId = this.rollingFileHandler.calcNextChildId(archive, this.mainArchiveId);
            if (this.archiveId > 0) {
                --this.archiveId;
            }
        }
        File result = null;
        do {
            ++this.archiveId;
            buf2 = new StringBuilder(archive.getPath());
            int insertIdx = buf2.lastIndexOf(".");
            if (insertIdx == -1) {
                buf2.append(this.rollingFileHandler.formatId(this.mainArchiveId)).append(this.rollingFileHandler.formatId(this.archiveId));
                continue;
            }
            buf2.insert(insertIdx, this.rollingFileHandler.formatId(this.archiveId));
            buf2.insert(insertIdx, this.rollingFileHandler.formatId(this.mainArchiveId));
        } while ((result = new File(buf2.toString())).exists());
        if (this.archiveId == 1) {
            markerName = archive.getPath();
            dotIdx = markerName.lastIndexOf(".");
            if (dotIdx != -1) {
                markerName = markerName.substring(0, dotIdx);
            }
            if (!(marker = new File(buf = markerName + this.rollingFileHandler.formatId(this.mainArchiveId) + this.rollingFileHandler.formatId(0) + ".marker")).exists() || !marker.delete()) {
                // empty if block
            }
        }
        if (archiveClosed) return result;
        ++this.mainArchiveId;
        this.archiveId = 0;
        markerName = archive.getPath();
        dotIdx = markerName.lastIndexOf(".");
        if (dotIdx != -1) {
            markerName = markerName.substring(0, dotIdx);
        }
        if ((marker = new File(buf = markerName + this.rollingFileHandler.formatId(this.mainArchiveId) + this.rollingFileHandler.formatId(0) + ".marker")).exists()) return result;
        try {
            if (marker.createNewFile()) return result;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void initMainArchiveId(File archive) {
        String buf;
        File marker;
        LogFile logFile;
        File logDir;
        if (this.mainArchiveId != -1) {
            return;
        }
        this.archiveDir = archive.getAbsoluteFile().getParentFile();
        boolean mainArchiveIdCalculated = false;
        if (this.config.getLogFile().isPresent() && this.archiveDir.equals(logDir = (logFile = this.config.getLogFile().get()).getLogDir())) {
            this.mainArchiveId = logFile.getMainLogId();
            mainArchiveIdCalculated = true;
        }
        if (!mainArchiveIdCalculated) {
            if (!this.archiveDir.exists()) {
                this.archiveDir.mkdirs();
            }
            this.mainArchiveId = this.rollingFileHandler.calcNextMainId(this.archiveDir, false);
            ++this.mainArchiveId;
            mainArchiveIdCalculated = true;
        }
        if (this.mainArchiveId == 0) {
            this.mainArchiveId = 1;
        }
        this.archiveId = 0;
        String markerName = archive.getPath();
        int dotIdx = markerName.lastIndexOf(".");
        if (dotIdx != -1) {
            markerName = markerName.substring(0, dotIdx);
        }
        if ((marker = new File(buf = markerName + this.rollingFileHandler.formatId(this.mainArchiveId) + this.rollingFileHandler.formatId(0) + ".marker")).exists()) return;
        try {
            if (marker.createNewFile()) return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    File getRenameArchiveName(File archive) {
        StringBuilder buf;
        File dir = archive.getAbsoluteFile().getParentFile();
        int previousMainId = this.rollingFileHandler.calcNextMainId(dir, false);
        if (previousMainId == 0) {
            previousMainId = 1;
        }
        --previousMainId;
        File result = null;
        do {
            ++previousMainId;
            buf = new StringBuilder(archive.getPath());
            int insertIdx = buf.lastIndexOf(".");
            if (insertIdx == -1) {
                buf.append(this.rollingFileHandler.formatId(previousMainId)).append(this.rollingFileHandler.formatId(1));
                continue;
            }
            buf.insert(insertIdx, this.rollingFileHandler.formatId(1));
            buf.insert(insertIdx, this.rollingFileHandler.formatId(previousMainId));
        } while ((result = new File(buf.toString())).exists());
        return result;
    }

    private void removeOldArchives(File archiveFile, long spaceLimit) {
        if (spaceLimit == 0L || archiveFile == null || archiveFile.getPath().equals("")) {
            return;
        }
        File archiveDir = archiveFile.getAbsoluteFile().getParentFile();
        this.rollingFileHandler.checkDiskSpace("archive", archiveFile, spaceLimit, archiveDir, this.getOrCreateLogWriter());
    }

    private InternalLogWriter getOrCreateLogWriter() {
        InternalLogWriter lw = InternalDistributedSystem.getStaticInternalLogWriter();
        if (lw == null) {
            lw = LogWriterLogger.create(logger);
        }
        return lw;
    }
}

