// This autogenerated skeleton file illustrates how to build a server.
// You should copy it to another filename to avoid overwriting it.

#include "ThriftHiveMetastore.h"
#include <thrift/protocol/TBinaryProtocol.h>
#include <thrift/server/TSimpleServer.h>
#include <thrift/transport/TServerSocket.h>
#include <thrift/transport/TBufferTransports.h>

using namespace ::apache::thrift;
using namespace ::apache::thrift::protocol;
using namespace ::apache::thrift::transport;
using namespace ::apache::thrift::server;

using namespace  ::Apache::Hadoop::Hive;

class ThriftHiveMetastoreHandler : virtual public ThriftHiveMetastoreIf {
 public:
  ThriftHiveMetastoreHandler() {
    // Your initialization goes here
  }

  void abort_Compactions(AbortCompactResponse& _return, const AbortCompactionRequest& rqst) {
    // Your implementation goes here
    printf("abort_Compactions\n");
  }

  void getMetaConf(std::string& _return, const std::string& key) {
    // Your implementation goes here
    printf("getMetaConf\n");
  }

  void setMetaConf(const std::string& key, const std::string& value) {
    // Your implementation goes here
    printf("setMetaConf\n");
  }

  void create_catalog(const CreateCatalogRequest& catalog) {
    // Your implementation goes here
    printf("create_catalog\n");
  }

  void alter_catalog(const AlterCatalogRequest& rqst) {
    // Your implementation goes here
    printf("alter_catalog\n");
  }

  void get_catalog(GetCatalogResponse& _return, const GetCatalogRequest& catName) {
    // Your implementation goes here
    printf("get_catalog\n");
  }

  void get_catalogs(GetCatalogsResponse& _return) {
    // Your implementation goes here
    printf("get_catalogs\n");
  }

  void drop_catalog(const DropCatalogRequest& catName) {
    // Your implementation goes here
    printf("drop_catalog\n");
  }

  void create_database(const Database& database) {
    // Your implementation goes here
    printf("create_database\n");
  }

  void create_database_req(const CreateDatabaseRequest& createDatabaseRequest) {
    // Your implementation goes here
    printf("create_database_req\n");
  }

  void get_database(Database& _return, const std::string& name) {
    // Your implementation goes here
    printf("get_database\n");
  }

  void get_database_req(Database& _return, const GetDatabaseRequest& request) {
    // Your implementation goes here
    printf("get_database_req\n");
  }

  void drop_database(const std::string& name, const bool deleteData, const bool cascade) {
    // Your implementation goes here
    printf("drop_database\n");
  }

  void drop_database_req(const DropDatabaseRequest& req) {
    // Your implementation goes here
    printf("drop_database_req\n");
  }

  void get_databases(std::vector<std::string> & _return, const std::string& pattern) {
    // Your implementation goes here
    printf("get_databases\n");
  }

  void get_all_databases(std::vector<std::string> & _return) {
    // Your implementation goes here
    printf("get_all_databases\n");
  }

  void get_databases_req(GetDatabaseObjectsResponse& _return, const GetDatabaseObjectsRequest& request) {
    // Your implementation goes here
    printf("get_databases_req\n");
  }

  void alter_database(const std::string& dbname, const Database& db) {
    // Your implementation goes here
    printf("alter_database\n");
  }

  void alter_database_req(const AlterDatabaseRequest& alterDbReq) {
    // Your implementation goes here
    printf("alter_database_req\n");
  }

  void create_dataconnector_req(const CreateDataConnectorRequest& connectorReq) {
    // Your implementation goes here
    printf("create_dataconnector_req\n");
  }

  void get_dataconnector_req(DataConnector& _return, const GetDataConnectorRequest& request) {
    // Your implementation goes here
    printf("get_dataconnector_req\n");
  }

  void drop_dataconnector_req(const DropDataConnectorRequest& dropDcReq) {
    // Your implementation goes here
    printf("drop_dataconnector_req\n");
  }

  void get_dataconnectors(std::vector<std::string> & _return) {
    // Your implementation goes here
    printf("get_dataconnectors\n");
  }

  void alter_dataconnector_req(const AlterDataConnectorRequest& alterReq) {
    // Your implementation goes here
    printf("alter_dataconnector_req\n");
  }

  void get_type(Type& _return, const std::string& name) {
    // Your implementation goes here
    printf("get_type\n");
  }

  bool create_type(const Type& type) {
    // Your implementation goes here
    printf("create_type\n");
  }

  bool drop_type(const std::string& type) {
    // Your implementation goes here
    printf("drop_type\n");
  }

  void get_type_all(std::map<std::string, Type> & _return, const std::string& name) {
    // Your implementation goes here
    printf("get_type_all\n");
  }

  void get_fields(std::vector<FieldSchema> & _return, const std::string& db_name, const std::string& table_name) {
    // Your implementation goes here
    printf("get_fields\n");
  }

  void get_fields_with_environment_context(std::vector<FieldSchema> & _return, const std::string& db_name, const std::string& table_name, const EnvironmentContext& environment_context) {
    // Your implementation goes here
    printf("get_fields_with_environment_context\n");
  }

  void get_fields_req(GetFieldsResponse& _return, const GetFieldsRequest& req) {
    // Your implementation goes here
    printf("get_fields_req\n");
  }

  void get_schema(std::vector<FieldSchema> & _return, const std::string& db_name, const std::string& table_name) {
    // Your implementation goes here
    printf("get_schema\n");
  }

  void get_schema_with_environment_context(std::vector<FieldSchema> & _return, const std::string& db_name, const std::string& table_name, const EnvironmentContext& environment_context) {
    // Your implementation goes here
    printf("get_schema_with_environment_context\n");
  }

  void get_schema_req(GetSchemaResponse& _return, const GetSchemaRequest& req) {
    // Your implementation goes here
    printf("get_schema_req\n");
  }

  void create_table(const Table& tbl) {
    // Your implementation goes here
    printf("create_table\n");
  }

  void create_table_with_environment_context(const Table& tbl, const EnvironmentContext& environment_context) {
    // Your implementation goes here
    printf("create_table_with_environment_context\n");
  }

  void create_table_with_constraints(const Table& tbl, const std::vector<SQLPrimaryKey> & primaryKeys, const std::vector<SQLForeignKey> & foreignKeys, const std::vector<SQLUniqueConstraint> & uniqueConstraints, const std::vector<SQLNotNullConstraint> & notNullConstraints, const std::vector<SQLDefaultConstraint> & defaultConstraints, const std::vector<SQLCheckConstraint> & checkConstraints) {
    // Your implementation goes here
    printf("create_table_with_constraints\n");
  }

  void create_table_req(const CreateTableRequest& request) {
    // Your implementation goes here
    printf("create_table_req\n");
  }

  void drop_constraint(const DropConstraintRequest& req) {
    // Your implementation goes here
    printf("drop_constraint\n");
  }

  void add_primary_key(const AddPrimaryKeyRequest& req) {
    // Your implementation goes here
    printf("add_primary_key\n");
  }

  void add_foreign_key(const AddForeignKeyRequest& req) {
    // Your implementation goes here
    printf("add_foreign_key\n");
  }

  void add_unique_constraint(const AddUniqueConstraintRequest& req) {
    // Your implementation goes here
    printf("add_unique_constraint\n");
  }

  void add_not_null_constraint(const AddNotNullConstraintRequest& req) {
    // Your implementation goes here
    printf("add_not_null_constraint\n");
  }

  void add_default_constraint(const AddDefaultConstraintRequest& req) {
    // Your implementation goes here
    printf("add_default_constraint\n");
  }

  void add_check_constraint(const AddCheckConstraintRequest& req) {
    // Your implementation goes here
    printf("add_check_constraint\n");
  }

  void translate_table_dryrun(Table& _return, const CreateTableRequest& request) {
    // Your implementation goes here
    printf("translate_table_dryrun\n");
  }

  void drop_table(const std::string& dbname, const std::string& name, const bool deleteData) {
    // Your implementation goes here
    printf("drop_table\n");
  }

  void drop_table_with_environment_context(const std::string& dbname, const std::string& name, const bool deleteData, const EnvironmentContext& environment_context) {
    // Your implementation goes here
    printf("drop_table_with_environment_context\n");
  }

  void drop_table_req(const DropTableRequest& dropTableReq) {
    // Your implementation goes here
    printf("drop_table_req\n");
  }

  void truncate_table(const std::string& dbName, const std::string& tableName, const std::vector<std::string> & partNames) {
    // Your implementation goes here
    printf("truncate_table\n");
  }

  void truncate_table_req(TruncateTableResponse& _return, const TruncateTableRequest& req) {
    // Your implementation goes here
    printf("truncate_table_req\n");
  }

  void get_tables(std::vector<std::string> & _return, const std::string& db_name, const std::string& pattern) {
    // Your implementation goes here
    printf("get_tables\n");
  }

  void get_tables_by_type(std::vector<std::string> & _return, const std::string& db_name, const std::string& pattern, const std::string& tableType) {
    // Your implementation goes here
    printf("get_tables_by_type\n");
  }

  void get_all_materialized_view_objects_for_rewriting(std::vector<Table> & _return) {
    // Your implementation goes here
    printf("get_all_materialized_view_objects_for_rewriting\n");
  }

  void get_materialized_views_for_rewriting(std::vector<std::string> & _return, const std::string& db_name) {
    // Your implementation goes here
    printf("get_materialized_views_for_rewriting\n");
  }

  void get_table_meta(std::vector<TableMeta> & _return, const std::string& db_patterns, const std::string& tbl_patterns, const std::vector<std::string> & tbl_types) {
    // Your implementation goes here
    printf("get_table_meta\n");
  }

  void get_all_tables(std::vector<std::string> & _return, const std::string& db_name) {
    // Your implementation goes here
    printf("get_all_tables\n");
  }

  void get_tables_ext(std::vector<ExtendedTableInfo> & _return, const GetTablesExtRequest& req) {
    // Your implementation goes here
    printf("get_tables_ext\n");
  }

  void get_table_req(GetTableResult& _return, const GetTableRequest& req) {
    // Your implementation goes here
    printf("get_table_req\n");
  }

  void get_table_objects_by_name_req(GetTablesResult& _return, const GetTablesRequest& req) {
    // Your implementation goes here
    printf("get_table_objects_by_name_req\n");
  }

  void get_materialization_invalidation_info(Materialization& _return, const CreationMetadata& creation_metadata, const std::string& validTxnList) {
    // Your implementation goes here
    printf("get_materialization_invalidation_info\n");
  }

  void update_creation_metadata(const std::string& catName, const std::string& dbname, const std::string& tbl_name, const CreationMetadata& creation_metadata) {
    // Your implementation goes here
    printf("update_creation_metadata\n");
  }

  void get_table_names_by_filter(std::vector<std::string> & _return, const std::string& dbname, const std::string& filter, const int16_t max_tables) {
    // Your implementation goes here
    printf("get_table_names_by_filter\n");
  }

  void alter_table(const std::string& dbname, const std::string& tbl_name, const Table& new_tbl) {
    // Your implementation goes here
    printf("alter_table\n");
  }

  void alter_table_with_environment_context(const std::string& dbname, const std::string& tbl_name, const Table& new_tbl, const EnvironmentContext& environment_context) {
    // Your implementation goes here
    printf("alter_table_with_environment_context\n");
  }

  void alter_table_with_cascade(const std::string& dbname, const std::string& tbl_name, const Table& new_tbl, const bool cascade) {
    // Your implementation goes here
    printf("alter_table_with_cascade\n");
  }

  void alter_table_req(AlterTableResponse& _return, const AlterTableRequest& req) {
    // Your implementation goes here
    printf("alter_table_req\n");
  }

  void add_partition(Partition& _return, const Partition& new_part) {
    // Your implementation goes here
    printf("add_partition\n");
  }

  void add_partition_with_environment_context(Partition& _return, const Partition& new_part, const EnvironmentContext& environment_context) {
    // Your implementation goes here
    printf("add_partition_with_environment_context\n");
  }

  int32_t add_partitions(const std::vector<Partition> & new_parts) {
    // Your implementation goes here
    printf("add_partitions\n");
  }

  int32_t add_partitions_pspec(const std::vector<PartitionSpec> & new_parts) {
    // Your implementation goes here
    printf("add_partitions_pspec\n");
  }

  void append_partition(Partition& _return, const std::string& db_name, const std::string& tbl_name, const std::vector<std::string> & part_vals) {
    // Your implementation goes here
    printf("append_partition\n");
  }

  void add_partitions_req(AddPartitionsResult& _return, const AddPartitionsRequest& request) {
    // Your implementation goes here
    printf("add_partitions_req\n");
  }

  void append_partition_with_environment_context(Partition& _return, const std::string& db_name, const std::string& tbl_name, const std::vector<std::string> & part_vals, const EnvironmentContext& environment_context) {
    // Your implementation goes here
    printf("append_partition_with_environment_context\n");
  }

  void append_partition_req(Partition& _return, const AppendPartitionsRequest& appendPartitionsReq) {
    // Your implementation goes here
    printf("append_partition_req\n");
  }

  void append_partition_by_name(Partition& _return, const std::string& db_name, const std::string& tbl_name, const std::string& part_name) {
    // Your implementation goes here
    printf("append_partition_by_name\n");
  }

  void append_partition_by_name_with_environment_context(Partition& _return, const std::string& db_name, const std::string& tbl_name, const std::string& part_name, const EnvironmentContext& environment_context) {
    // Your implementation goes here
    printf("append_partition_by_name_with_environment_context\n");
  }

  bool drop_partition(const std::string& db_name, const std::string& tbl_name, const std::vector<std::string> & part_vals, const bool deleteData) {
    // Your implementation goes here
    printf("drop_partition\n");
  }

  bool drop_partition_with_environment_context(const std::string& db_name, const std::string& tbl_name, const std::vector<std::string> & part_vals, const bool deleteData, const EnvironmentContext& environment_context) {
    // Your implementation goes here
    printf("drop_partition_with_environment_context\n");
  }

  bool drop_partition_req(const DropPartitionRequest& dropPartitionReq) {
    // Your implementation goes here
    printf("drop_partition_req\n");
  }

  bool drop_partition_by_name(const std::string& db_name, const std::string& tbl_name, const std::string& part_name, const bool deleteData) {
    // Your implementation goes here
    printf("drop_partition_by_name\n");
  }

  bool drop_partition_by_name_with_environment_context(const std::string& db_name, const std::string& tbl_name, const std::string& part_name, const bool deleteData, const EnvironmentContext& environment_context) {
    // Your implementation goes here
    printf("drop_partition_by_name_with_environment_context\n");
  }

  void drop_partitions_req(DropPartitionsResult& _return, const DropPartitionsRequest& req) {
    // Your implementation goes here
    printf("drop_partitions_req\n");
  }

  void get_partition(Partition& _return, const std::string& db_name, const std::string& tbl_name, const std::vector<std::string> & part_vals) {
    // Your implementation goes here
    printf("get_partition\n");
  }

  void get_partition_req(GetPartitionResponse& _return, const GetPartitionRequest& req) {
    // Your implementation goes here
    printf("get_partition_req\n");
  }

  void exchange_partition(Partition& _return, const std::map<std::string, std::string> & partitionSpecs, const std::string& source_db, const std::string& source_table_name, const std::string& dest_db, const std::string& dest_table_name) {
    // Your implementation goes here
    printf("exchange_partition\n");
  }

  void exchange_partitions(std::vector<Partition> & _return, const std::map<std::string, std::string> & partitionSpecs, const std::string& source_db, const std::string& source_table_name, const std::string& dest_db, const std::string& dest_table_name) {
    // Your implementation goes here
    printf("exchange_partitions\n");
  }

  void get_partition_with_auth(Partition& _return, const std::string& db_name, const std::string& tbl_name, const std::vector<std::string> & part_vals, const std::string& user_name, const std::vector<std::string> & group_names) {
    // Your implementation goes here
    printf("get_partition_with_auth\n");
  }

  void get_partition_by_name(Partition& _return, const std::string& db_name, const std::string& tbl_name, const std::string& part_name) {
    // Your implementation goes here
    printf("get_partition_by_name\n");
  }

  void get_partitions(std::vector<Partition> & _return, const std::string& db_name, const std::string& tbl_name, const int16_t max_parts) {
    // Your implementation goes here
    printf("get_partitions\n");
  }

  void get_partitions_req(PartitionsResponse& _return, const PartitionsRequest& req) {
    // Your implementation goes here
    printf("get_partitions_req\n");
  }

  void get_partitions_with_auth(std::vector<Partition> & _return, const std::string& db_name, const std::string& tbl_name, const int16_t max_parts, const std::string& user_name, const std::vector<std::string> & group_names) {
    // Your implementation goes here
    printf("get_partitions_with_auth\n");
  }

  void get_partitions_pspec(std::vector<PartitionSpec> & _return, const std::string& db_name, const std::string& tbl_name, const int32_t max_parts) {
    // Your implementation goes here
    printf("get_partitions_pspec\n");
  }

  void get_partition_names(std::vector<std::string> & _return, const std::string& db_name, const std::string& tbl_name, const int16_t max_parts) {
    // Your implementation goes here
    printf("get_partition_names\n");
  }

  void fetch_partition_names_req(std::vector<std::string> & _return, const PartitionsRequest& partitionReq) {
    // Your implementation goes here
    printf("fetch_partition_names_req\n");
  }

  void get_partition_values(PartitionValuesResponse& _return, const PartitionValuesRequest& request) {
    // Your implementation goes here
    printf("get_partition_values\n");
  }

  void get_partitions_ps(std::vector<Partition> & _return, const std::string& db_name, const std::string& tbl_name, const std::vector<std::string> & part_vals, const int16_t max_parts) {
    // Your implementation goes here
    printf("get_partitions_ps\n");
  }

  void get_partitions_ps_with_auth(std::vector<Partition> & _return, const std::string& db_name, const std::string& tbl_name, const std::vector<std::string> & part_vals, const int16_t max_parts, const std::string& user_name, const std::vector<std::string> & group_names) {
    // Your implementation goes here
    printf("get_partitions_ps_with_auth\n");
  }

  void get_partitions_ps_with_auth_req(GetPartitionsPsWithAuthResponse& _return, const GetPartitionsPsWithAuthRequest& req) {
    // Your implementation goes here
    printf("get_partitions_ps_with_auth_req\n");
  }

  void get_partition_names_ps(std::vector<std::string> & _return, const std::string& db_name, const std::string& tbl_name, const std::vector<std::string> & part_vals, const int16_t max_parts) {
    // Your implementation goes here
    printf("get_partition_names_ps\n");
  }

  void get_partition_names_ps_req(GetPartitionNamesPsResponse& _return, const GetPartitionNamesPsRequest& req) {
    // Your implementation goes here
    printf("get_partition_names_ps_req\n");
  }

  void get_partition_names_req(std::vector<std::string> & _return, const PartitionsByExprRequest& req) {
    // Your implementation goes here
    printf("get_partition_names_req\n");
  }

  void get_partitions_by_filter(std::vector<Partition> & _return, const std::string& db_name, const std::string& tbl_name, const std::string& filter, const int16_t max_parts) {
    // Your implementation goes here
    printf("get_partitions_by_filter\n");
  }

  void get_partitions_by_filter_req(std::vector<Partition> & _return, const GetPartitionsByFilterRequest& req) {
    // Your implementation goes here
    printf("get_partitions_by_filter_req\n");
  }

  void get_part_specs_by_filter(std::vector<PartitionSpec> & _return, const std::string& db_name, const std::string& tbl_name, const std::string& filter, const int32_t max_parts) {
    // Your implementation goes here
    printf("get_part_specs_by_filter\n");
  }

  void get_partitions_by_expr(PartitionsByExprResult& _return, const PartitionsByExprRequest& req) {
    // Your implementation goes here
    printf("get_partitions_by_expr\n");
  }

  void get_partitions_spec_by_expr(PartitionsSpecByExprResult& _return, const PartitionsByExprRequest& req) {
    // Your implementation goes here
    printf("get_partitions_spec_by_expr\n");
  }

  int32_t get_num_partitions_by_filter(const std::string& db_name, const std::string& tbl_name, const std::string& filter) {
    // Your implementation goes here
    printf("get_num_partitions_by_filter\n");
  }

  void get_partitions_by_names(std::vector<Partition> & _return, const std::string& db_name, const std::string& tbl_name, const std::vector<std::string> & names) {
    // Your implementation goes here
    printf("get_partitions_by_names\n");
  }

  void get_partitions_by_names_req(GetPartitionsByNamesResult& _return, const GetPartitionsByNamesRequest& req) {
    // Your implementation goes here
    printf("get_partitions_by_names_req\n");
  }

  void get_properties(PropertyGetResponse& _return, const PropertyGetRequest& req) {
    // Your implementation goes here
    printf("get_properties\n");
  }

  bool set_properties(const PropertySetRequest& req) {
    // Your implementation goes here
    printf("set_properties\n");
  }

  void alter_partition(const std::string& db_name, const std::string& tbl_name, const Partition& new_part) {
    // Your implementation goes here
    printf("alter_partition\n");
  }

  void alter_partitions(const std::string& db_name, const std::string& tbl_name, const std::vector<Partition> & new_parts) {
    // Your implementation goes here
    printf("alter_partitions\n");
  }

  void alter_partitions_with_environment_context(const std::string& db_name, const std::string& tbl_name, const std::vector<Partition> & new_parts, const EnvironmentContext& environment_context) {
    // Your implementation goes here
    printf("alter_partitions_with_environment_context\n");
  }

  void alter_partitions_req(AlterPartitionsResponse& _return, const AlterPartitionsRequest& req) {
    // Your implementation goes here
    printf("alter_partitions_req\n");
  }

  void alter_partition_with_environment_context(const std::string& db_name, const std::string& tbl_name, const Partition& new_part, const EnvironmentContext& environment_context) {
    // Your implementation goes here
    printf("alter_partition_with_environment_context\n");
  }

  void rename_partition(const std::string& db_name, const std::string& tbl_name, const std::vector<std::string> & part_vals, const Partition& new_part) {
    // Your implementation goes here
    printf("rename_partition\n");
  }

  void rename_partition_req(RenamePartitionResponse& _return, const RenamePartitionRequest& req) {
    // Your implementation goes here
    printf("rename_partition_req\n");
  }

  bool partition_name_has_valid_characters(const std::vector<std::string> & part_vals, const bool throw_exception) {
    // Your implementation goes here
    printf("partition_name_has_valid_characters\n");
  }

  void get_config_value(std::string& _return, const std::string& name, const std::string& defaultValue) {
    // Your implementation goes here
    printf("get_config_value\n");
  }

  void partition_name_to_vals(std::vector<std::string> & _return, const std::string& part_name) {
    // Your implementation goes here
    printf("partition_name_to_vals\n");
  }

  void partition_name_to_spec(std::map<std::string, std::string> & _return, const std::string& part_name) {
    // Your implementation goes here
    printf("partition_name_to_spec\n");
  }

  void markPartitionForEvent(const std::string& db_name, const std::string& tbl_name, const std::map<std::string, std::string> & part_vals, const PartitionEventType::type eventType) {
    // Your implementation goes here
    printf("markPartitionForEvent\n");
  }

  bool isPartitionMarkedForEvent(const std::string& db_name, const std::string& tbl_name, const std::map<std::string, std::string> & part_vals, const PartitionEventType::type eventType) {
    // Your implementation goes here
    printf("isPartitionMarkedForEvent\n");
  }

  void get_primary_keys(PrimaryKeysResponse& _return, const PrimaryKeysRequest& request) {
    // Your implementation goes here
    printf("get_primary_keys\n");
  }

  void get_foreign_keys(ForeignKeysResponse& _return, const ForeignKeysRequest& request) {
    // Your implementation goes here
    printf("get_foreign_keys\n");
  }

  void get_unique_constraints(UniqueConstraintsResponse& _return, const UniqueConstraintsRequest& request) {
    // Your implementation goes here
    printf("get_unique_constraints\n");
  }

  void get_not_null_constraints(NotNullConstraintsResponse& _return, const NotNullConstraintsRequest& request) {
    // Your implementation goes here
    printf("get_not_null_constraints\n");
  }

  void get_default_constraints(DefaultConstraintsResponse& _return, const DefaultConstraintsRequest& request) {
    // Your implementation goes here
    printf("get_default_constraints\n");
  }

  void get_check_constraints(CheckConstraintsResponse& _return, const CheckConstraintsRequest& request) {
    // Your implementation goes here
    printf("get_check_constraints\n");
  }

  void get_all_table_constraints(AllTableConstraintsResponse& _return, const AllTableConstraintsRequest& request) {
    // Your implementation goes here
    printf("get_all_table_constraints\n");
  }

  bool update_table_column_statistics(const ColumnStatistics& stats_obj) {
    // Your implementation goes here
    printf("update_table_column_statistics\n");
  }

  bool update_partition_column_statistics(const ColumnStatistics& stats_obj) {
    // Your implementation goes here
    printf("update_partition_column_statistics\n");
  }

  void update_table_column_statistics_req(SetPartitionsStatsResponse& _return, const SetPartitionsStatsRequest& req) {
    // Your implementation goes here
    printf("update_table_column_statistics_req\n");
  }

  void update_partition_column_statistics_req(SetPartitionsStatsResponse& _return, const SetPartitionsStatsRequest& req) {
    // Your implementation goes here
    printf("update_partition_column_statistics_req\n");
  }

  void update_transaction_statistics(const UpdateTransactionalStatsRequest& req) {
    // Your implementation goes here
    printf("update_transaction_statistics\n");
  }

  void get_table_column_statistics(ColumnStatistics& _return, const std::string& db_name, const std::string& tbl_name, const std::string& col_name) {
    // Your implementation goes here
    printf("get_table_column_statistics\n");
  }

  void get_partition_column_statistics(ColumnStatistics& _return, const std::string& db_name, const std::string& tbl_name, const std::string& part_name, const std::string& col_name) {
    // Your implementation goes here
    printf("get_partition_column_statistics\n");
  }

  void get_table_statistics_req(TableStatsResult& _return, const TableStatsRequest& request) {
    // Your implementation goes here
    printf("get_table_statistics_req\n");
  }

  void get_partitions_statistics_req(PartitionsStatsResult& _return, const PartitionsStatsRequest& request) {
    // Your implementation goes here
    printf("get_partitions_statistics_req\n");
  }

  void get_aggr_stats_for(AggrStats& _return, const PartitionsStatsRequest& request) {
    // Your implementation goes here
    printf("get_aggr_stats_for\n");
  }

  bool set_aggr_stats_for(const SetPartitionsStatsRequest& request) {
    // Your implementation goes here
    printf("set_aggr_stats_for\n");
  }

  bool delete_partition_column_statistics(const std::string& db_name, const std::string& tbl_name, const std::string& part_name, const std::string& col_name, const std::string& engine) {
    // Your implementation goes here
    printf("delete_partition_column_statistics\n");
  }

  bool delete_table_column_statistics(const std::string& db_name, const std::string& tbl_name, const std::string& col_name, const std::string& engine) {
    // Your implementation goes here
    printf("delete_table_column_statistics\n");
  }

  bool delete_column_statistics_req(const DeleteColumnStatisticsRequest& req) {
    // Your implementation goes here
    printf("delete_column_statistics_req\n");
  }

  void create_function(const Function& func) {
    // Your implementation goes here
    printf("create_function\n");
  }

  void drop_function(const std::string& dbName, const std::string& funcName) {
    // Your implementation goes here
    printf("drop_function\n");
  }

  void alter_function(const std::string& dbName, const std::string& funcName, const Function& newFunc) {
    // Your implementation goes here
    printf("alter_function\n");
  }

  void get_functions(std::vector<std::string> & _return, const std::string& dbName, const std::string& pattern) {
    // Your implementation goes here
    printf("get_functions\n");
  }

  void get_functions_req(GetFunctionsResponse& _return, const GetFunctionsRequest& request) {
    // Your implementation goes here
    printf("get_functions_req\n");
  }

  void get_function(Function& _return, const std::string& dbName, const std::string& funcName) {
    // Your implementation goes here
    printf("get_function\n");
  }

  void get_all_functions(GetAllFunctionsResponse& _return) {
    // Your implementation goes here
    printf("get_all_functions\n");
  }

  bool create_role(const Role& role) {
    // Your implementation goes here
    printf("create_role\n");
  }

  bool drop_role(const std::string& role_name) {
    // Your implementation goes here
    printf("drop_role\n");
  }

  void get_role_names(std::vector<std::string> & _return) {
    // Your implementation goes here
    printf("get_role_names\n");
  }

  bool grant_role(const std::string& role_name, const std::string& principal_name, const PrincipalType::type principal_type, const std::string& grantor, const PrincipalType::type grantorType, const bool grant_option) {
    // Your implementation goes here
    printf("grant_role\n");
  }

  bool revoke_role(const std::string& role_name, const std::string& principal_name, const PrincipalType::type principal_type) {
    // Your implementation goes here
    printf("revoke_role\n");
  }

  void list_roles(std::vector<Role> & _return, const std::string& principal_name, const PrincipalType::type principal_type) {
    // Your implementation goes here
    printf("list_roles\n");
  }

  void grant_revoke_role(GrantRevokeRoleResponse& _return, const GrantRevokeRoleRequest& request) {
    // Your implementation goes here
    printf("grant_revoke_role\n");
  }

  void get_principals_in_role(GetPrincipalsInRoleResponse& _return, const GetPrincipalsInRoleRequest& request) {
    // Your implementation goes here
    printf("get_principals_in_role\n");
  }

  void get_role_grants_for_principal(GetRoleGrantsForPrincipalResponse& _return, const GetRoleGrantsForPrincipalRequest& request) {
    // Your implementation goes here
    printf("get_role_grants_for_principal\n");
  }

  void get_privilege_set(PrincipalPrivilegeSet& _return, const HiveObjectRef& hiveObject, const std::string& user_name, const std::vector<std::string> & group_names) {
    // Your implementation goes here
    printf("get_privilege_set\n");
  }

  void list_privileges(std::vector<HiveObjectPrivilege> & _return, const std::string& principal_name, const PrincipalType::type principal_type, const HiveObjectRef& hiveObject) {
    // Your implementation goes here
    printf("list_privileges\n");
  }

  bool grant_privileges(const PrivilegeBag& privileges) {
    // Your implementation goes here
    printf("grant_privileges\n");
  }

  bool revoke_privileges(const PrivilegeBag& privileges) {
    // Your implementation goes here
    printf("revoke_privileges\n");
  }

  void grant_revoke_privileges(GrantRevokePrivilegeResponse& _return, const GrantRevokePrivilegeRequest& request) {
    // Your implementation goes here
    printf("grant_revoke_privileges\n");
  }

  void refresh_privileges(GrantRevokePrivilegeResponse& _return, const HiveObjectRef& objToRefresh, const std::string& authorizer, const GrantRevokePrivilegeRequest& grantRequest) {
    // Your implementation goes here
    printf("refresh_privileges\n");
  }

  void set_ugi(std::vector<std::string> & _return, const std::string& user_name, const std::vector<std::string> & group_names) {
    // Your implementation goes here
    printf("set_ugi\n");
  }

  void get_delegation_token(std::string& _return, const std::string& token_owner, const std::string& renewer_kerberos_principal_name) {
    // Your implementation goes here
    printf("get_delegation_token\n");
  }

  int64_t renew_delegation_token(const std::string& token_str_form) {
    // Your implementation goes here
    printf("renew_delegation_token\n");
  }

  void cancel_delegation_token(const std::string& token_str_form) {
    // Your implementation goes here
    printf("cancel_delegation_token\n");
  }

  bool add_token(const std::string& token_identifier, const std::string& delegation_token) {
    // Your implementation goes here
    printf("add_token\n");
  }

  bool remove_token(const std::string& token_identifier) {
    // Your implementation goes here
    printf("remove_token\n");
  }

  void get_token(std::string& _return, const std::string& token_identifier) {
    // Your implementation goes here
    printf("get_token\n");
  }

  void get_all_token_identifiers(std::vector<std::string> & _return) {
    // Your implementation goes here
    printf("get_all_token_identifiers\n");
  }

  int32_t add_master_key(const std::string& key) {
    // Your implementation goes here
    printf("add_master_key\n");
  }

  void update_master_key(const int32_t seq_number, const std::string& key) {
    // Your implementation goes here
    printf("update_master_key\n");
  }

  bool remove_master_key(const int32_t key_seq) {
    // Your implementation goes here
    printf("remove_master_key\n");
  }

  void get_master_keys(std::vector<std::string> & _return) {
    // Your implementation goes here
    printf("get_master_keys\n");
  }

  void get_open_txns(GetOpenTxnsResponse& _return) {
    // Your implementation goes here
    printf("get_open_txns\n");
  }

  void get_open_txns_info(GetOpenTxnsInfoResponse& _return) {
    // Your implementation goes here
    printf("get_open_txns_info\n");
  }

  void open_txns(OpenTxnsResponse& _return, const OpenTxnRequest& rqst) {
    // Your implementation goes here
    printf("open_txns\n");
  }

  void abort_txn(const AbortTxnRequest& rqst) {
    // Your implementation goes here
    printf("abort_txn\n");
  }

  void abort_txns(const AbortTxnsRequest& rqst) {
    // Your implementation goes here
    printf("abort_txns\n");
  }

  void commit_txn(const CommitTxnRequest& rqst) {
    // Your implementation goes here
    printf("commit_txn\n");
  }

  int64_t get_latest_txnid_in_conflict(const int64_t txnId) {
    // Your implementation goes here
    printf("get_latest_txnid_in_conflict\n");
  }

  void repl_tbl_writeid_state(const ReplTblWriteIdStateRequest& rqst) {
    // Your implementation goes here
    printf("repl_tbl_writeid_state\n");
  }

  void get_valid_write_ids(GetValidWriteIdsResponse& _return, const GetValidWriteIdsRequest& rqst) {
    // Your implementation goes here
    printf("get_valid_write_ids\n");
  }

  void add_write_ids_to_min_history(const int64_t txnId, const std::map<std::string, int64_t> & writeIds) {
    // Your implementation goes here
    printf("add_write_ids_to_min_history\n");
  }

  void allocate_table_write_ids(AllocateTableWriteIdsResponse& _return, const AllocateTableWriteIdsRequest& rqst) {
    // Your implementation goes here
    printf("allocate_table_write_ids\n");
  }

  void get_max_allocated_table_write_id(MaxAllocatedTableWriteIdResponse& _return, const MaxAllocatedTableWriteIdRequest& rqst) {
    // Your implementation goes here
    printf("get_max_allocated_table_write_id\n");
  }

  void seed_write_id(const SeedTableWriteIdsRequest& rqst) {
    // Your implementation goes here
    printf("seed_write_id\n");
  }

  void seed_txn_id(const SeedTxnIdRequest& rqst) {
    // Your implementation goes here
    printf("seed_txn_id\n");
  }

  void lock(LockResponse& _return, const LockRequest& rqst) {
    // Your implementation goes here
    printf("lock\n");
  }

  void check_lock(LockResponse& _return, const CheckLockRequest& rqst) {
    // Your implementation goes here
    printf("check_lock\n");
  }

  void unlock(const UnlockRequest& rqst) {
    // Your implementation goes here
    printf("unlock\n");
  }

  void show_locks(ShowLocksResponse& _return, const ShowLocksRequest& rqst) {
    // Your implementation goes here
    printf("show_locks\n");
  }

  void heartbeat(const HeartbeatRequest& ids) {
    // Your implementation goes here
    printf("heartbeat\n");
  }

  void heartbeat_txn_range(HeartbeatTxnRangeResponse& _return, const HeartbeatTxnRangeRequest& txns) {
    // Your implementation goes here
    printf("heartbeat_txn_range\n");
  }

  void compact(const CompactionRequest& rqst) {
    // Your implementation goes here
    printf("compact\n");
  }

  void compact2(CompactionResponse& _return, const CompactionRequest& rqst) {
    // Your implementation goes here
    printf("compact2\n");
  }

  void show_compact(ShowCompactResponse& _return, const ShowCompactRequest& rqst) {
    // Your implementation goes here
    printf("show_compact\n");
  }

  bool submit_for_cleanup(const CompactionRequest& o1, const int64_t o2, const int64_t o3) {
    // Your implementation goes here
    printf("submit_for_cleanup\n");
  }

  void add_dynamic_partitions(const AddDynamicPartitions& rqst) {
    // Your implementation goes here
    printf("add_dynamic_partitions\n");
  }

  void find_next_compact(OptionalCompactionInfoStruct& _return, const std::string& workerId) {
    // Your implementation goes here
    printf("find_next_compact\n");
  }

  void find_next_compact2(OptionalCompactionInfoStruct& _return, const FindNextCompactRequest& rqst) {
    // Your implementation goes here
    printf("find_next_compact2\n");
  }

  void update_compactor_state(const CompactionInfoStruct& cr, const int64_t txn_id) {
    // Your implementation goes here
    printf("update_compactor_state\n");
  }

  void find_columns_with_stats(std::vector<std::string> & _return, const CompactionInfoStruct& cr) {
    // Your implementation goes here
    printf("find_columns_with_stats\n");
  }

  void mark_cleaned(const CompactionInfoStruct& cr) {
    // Your implementation goes here
    printf("mark_cleaned\n");
  }

  void mark_compacted(const CompactionInfoStruct& cr) {
    // Your implementation goes here
    printf("mark_compacted\n");
  }

  void mark_failed(const CompactionInfoStruct& cr) {
    // Your implementation goes here
    printf("mark_failed\n");
  }

  void mark_refused(const CompactionInfoStruct& cr) {
    // Your implementation goes here
    printf("mark_refused\n");
  }

  bool update_compaction_metrics_data(const CompactionMetricsDataStruct& data) {
    // Your implementation goes here
    printf("update_compaction_metrics_data\n");
  }

  void remove_compaction_metrics_data(const CompactionMetricsDataRequest& request) {
    // Your implementation goes here
    printf("remove_compaction_metrics_data\n");
  }

  void set_hadoop_jobid(const std::string& jobId, const int64_t cq_id) {
    // Your implementation goes here
    printf("set_hadoop_jobid\n");
  }

  void get_latest_committed_compaction_info(GetLatestCommittedCompactionInfoResponse& _return, const GetLatestCommittedCompactionInfoRequest& rqst) {
    // Your implementation goes here
    printf("get_latest_committed_compaction_info\n");
  }

  void get_next_notification(NotificationEventResponse& _return, const NotificationEventRequest& rqst) {
    // Your implementation goes here
    printf("get_next_notification\n");
  }

  void get_current_notificationEventId(CurrentNotificationEventId& _return) {
    // Your implementation goes here
    printf("get_current_notificationEventId\n");
  }

  void get_notification_events_count(NotificationEventsCountResponse& _return, const NotificationEventsCountRequest& rqst) {
    // Your implementation goes here
    printf("get_notification_events_count\n");
  }

  void fire_listener_event(FireEventResponse& _return, const FireEventRequest& rqst) {
    // Your implementation goes here
    printf("fire_listener_event\n");
  }

  void flushCache() {
    // Your implementation goes here
    printf("flushCache\n");
  }

  void add_write_notification_log(WriteNotificationLogResponse& _return, const WriteNotificationLogRequest& rqst) {
    // Your implementation goes here
    printf("add_write_notification_log\n");
  }

  void add_write_notification_log_in_batch(WriteNotificationLogBatchResponse& _return, const WriteNotificationLogBatchRequest& rqst) {
    // Your implementation goes here
    printf("add_write_notification_log_in_batch\n");
  }

  void cm_recycle(CmRecycleResponse& _return, const CmRecycleRequest& request) {
    // Your implementation goes here
    printf("cm_recycle\n");
  }

  void get_file_metadata_by_expr(GetFileMetadataByExprResult& _return, const GetFileMetadataByExprRequest& req) {
    // Your implementation goes here
    printf("get_file_metadata_by_expr\n");
  }

  void get_file_metadata(GetFileMetadataResult& _return, const GetFileMetadataRequest& req) {
    // Your implementation goes here
    printf("get_file_metadata\n");
  }

  void put_file_metadata(PutFileMetadataResult& _return, const PutFileMetadataRequest& req) {
    // Your implementation goes here
    printf("put_file_metadata\n");
  }

  void clear_file_metadata(ClearFileMetadataResult& _return, const ClearFileMetadataRequest& req) {
    // Your implementation goes here
    printf("clear_file_metadata\n");
  }

  void cache_file_metadata(CacheFileMetadataResult& _return, const CacheFileMetadataRequest& req) {
    // Your implementation goes here
    printf("cache_file_metadata\n");
  }

  void get_metastore_db_uuid(std::string& _return) {
    // Your implementation goes here
    printf("get_metastore_db_uuid\n");
  }

  void create_resource_plan(WMCreateResourcePlanResponse& _return, const WMCreateResourcePlanRequest& request) {
    // Your implementation goes here
    printf("create_resource_plan\n");
  }

  void get_resource_plan(WMGetResourcePlanResponse& _return, const WMGetResourcePlanRequest& request) {
    // Your implementation goes here
    printf("get_resource_plan\n");
  }

  void get_active_resource_plan(WMGetActiveResourcePlanResponse& _return, const WMGetActiveResourcePlanRequest& request) {
    // Your implementation goes here
    printf("get_active_resource_plan\n");
  }

  void get_all_resource_plans(WMGetAllResourcePlanResponse& _return, const WMGetAllResourcePlanRequest& request) {
    // Your implementation goes here
    printf("get_all_resource_plans\n");
  }

  void alter_resource_plan(WMAlterResourcePlanResponse& _return, const WMAlterResourcePlanRequest& request) {
    // Your implementation goes here
    printf("alter_resource_plan\n");
  }

  void validate_resource_plan(WMValidateResourcePlanResponse& _return, const WMValidateResourcePlanRequest& request) {
    // Your implementation goes here
    printf("validate_resource_plan\n");
  }

  void drop_resource_plan(WMDropResourcePlanResponse& _return, const WMDropResourcePlanRequest& request) {
    // Your implementation goes here
    printf("drop_resource_plan\n");
  }

  void create_wm_trigger(WMCreateTriggerResponse& _return, const WMCreateTriggerRequest& request) {
    // Your implementation goes here
    printf("create_wm_trigger\n");
  }

  void alter_wm_trigger(WMAlterTriggerResponse& _return, const WMAlterTriggerRequest& request) {
    // Your implementation goes here
    printf("alter_wm_trigger\n");
  }

  void drop_wm_trigger(WMDropTriggerResponse& _return, const WMDropTriggerRequest& request) {
    // Your implementation goes here
    printf("drop_wm_trigger\n");
  }

  void get_triggers_for_resourceplan(WMGetTriggersForResourePlanResponse& _return, const WMGetTriggersForResourePlanRequest& request) {
    // Your implementation goes here
    printf("get_triggers_for_resourceplan\n");
  }

  void create_wm_pool(WMCreatePoolResponse& _return, const WMCreatePoolRequest& request) {
    // Your implementation goes here
    printf("create_wm_pool\n");
  }

  void alter_wm_pool(WMAlterPoolResponse& _return, const WMAlterPoolRequest& request) {
    // Your implementation goes here
    printf("alter_wm_pool\n");
  }

  void drop_wm_pool(WMDropPoolResponse& _return, const WMDropPoolRequest& request) {
    // Your implementation goes here
    printf("drop_wm_pool\n");
  }

  void create_or_update_wm_mapping(WMCreateOrUpdateMappingResponse& _return, const WMCreateOrUpdateMappingRequest& request) {
    // Your implementation goes here
    printf("create_or_update_wm_mapping\n");
  }

  void drop_wm_mapping(WMDropMappingResponse& _return, const WMDropMappingRequest& request) {
    // Your implementation goes here
    printf("drop_wm_mapping\n");
  }

  void create_or_drop_wm_trigger_to_pool_mapping(WMCreateOrDropTriggerToPoolMappingResponse& _return, const WMCreateOrDropTriggerToPoolMappingRequest& request) {
    // Your implementation goes here
    printf("create_or_drop_wm_trigger_to_pool_mapping\n");
  }

  void create_ischema(const ISchema& schema) {
    // Your implementation goes here
    printf("create_ischema\n");
  }

  void alter_ischema(const AlterISchemaRequest& rqst) {
    // Your implementation goes here
    printf("alter_ischema\n");
  }

  void get_ischema(ISchema& _return, const ISchemaName& name) {
    // Your implementation goes here
    printf("get_ischema\n");
  }

  void drop_ischema(const ISchemaName& name) {
    // Your implementation goes here
    printf("drop_ischema\n");
  }

  void add_schema_version(const SchemaVersion& schemaVersion) {
    // Your implementation goes here
    printf("add_schema_version\n");
  }

  void get_schema_version(SchemaVersion& _return, const SchemaVersionDescriptor& schemaVersion) {
    // Your implementation goes here
    printf("get_schema_version\n");
  }

  void get_schema_latest_version(SchemaVersion& _return, const ISchemaName& schemaName) {
    // Your implementation goes here
    printf("get_schema_latest_version\n");
  }

  void get_schema_all_versions(std::vector<SchemaVersion> & _return, const ISchemaName& schemaName) {
    // Your implementation goes here
    printf("get_schema_all_versions\n");
  }

  void drop_schema_version(const SchemaVersionDescriptor& schemaVersion) {
    // Your implementation goes here
    printf("drop_schema_version\n");
  }

  void get_schemas_by_cols(FindSchemasByColsResp& _return, const FindSchemasByColsRqst& rqst) {
    // Your implementation goes here
    printf("get_schemas_by_cols\n");
  }

  void map_schema_version_to_serde(const MapSchemaVersionToSerdeRequest& rqst) {
    // Your implementation goes here
    printf("map_schema_version_to_serde\n");
  }

  void set_schema_version_state(const SetSchemaVersionStateRequest& rqst) {
    // Your implementation goes here
    printf("set_schema_version_state\n");
  }

  void add_serde(const SerDeInfo& serde) {
    // Your implementation goes here
    printf("add_serde\n");
  }

  void get_serde(SerDeInfo& _return, const GetSerdeRequest& rqst) {
    // Your implementation goes here
    printf("get_serde\n");
  }

  void get_lock_materialization_rebuild(LockResponse& _return, const std::string& dbName, const std::string& tableName, const int64_t txnId) {
    // Your implementation goes here
    printf("get_lock_materialization_rebuild\n");
  }

  bool heartbeat_lock_materialization_rebuild(const std::string& dbName, const std::string& tableName, const int64_t txnId) {
    // Your implementation goes here
    printf("heartbeat_lock_materialization_rebuild\n");
  }

  void add_runtime_stats(const RuntimeStat& stat) {
    // Your implementation goes here
    printf("add_runtime_stats\n");
  }

  void get_runtime_stats(std::vector<RuntimeStat> & _return, const GetRuntimeStatsRequest& rqst) {
    // Your implementation goes here
    printf("get_runtime_stats\n");
  }

  void get_partitions_with_specs(GetPartitionsResponse& _return, const GetPartitionsRequest& request) {
    // Your implementation goes here
    printf("get_partitions_with_specs\n");
  }

  void scheduled_query_poll(ScheduledQueryPollResponse& _return, const ScheduledQueryPollRequest& request) {
    // Your implementation goes here
    printf("scheduled_query_poll\n");
  }

  void scheduled_query_maintenance(const ScheduledQueryMaintenanceRequest& request) {
    // Your implementation goes here
    printf("scheduled_query_maintenance\n");
  }

  void scheduled_query_progress(const ScheduledQueryProgressInfo& info) {
    // Your implementation goes here
    printf("scheduled_query_progress\n");
  }

  void get_scheduled_query(ScheduledQuery& _return, const ScheduledQueryKey& scheduleKey) {
    // Your implementation goes here
    printf("get_scheduled_query\n");
  }

  void add_replication_metrics(const ReplicationMetricList& replicationMetricList) {
    // Your implementation goes here
    printf("add_replication_metrics\n");
  }

  void get_replication_metrics(ReplicationMetricList& _return, const GetReplicationMetricsRequest& rqst) {
    // Your implementation goes here
    printf("get_replication_metrics\n");
  }

  void get_open_txns_req(GetOpenTxnsResponse& _return, const GetOpenTxnsRequest& getOpenTxnsRequest) {
    // Your implementation goes here
    printf("get_open_txns_req\n");
  }

  void create_stored_procedure(const StoredProcedure& proc) {
    // Your implementation goes here
    printf("create_stored_procedure\n");
  }

  void get_stored_procedure(StoredProcedure& _return, const StoredProcedureRequest& request) {
    // Your implementation goes here
    printf("get_stored_procedure\n");
  }

  void drop_stored_procedure(const StoredProcedureRequest& request) {
    // Your implementation goes here
    printf("drop_stored_procedure\n");
  }

  void get_all_stored_procedures(std::vector<std::string> & _return, const ListStoredProcedureRequest& request) {
    // Your implementation goes here
    printf("get_all_stored_procedures\n");
  }

  void find_package(Package& _return, const GetPackageRequest& request) {
    // Your implementation goes here
    printf("find_package\n");
  }

  void add_package(const AddPackageRequest& request) {
    // Your implementation goes here
    printf("add_package\n");
  }

  void get_all_packages(std::vector<std::string> & _return, const ListPackageRequest& request) {
    // Your implementation goes here
    printf("get_all_packages\n");
  }

  void drop_package(const DropPackageRequest& request) {
    // Your implementation goes here
    printf("drop_package\n");
  }

  void get_all_write_event_info(std::vector<WriteEventInfo> & _return, const GetAllWriteEventInfoRequest& request) {
    // Your implementation goes here
    printf("get_all_write_event_info\n");
  }

};

int main(int argc, char **argv) {
  int port = 9090;
  ::std::shared_ptr<ThriftHiveMetastoreHandler> handler(new ThriftHiveMetastoreHandler());
  ::std::shared_ptr<TProcessor> processor(new ThriftHiveMetastoreProcessor(handler));
  ::std::shared_ptr<TServerTransport> serverTransport(new TServerSocket(port));
  ::std::shared_ptr<TTransportFactory> transportFactory(new TBufferedTransportFactory());
  ::std::shared_ptr<TProtocolFactory> protocolFactory(new TBinaryProtocolFactory());

  TSimpleServer server(processor, serverTransport, transportFactory, protocolFactory);
  server.serve();
  return 0;
}

