/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.client.task;

import com.alipay.sofa.registry.client.api.Register;
import com.alipay.sofa.registry.client.provider.AbstractInternalRegister;
import com.alipay.sofa.registry.client.task.TaskEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TaskQueue
implements Iterable<TaskEvent> {
    private final ConcurrentMap<String, TaskEvent> taskMap = new ConcurrentHashMap<String, TaskEvent>();

    @Override
    public Iterator<TaskEvent> iterator() {
        ArrayList taskList = new ArrayList(this.taskMap.values());
        Collections.sort(taskList);
        return taskList.iterator();
    }

    public void cleanCompletedTasks() {
        ArrayList taskList = new ArrayList(this.taskMap.keySet());
        for (String key : taskList) {
            TaskEvent event = (TaskEvent)this.taskMap.get(key);
            AbstractInternalRegister r = (AbstractInternalRegister)event.getSource();
            if (!r.isDone()) continue;
            this.taskMap.remove(key, event);
        }
        this.taskMap.size();
    }

    public void put(TaskEvent event) {
        Register register = event.getSource();
        String key = register.getRegistId();
        this.taskMap.put(key, event);
    }

    public void putAll(List<TaskEvent> taskEvents) {
        for (TaskEvent event : taskEvents) {
            this.put(event);
        }
    }

    public boolean isEmpty() {
        return this.taskMap.isEmpty();
    }
}

