/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.remote.commands;

import io.github.bucket4j.distributed.remote.BucketEntryWrapper;
import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.MultiResult;
import io.github.bucket4j.distributed.remote.MutableBucketEntry;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.distributed.remote.RemoteCommand;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.Scope;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiCommand
implements RemoteCommand<MultiResult>,
ComparableByContent<MultiCommand> {
    private List<RemoteCommand<?>> commands;
    public static SerializationHandle<MultiCommand> SERIALIZATION_HANDLE = new SerializationHandle<MultiCommand>(){

        @Override
        public <S> MultiCommand deserialize(DeserializationAdapter<S> adapter, S input) throws IOException {
            int formatNumber = adapter.readInt(input);
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            int size = adapter.readInt(input);
            ArrayList results = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                RemoteCommand<?> result = RemoteCommand.deserialize(adapter, input);
                results.add(result);
            }
            return new MultiCommand(results);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, MultiCommand multiCommand, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            adapter.writeInt(output, Versions.v_7_0_0.getNumber());
            adapter.writeInt(output, multiCommand.commands.size());
            for (RemoteCommand command : multiCommand.commands) {
                RemoteCommand.serialize(adapter, output, command, backwardCompatibilityVersion, scope);
            }
        }

        @Override
        public int getTypeId() {
            return 22;
        }

        @Override
        public Class<MultiCommand> getSerializedType() {
            return MultiCommand.class;
        }

        @Override
        public MultiCommand fromJsonCompatibleSnapshot(Map<String, Object> snapshot) throws IOException {
            int formatNumber = this.readIntValue(snapshot, "version");
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            List commandSnapshots = (List)snapshot.get("commands");
            ArrayList commands = new ArrayList(commandSnapshots.size());
            for (Map commandSnapshot : commandSnapshots) {
                RemoteCommand<?> targetCommand = RemoteCommand.fromJsonCompatibleSnapshot(commandSnapshot);
                commands.add(targetCommand);
            }
            return new MultiCommand(commands);
        }

        @Override
        public Map<String, Object> toJsonCompatibleSnapshot(MultiCommand command, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("version", Versions.v_7_0_0.getNumber());
            ArrayList<Map<String, Object>> commandSnapshots = new ArrayList<Map<String, Object>>(command.commands.size());
            for (RemoteCommand remoteCommand : command.commands) {
                commandSnapshots.add(RemoteCommand.toJsonCompatibleSnapshot(remoteCommand, backwardCompatibilityVersion, scope));
            }
            result.put("commands", commandSnapshots);
            return result;
        }

        @Override
        public String getTypeName() {
            return "MultiCommand";
        }
    };

    public MultiCommand(List<RemoteCommand<?>> commands) {
        this.commands = commands;
    }

    @Override
    public CommandResult<MultiResult> execute(MutableBucketEntry mutableEntry, long currentTimeNanos) {
        RemoteBucketState startingState = mutableEntry.exists() ? mutableEntry.get() : null;
        BucketEntryWrapper entryWrapper = new BucketEntryWrapper(startingState);
        ArrayList singleResults = new ArrayList(this.commands.size());
        for (RemoteCommand<?> singleCommand : this.commands) {
            singleResults.add(singleCommand.execute(entryWrapper, currentTimeNanos));
        }
        if (entryWrapper.isStateModified()) {
            mutableEntry.set(entryWrapper.get());
        }
        return CommandResult.success(new MultiResult(singleResults), MultiResult.SERIALIZATION_HANDLE);
    }

    @Override
    public boolean isInitializationCommand() {
        for (RemoteCommand<?> command : this.commands) {
            if (!command.isInitializationCommand()) continue;
            return true;
        }
        return false;
    }

    public List<RemoteCommand<?>> getCommands() {
        return this.commands;
    }

    @Override
    public SerializationHandle getSerializationHandle() {
        return SERIALIZATION_HANDLE;
    }

    @Override
    public boolean equalsByContent(MultiCommand other) {
        if (this.commands.size() != other.commands.size()) {
            return false;
        }
        for (int i = 0; i < this.commands.size(); ++i) {
            RemoteCommand<?> command2;
            RemoteCommand<?> command1 = this.commands.get(i);
            if (ComparableByContent.equals(command1, command2 = other.commands.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isImmediateSyncRequired(long unsynchronizedTokens, long nanosSinceLastSync) {
        for (RemoteCommand<?> command : this.commands) {
            if (!command.isImmediateSyncRequired(unsynchronizedTokens, nanosSinceLastSync)) continue;
            return true;
        }
        return false;
    }

    @Override
    public long estimateTokensToConsume() {
        long sum = 0L;
        for (RemoteCommand<?> command : this.commands) {
            if ((sum += command.estimateTokensToConsume()) >= 0L) continue;
            return Long.MAX_VALUE;
        }
        return sum;
    }

    @Override
    public long getConsumedTokens(MultiResult multiResult) {
        long sum = 0L;
        int count = this.commands.size();
        for (int i = 0; i < count; ++i) {
            RemoteCommand<?> command = this.commands.get(i);
            CommandResult<?> result = multiResult.getResults().get(i);
            if ((sum += result.isError() ? 0L : command.getConsumedTokens(result.getData())) >= 0L) continue;
            return Long.MAX_VALUE;
        }
        return sum;
    }

    @Override
    public Version getRequiredVersion() {
        Version max = Versions.v_7_0_0;
        for (RemoteCommand<?> command : this.commands) {
            max = Versions.max(max, command.getRequiredVersion());
        }
        return max;
    }
}

