/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.cluster.raft.execute.global;

import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.seata.common.thread.NamedThreadFactory;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.server.cluster.raft.execute.AbstractRaftMsgExecute;
import org.apache.seata.server.cluster.raft.sync.msg.RaftBaseMsg;
import org.apache.seata.server.cluster.raft.sync.msg.RaftGlobalSessionSyncMsg;
import org.apache.seata.server.session.SessionHolder;
import org.apache.seata.server.storage.raft.session.RaftSessionManager;

public class RemoveGlobalSessionExecute
extends AbstractRaftMsgExecute {
    private static final ThreadPoolExecutor EXECUTOR = new ThreadPoolExecutor(1, 1, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(2048), (ThreadFactory)new NamedThreadFactory("RemoveGlobalSessionExecute", 1), new ThreadPoolExecutor.CallerRunsPolicy());

    public Boolean execute(RaftBaseMsg syncMsg) throws Throwable {
        RaftGlobalSessionSyncMsg sessionSyncMsg = (RaftGlobalSessionSyncMsg)syncMsg;
        RaftSessionManager raftSessionManager = (RaftSessionManager)SessionHolder.getRootSessionManager((String)sessionSyncMsg.getGroup());
        Optional.ofNullable(raftSessionManager.findGlobalSession(sessionSyncMsg.getGlobalSession().getXid())).ifPresent(globalSession -> {
            try {
                this.raftLockManager.localReleaseGlobalSessionLock(globalSession);
                EXECUTOR.execute(() -> {
                    try {
                        raftSessionManager.removeGlobalSession(globalSession);
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("remove session xid: {}", (Object)globalSession.getXid());
                        }
                    }
                    catch (TransactionException e) {
                        this.logger.error("remove global fail error:{}", (Object)e.getMessage());
                    }
                });
            }
            catch (TransactionException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        });
        return true;
    }
}

