/*
 * Decompiled with CFR 0.152.
 */
package zmq.io.coder.v2;

import java.nio.ByteBuffer;
import zmq.io.coder.Encoder;
import zmq.util.Errno;
import zmq.util.Wire;

public class V2Encoder
extends Encoder {
    private final ByteBuffer tmpbufWrap = ByteBuffer.allocate(9);

    public V2Encoder(Errno errno, int bufsize) {
        super(errno, bufsize);
        this.initStep(this.messageReady, true);
    }

    @Override
    protected void messageReady() {
        byte protocolFlags = 0;
        if (this.inProgress.hasMore()) {
            protocolFlags = (byte)(protocolFlags | 1);
        }
        if (this.inProgress.size() > 255) {
            protocolFlags = (byte)(protocolFlags | 2);
        }
        if (this.inProgress.isCommand()) {
            protocolFlags = (byte)(protocolFlags | 4);
        }
        int size2 = this.inProgress.size();
        this.tmpbufWrap.position(0);
        this.tmpbufWrap.put(protocolFlags);
        if (size2 > 255) {
            this.tmpbufWrap.limit(9);
            Wire.putUInt64(this.tmpbufWrap, size2);
        } else {
            this.tmpbufWrap.limit(2);
            this.tmpbufWrap.put((byte)size2);
        }
        this.nextStep(this.tmpbufWrap, this.tmpbufWrap.limit(), this.sizeReady, false);
    }

    @Override
    protected void sizeReady() {
        this.nextStep(this.inProgress.buf(), this.inProgress.size(), this.messageReady, true);
    }
}

