/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.validation.constraints.NotNull;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.IoTDBRuntimeException;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.protocol.session.IClientSession;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.execution.QueryStateMachine;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.execution.ExecutionResult;
import org.apache.iotdb.db.queryengine.plan.execution.IQueryExecution;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.ClusterConfigTaskExecutor;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.column.TsBlockSerde;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigExecution
implements IQueryExecution {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigExecution.class);
    private static final TsBlockSerde serde = new TsBlockSerde();
    private static final Set<Integer> userExceptionCodes = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(TSStatusCode.DATABASE_NOT_EXIST.getStatusCode(), TSStatusCode.DATABASE_ALREADY_EXISTS.getStatusCode(), TSStatusCode.DATABASE_CONFLICT.getStatusCode(), TSStatusCode.DATABASE_CONFIG_ERROR.getStatusCode(), TSStatusCode.PATH_NOT_EXIST.getStatusCode(), TSStatusCode.MEASUREMENT_ALREADY_EXISTS_IN_TEMPLATE.getStatusCode(), TSStatusCode.SCHEMA_QUOTA_EXCEEDED.getStatusCode(), TSStatusCode.TABLE_ALREADY_EXISTS.getStatusCode(), TSStatusCode.TABLE_NOT_EXISTS.getStatusCode(), TSStatusCode.COLUMN_ALREADY_EXISTS.getStatusCode(), TSStatusCode.COLUMN_NOT_EXISTS.getStatusCode(), TSStatusCode.COLUMN_CATEGORY_MISMATCH.getStatusCode(), TSStatusCode.DATABASE_MODEL.getStatusCode(), TSStatusCode.DATABASE_CONFLICT.getStatusCode(), TSStatusCode.TEMPLATE_IS_IN_USE.getStatusCode(), TSStatusCode.TEMPLATE_NOT_SET.getStatusCode(), TSStatusCode.TEMPLATE_INCOMPATIBLE.getStatusCode(), TSStatusCode.UNDEFINED_TEMPLATE.getStatusCode(), TSStatusCode.TEMPLATE_NOT_ACTIVATED.getStatusCode(), TSStatusCode.USER_ALREADY_EXIST.getStatusCode(), TSStatusCode.USER_NOT_EXIST.getStatusCode(), TSStatusCode.NO_PERMISSION.getStatusCode(), TSStatusCode.NOT_HAS_PRIVILEGE.getStatusCode(), TSStatusCode.ROLE_ALREADY_EXIST.getStatusCode(), TSStatusCode.ROLE_NOT_EXIST.getStatusCode(), TSStatusCode.USER_ALREADY_HAS_ROLE.getStatusCode(), TSStatusCode.USER_NOT_HAS_ROLE.getStatusCode(), TSStatusCode.NOT_HAS_PRIVILEGE_GRANTOPT.getStatusCode(), TSStatusCode.SEMANTIC_ERROR.getStatusCode(), TSStatusCode.NO_SUCH_QUERY.getStatusCode())));
    private final MPPQueryContext context;
    private final ExecutorService executor;
    private final QueryStateMachine stateMachine;
    private final SettableFuture<ConfigTaskResult> taskFuture;
    private TsBlock resultSet;
    private DatasetHeader datasetHeader;
    private boolean resultSetConsumed;
    private final IConfigTask task;
    private final IConfigTaskExecutor configTaskExecutor;
    private final StatementType statementType;
    private long totalExecutionTime;

    public ConfigExecution(MPPQueryContext context, StatementType statementType, ExecutorService executor, IConfigTask task) {
        this.context = context;
        this.statementType = statementType;
        this.executor = executor;
        this.stateMachine = new QueryStateMachine(context.getQueryId(), executor);
        this.taskFuture = SettableFuture.create();
        this.task = task;
        this.resultSetConsumed = false;
        this.configTaskExecutor = ClusterConfigTaskExecutor.getInstance();
    }

    @TestOnly
    public ConfigExecution(MPPQueryContext context, ExecutorService executor, IConfigTask task) {
        this(context, StatementType.NULL, executor, task);
    }

    @Override
    public void start() {
        try {
            ListenableFuture<ConfigTaskResult> future = this.task.execute(this.configTaskExecutor);
            Futures.addCallback(future, (FutureCallback)new FutureCallback<ConfigTaskResult>(){

                public void onSuccess(ConfigTaskResult taskRet) {
                    ConfigExecution.this.stateMachine.transitionToFinished();
                    ConfigExecution.this.taskFuture.set((Object)taskRet);
                }

                public void onFailure(@NotNull Throwable throwable) {
                    ConfigExecution.this.fail(throwable);
                }
            }, (Executor)this.executor);
        }
        catch (Throwable e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            this.fail(e);
        }
    }

    private void fail(Throwable cause) {
        int errorCode = TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode();
        if (cause instanceof IoTDBException) {
            errorCode = ((IoTDBException)cause).getErrorCode();
        } else if (cause instanceof IoTDBRuntimeException) {
            errorCode = ((IoTDBRuntimeException)cause).getErrorCode();
        }
        if (!userExceptionCodes.contains(errorCode)) {
            LOGGER.warn("Failures happened during running ConfigExecution when executing {}.", Objects.nonNull(this.task) ? this.task.getClass().getSimpleName() : null, (Object)cause);
        } else {
            LOGGER.info("Failures happened during running ConfigExecution when executing {}, message: {}, status: {}", new Object[]{Objects.nonNull(this.task) ? this.task.getClass().getSimpleName() : null, cause.getMessage(), errorCode});
        }
        this.stateMachine.transitionToFailed(cause);
        ConfigTaskResult result = cause instanceof StatementExecutionException ? new ConfigTaskResult(TSStatusCode.representOf((int)((StatementExecutionException)cause).getStatusCode())) : new ConfigTaskResult(TSStatusCode.representOf((int)errorCode));
        this.taskFuture.set((Object)result);
    }

    @Override
    public void stop(Throwable t) {
    }

    @Override
    public void stopAndCleanup() {
    }

    @Override
    public void stopAndCleanup(Throwable t) {
    }

    @Override
    public void cancel() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public ExecutionResult getStatus() {
        try {
            ConfigTaskResult taskResult = (ConfigTaskResult)this.taskFuture.get();
            TSStatusCode statusCode = taskResult.getStatusCode();
            this.resultSet = taskResult.getResultSet();
            this.datasetHeader = taskResult.getResultSetHeader();
            String message = statusCode == TSStatusCode.SUCCESS_STATUS ? "" : this.stateMachine.getFailureMessage();
            return new ExecutionResult(this.context.getQueryId(), RpcUtils.getStatus((TSStatusCode)statusCode, (String)message));
        }
        catch (InterruptedException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            return new ExecutionResult(this.context.getQueryId(), RpcUtils.getStatus((TSStatusCode)TSStatusCode.QUERY_PROCESS_ERROR, (String)e.getMessage()));
        }
    }

    @Override
    public Optional<TsBlock> getBatchResult() {
        if (!this.resultSetConsumed) {
            this.resultSetConsumed = true;
            return Optional.of(this.resultSet);
        }
        return Optional.empty();
    }

    @Override
    public Optional<ByteBuffer> getByteBufferBatchResult() throws IoTDBException {
        if (!this.resultSetConsumed) {
            this.resultSetConsumed = true;
            try {
                return Optional.of(serde.serialize(this.resultSet));
            }
            catch (IOException e) {
                throw new IoTDBException((Throwable)e, TSStatusCode.TSBLOCK_SERIALIZE_ERROR.getStatusCode());
            }
        }
        return Optional.empty();
    }

    @Override
    public boolean hasNextResult() {
        return !this.resultSetConsumed && this.resultSet != null;
    }

    @Override
    public int getOutputValueColumnCount() {
        return this.datasetHeader.getOutputValueColumnCount();
    }

    @Override
    public DatasetHeader getDatasetHeader() {
        return this.datasetHeader;
    }

    @Override
    public boolean isQuery() {
        return this.context.getQueryType() == QueryType.READ;
    }

    @Override
    public boolean isUserQuery() {
        return this.context.isUserQuery();
    }

    @Override
    public String getQueryId() {
        return this.context.getQueryId().getId();
    }

    @Override
    public long getStartExecutionTime() {
        return this.context.getStartTime();
    }

    @Override
    public void recordExecutionTime(long executionTime) {
        this.totalExecutionTime += executionTime;
    }

    @Override
    public long getTotalExecutionTime() {
        return this.totalExecutionTime;
    }

    @Override
    public Optional<String> getExecuteSQL() {
        return Optional.ofNullable(this.context.getSql());
    }

    @Override
    public String getStatementType() {
        return this.statementType == null ? null : this.statementType.name();
    }

    @Override
    public IClientSession.SqlDialect getSQLDialect() {
        return this.context.getSession().getSqlDialect();
    }

    @Override
    public String getUser() {
        return this.context.getSession().getUserName();
    }
}

