/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.memtable;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.storageengine.dataregion.memtable.AlignedWritableMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IWritableMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IWritableMemChunkGroup;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModEntry;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.IWALByteBufferView;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class AlignedWritableMemChunkGroup
implements IWritableMemChunkGroup {
    private AlignedWritableMemChunk memChunk;

    public AlignedWritableMemChunkGroup(List<IMeasurementSchema> schemaList, boolean isTableModel) {
        this.memChunk = new AlignedWritableMemChunk(schemaList, isTableModel);
    }

    @TestOnly
    public AlignedWritableMemChunkGroup(AlignedWritableMemChunk memChunk, List<IMeasurementSchema> schemaList, boolean isTableModel) {
        this.memChunk = memChunk;
    }

    private AlignedWritableMemChunkGroup() {
    }

    @Override
    public void writeTablet(long[] times, Object[] columns, BitMap[] bitMaps, List<IMeasurementSchema> schemaList, int start, int end, TSStatus[] results) {
        this.memChunk.writeAlignedTablet(times, columns, bitMaps, schemaList, start, end, results);
    }

    @Override
    public void release() {
        this.memChunk.release();
    }

    @Override
    public long count() {
        return this.memChunk.count();
    }

    @Override
    public boolean contains(String measurement) {
        if ("".equals(measurement)) {
            return true;
        }
        return this.memChunk.containsMeasurement(measurement);
    }

    @Override
    public void writeRow(long insertTime, Object[] objectValue, List<IMeasurementSchema> schemaList) {
        this.memChunk.writeAlignedPoints(insertTime, objectValue, schemaList);
    }

    @Override
    public Map<String, IWritableMemChunk> getMemChunkMap() {
        if (this.memChunk.count() == 0L) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap("", this.memChunk);
    }

    @Override
    public boolean isEmpty() {
        return this.memChunk.isEmpty() || this.memChunk.isAllDeleted();
    }

    @Override
    public long delete(ModEntry modEntry) {
        int deletedPointsNumber = 0;
        Set<String> measurements = this.memChunk.getAllMeasurements();
        ArrayList<String> columnsToBeRemoved = new ArrayList<String>();
        for (String measurement : measurements) {
            if (!modEntry.affects(measurement)) continue;
            Pair<Integer, Boolean> deletedNumAndIsFullyDeleted = this.memChunk.deleteDataFromAColumn(modEntry.getStartTime(), modEntry.getEndTime(), measurement);
            deletedPointsNumber += ((Integer)deletedNumAndIsFullyDeleted.left).intValue();
            if (!Boolean.TRUE.equals(deletedNumAndIsFullyDeleted.right)) continue;
            columnsToBeRemoved.add(measurement);
        }
        for (String columnToBeRemoved : columnsToBeRemoved) {
            this.memChunk.removeColumn(columnToBeRemoved);
        }
        return deletedPointsNumber;
    }

    @Override
    public long deleteTime(ModEntry modEntry) {
        return this.memChunk.deleteTime(modEntry.getStartTime(), modEntry.getEndTime());
    }

    @Override
    public IWritableMemChunk getWritableMemChunk(String measurement) {
        return this.memChunk;
    }

    @Override
    public long getMaxTime() {
        return this.memChunk.getMaxTime();
    }

    public AlignedWritableMemChunk getAlignedMemChunk() {
        return this.memChunk;
    }

    @Override
    public int serializedSize() {
        return this.memChunk.serializedSize();
    }

    @Override
    public void serializeToWAL(IWALByteBufferView buffer) {
        this.memChunk.serializeToWAL(buffer);
    }

    protected static AlignedWritableMemChunkGroup deserialize(DataInputStream stream, boolean isTableModel) throws IOException {
        AlignedWritableMemChunkGroup memChunkGroup = new AlignedWritableMemChunkGroup();
        memChunkGroup.memChunk = AlignedWritableMemChunk.deserialize(stream, isTableModel);
        return memChunkGroup;
    }

    protected static AlignedWritableMemChunkGroup deserializeSingleTVListMemChunks(DataInputStream stream, boolean isTableModel) throws IOException {
        AlignedWritableMemChunkGroup memChunkGroup = new AlignedWritableMemChunkGroup();
        memChunkGroup.memChunk = AlignedWritableMemChunk.deserializeSingleTVListMemChunks(stream, isTableModel);
        return memChunkGroup;
    }
}

