/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer.region;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.manager.load.balancer.region.GreedyRegionGroupAllocator;
import org.apache.iotdb.confignode.manager.load.balancer.region.IRegionGroupAllocator;
import org.apache.tsfile.utils.Pair;

public class PartiteGraphPlacementRegionGroupAllocator
implements IRegionGroupAllocator {
    private static final GreedyRegionGroupAllocator GREEDY_ALLOCATOR = new GreedyRegionGroupAllocator();
    private int subGraphCount;
    private int replicationFactor;
    private int regionPerDataNode;
    private int dataNodeNum;
    private int[] regionCounter;
    private int[][] combinationCounter;
    private Map<Integer, Integer> fakeToRealIdMap;
    private int alphaDataNodeNum;
    Pair<Integer, Integer> bestValue;
    private int[] bestAlphaNodes;

    @Override
    public TRegionReplicaSet generateOptimalRegionReplicasDistribution(Map<Integer, TDataNodeConfiguration> availableDataNodeMap, Map<Integer, Double> freeDiskSpaceMap, List<TRegionReplicaSet> allocatedRegionGroups, List<TRegionReplicaSet> databaseAllocatedRegionGroups, int replicationFactor, TConsensusGroupId consensusGroupId) {
        int i;
        this.regionPerDataNode = consensusGroupId.getType().equals((Object)TConsensusGroupType.DataRegion) ? ConfigNodeDescriptor.getInstance().getConf().getDataRegionPerDataNode() : ConfigNodeDescriptor.getInstance().getConf().getSchemaRegionPerDataNode();
        this.prepare(replicationFactor, availableDataNodeMap, allocatedRegionGroups);
        for (int i2 = 0; i2 < this.subGraphCount; ++i2) {
            this.subGraphSearch(i2, freeDiskSpaceMap);
        }
        if ((Integer)this.bestValue.left == Integer.MAX_VALUE) {
            return GREEDY_ALLOCATOR.generateOptimalRegionReplicasDistribution(availableDataNodeMap, freeDiskSpaceMap, allocatedRegionGroups, databaseAllocatedRegionGroups, replicationFactor, consensusGroupId);
        }
        List<Integer> betaDataNodes = this.partiteGraphSearch(this.bestAlphaNodes[0] % this.subGraphCount);
        if (betaDataNodes.size() < replicationFactor - this.alphaDataNodeNum) {
            return GREEDY_ALLOCATOR.generateOptimalRegionReplicasDistribution(availableDataNodeMap, freeDiskSpaceMap, allocatedRegionGroups, databaseAllocatedRegionGroups, replicationFactor, consensusGroupId);
        }
        TRegionReplicaSet result = new TRegionReplicaSet();
        result.setRegionId(consensusGroupId);
        for (i = 0; i < this.alphaDataNodeNum; ++i) {
            result.addToDataNodeLocations(availableDataNodeMap.get(this.fakeToRealIdMap.get(this.bestAlphaNodes[i])).getLocation());
        }
        for (i = 0; i < replicationFactor - this.alphaDataNodeNum; ++i) {
            result.addToDataNodeLocations(availableDataNodeMap.get(this.fakeToRealIdMap.get(betaDataNodes.get(i))).getLocation());
        }
        return result;
    }

    @Override
    public Map<TConsensusGroupId, TDataNodeConfiguration> removeNodeReplicaSelect(Map<Integer, TDataNodeConfiguration> availableDataNodeMap, Map<Integer, Double> freeDiskSpaceMap, List<TRegionReplicaSet> allocatedRegionGroups, Map<TConsensusGroupId, String> regionDatabaseMap, Map<String, List<TRegionReplicaSet>> databaseAllocatedRegionGroupMap, Map<TConsensusGroupId, TRegionReplicaSet> remainReplicasMap) {
        throw new UnsupportedOperationException("The removeNodeReplicaSelect method of PartiteGraphPlacementRegionGroupAllocator is yet to be implemented.");
    }

    private void prepare(int replicationFactor, Map<Integer, TDataNodeConfiguration> availableDataNodeMap, List<TRegionReplicaSet> allocatedRegionGroups) {
        int i;
        this.subGraphCount = replicationFactor / 2 + (replicationFactor % 2 == 0 ? 0 : 1);
        this.replicationFactor = replicationFactor;
        this.fakeToRealIdMap = new TreeMap<Integer, Integer>();
        TreeMap<Integer, Integer> realToFakeIdMap = new TreeMap<Integer, Integer>();
        this.dataNodeNum = availableDataNodeMap.size();
        List dataNodeIdList = availableDataNodeMap.values().stream().map(c -> c.getLocation().getDataNodeId()).collect(Collectors.toList());
        for (i = 0; i < this.dataNodeNum; ++i) {
            this.fakeToRealIdMap.put(i, (Integer)dataNodeIdList.get(i));
            realToFakeIdMap.put((Integer)dataNodeIdList.get(i), i);
        }
        this.regionCounter = new int[this.dataNodeNum];
        Arrays.fill(this.regionCounter, 0);
        this.combinationCounter = new int[this.dataNodeNum][this.dataNodeNum];
        for (i = 0; i < this.dataNodeNum; ++i) {
            Arrays.fill(this.combinationCounter[i], 0);
        }
        for (TRegionReplicaSet regionReplicaSet : allocatedRegionGroups) {
            List dataNodeLocations = regionReplicaSet.getDataNodeLocations();
            for (int i2 = 0; i2 < dataNodeLocations.size(); ++i2) {
                int fakeIId;
                int n = fakeIId = ((Integer)realToFakeIdMap.get(((TDataNodeLocation)dataNodeLocations.get(i2)).getDataNodeId())).intValue();
                this.regionCounter[n] = this.regionCounter[n] + 1;
                for (int j = i2 + 1; j < dataNodeLocations.size(); ++j) {
                    int fakeJId = (Integer)realToFakeIdMap.get(((TDataNodeLocation)dataNodeLocations.get(j)).getDataNodeId());
                    this.combinationCounter[fakeIId][fakeJId] = 1;
                    this.combinationCounter[fakeJId][fakeIId] = 1;
                }
            }
        }
        this.alphaDataNodeNum = replicationFactor / 2 + 1;
        this.bestValue = new Pair((Object)Integer.MAX_VALUE, (Object)Integer.MAX_VALUE);
        this.bestAlphaNodes = new int[this.alphaDataNodeNum];
    }

    private Pair<Integer, Integer> valuation(int[] nodes) {
        int edgeSum = 0;
        int regionSum = 0;
        for (int iota : nodes) {
            for (int kappa : nodes) {
                edgeSum += this.combinationCounter[iota][kappa];
            }
            regionSum += this.regionCounter[iota];
        }
        return new Pair((Object)edgeSum, (Object)regionSum);
    }

    private void subGraphSearch(int firstIndex, Map<Integer, Double> freeDiskSpaceMap) {
        int i;
        ArrayList<GreedyRegionGroupAllocator.DataNodeEntry> entryList = new ArrayList<GreedyRegionGroupAllocator.DataNodeEntry>();
        for (int index = firstIndex; index < this.dataNodeNum; index += this.subGraphCount) {
            if (this.regionCounter[index] >= this.regionPerDataNode) continue;
            entryList.add(new GreedyRegionGroupAllocator.DataNodeEntry(index, this.regionCounter[index], freeDiskSpaceMap.get(this.fakeToRealIdMap.get(index))));
        }
        if (entryList.size() < this.alphaDataNodeNum) {
            return;
        }
        Collections.sort(entryList);
        int[] alphaNodes = new int[this.alphaDataNodeNum];
        for (i = 0; i < this.alphaDataNodeNum - 1; ++i) {
            alphaNodes[i] = ((GreedyRegionGroupAllocator.DataNodeEntry)entryList.get((int)i)).dataNodeId;
        }
        for (i = this.alphaDataNodeNum - 1; i < entryList.size(); ++i) {
            alphaNodes[this.alphaDataNodeNum - 1] = ((GreedyRegionGroupAllocator.DataNodeEntry)entryList.get((int)i)).dataNodeId;
            Pair<Integer, Integer> currentValue = this.valuation(alphaNodes);
            if ((Integer)currentValue.left >= (Integer)this.bestValue.left && (!((Integer)currentValue.left).equals(this.bestValue.left) || (Integer)currentValue.right >= (Integer)this.bestValue.right)) continue;
            this.bestValue = currentValue;
            System.arraycopy(alphaNodes, 0, this.bestAlphaNodes, 0, this.alphaDataNodeNum);
        }
    }

    private List<Integer> partiteGraphSearch(int alphaIndex) {
        ArrayList<Integer> betaNodes = new ArrayList<Integer>();
        int[] tmpNodes = new int[this.alphaDataNodeNum + 1];
        System.arraycopy(this.bestAlphaNodes, 0, tmpNodes, 0, this.alphaDataNodeNum);
        for (int partiteIndex = 0; partiteIndex < this.subGraphCount; ++partiteIndex) {
            if (partiteIndex == alphaIndex) continue;
            int selectedDataNode = -1;
            Pair<Integer, Integer> tmpValue = new Pair<Integer, Integer>((Object)Integer.MAX_VALUE, (Object)Integer.MAX_VALUE);
            for (int i = partiteIndex; i < this.dataNodeNum; i += this.subGraphCount) {
                if (this.regionCounter[i] >= this.regionPerDataNode) continue;
                tmpNodes[this.alphaDataNodeNum] = i;
                Pair<Integer, Integer> currentValue = this.valuation(tmpNodes);
                if ((Integer)currentValue.left >= (Integer)tmpValue.left && (!((Integer)currentValue.left).equals(tmpValue.left) || (Integer)currentValue.right >= (Integer)tmpValue.right)) continue;
                tmpValue = currentValue;
                selectedDataNode = i;
            }
            if (selectedDataNode == -1) {
                return new ArrayList<Integer>();
            }
            betaNodes.add(selectedDataNode);
        }
        return betaNodes;
    }
}

