/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.storage;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.storage.RaftStorageMetadata;
import org.apache.ratis.server.storage.RaftStorageMetadataFile;
import org.apache.ratis.util.AtomicFileOutputStream;
import org.apache.ratis.util.ConcurrentUtils;
import org.apache.ratis.util.FileUtils;
import org.apache.ratis.util.JavaUtils;

class RaftStorageMetadataFileImpl
implements RaftStorageMetadataFile {
    private static final String TERM_KEY = "term";
    private static final String VOTED_FOR_KEY = "votedFor";
    private final File file;
    private final AtomicReference<RaftStorageMetadata> metadata = new AtomicReference();

    RaftStorageMetadataFileImpl(File file) {
        this.file = file;
    }

    public RaftStorageMetadata getMetadata() throws IOException {
        return (RaftStorageMetadata)ConcurrentUtils.updateAndGet(this.metadata, value -> value != null ? value : RaftStorageMetadataFileImpl.load(this.file));
    }

    public void persist(RaftStorageMetadata newMetadata) throws IOException {
        ConcurrentUtils.updateAndGet(this.metadata, old -> Objects.equals(old, newMetadata) ? old : RaftStorageMetadataFileImpl.atomicWrite(newMetadata, this.file));
    }

    public String toString() {
        return JavaUtils.getClassSimpleName(RaftStorageMetadataFile.class) + ":" + this.file;
    }

    static RaftStorageMetadata atomicWrite(RaftStorageMetadata metadata, File file) throws IOException {
        Properties properties = new Properties();
        properties.setProperty(TERM_KEY, Long.toString(metadata.getTerm()));
        properties.setProperty(VOTED_FOR_KEY, metadata.getVotedFor().toString());
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new AtomicFileOutputStream(file), StandardCharsets.UTF_8));){
            properties.store(out, "");
        }
        return metadata;
    }

    static Object getValue(String key, Properties properties) throws IOException {
        return Optional.ofNullable(properties.getProperty(key)).orElseThrow(() -> new IOException("'" + key + "' not found in properties: " + properties));
    }

    static long getTerm(Properties properties) throws IOException {
        try {
            return Long.parseLong((String)RaftStorageMetadataFileImpl.getValue(TERM_KEY, properties));
        }
        catch (Exception e) {
            throw new IOException("Failed to parse 'term' from properties: " + properties, e);
        }
    }

    static RaftPeerId getVotedFor(Properties properties) throws IOException {
        try {
            return RaftPeerId.valueOf((String)((String)RaftStorageMetadataFileImpl.getValue(VOTED_FOR_KEY, properties)));
        }
        catch (Exception e) {
            throw new IOException("Failed to parse 'votedFor' from properties: " + properties, e);
        }
    }

    static RaftStorageMetadata load(File file) throws IOException {
        RaftStorageMetadata raftStorageMetadata;
        if (!file.exists()) {
            return RaftStorageMetadata.getDefault();
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(FileUtils.newInputStream((File)file, (OpenOption[])new OpenOption[0]), StandardCharsets.UTF_8));
        try {
            Properties properties = new Properties();
            properties.load(br);
            raftStorageMetadata = RaftStorageMetadata.valueOf((long)RaftStorageMetadataFileImpl.getTerm(properties), (RaftPeerId)RaftStorageMetadataFileImpl.getVotedFor(properties));
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IOException("Failed to load " + file, e);
            }
        }
        br.close();
        return raftStorageMetadata;
    }
}

