/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.warnings;

import java.util.Objects;

public class WarningCode {
    private final int code;
    private final String name;

    public WarningCode(int code, String name) {
        if (code < 0) {
            throw new IllegalArgumentException("code is negative");
        }
        this.code = code;
        this.name = Objects.requireNonNull(name, "name is null");
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + ":" + this.code;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WarningCode that = (WarningCode)obj;
        return this.code == that.code && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.name);
    }
}

