/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column;

import java.util.List;
import org.apache.iotdb.db.queryengine.transformation.dag.column.AbstractCaseWhenThenColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.AbstractIntType;
import org.apache.tsfile.read.common.type.AbstractLongType;
import org.apache.tsfile.read.common.type.AbstractVarcharType;
import org.apache.tsfile.read.common.type.BlobType;
import org.apache.tsfile.read.common.type.BooleanType;
import org.apache.tsfile.read.common.type.DoubleType;
import org.apache.tsfile.read.common.type.FloatType;
import org.apache.tsfile.read.common.type.Type;

public class TreeCaseWhenThenColumnTransformer
extends AbstractCaseWhenThenColumnTransformer {
    public TreeCaseWhenThenColumnTransformer(Type returnType, List<ColumnTransformer> whenTransformers, List<ColumnTransformer> thenTransformers, ColumnTransformer elseTransformer) {
        super(returnType, whenTransformers, thenTransformers, elseTransformer);
    }

    @Override
    protected void writeToColumnBuilder(Type thenColumnType, Column column, int index, ColumnBuilder builder) {
        if (this.returnType instanceof BooleanType) {
            builder.writeBoolean(thenColumnType.getBoolean(column, index));
        } else if (this.returnType instanceof AbstractIntType) {
            builder.writeInt(thenColumnType.getInt(column, index));
        } else if (this.returnType instanceof AbstractLongType) {
            builder.writeLong(thenColumnType.getLong(column, index));
        } else if (this.returnType instanceof FloatType) {
            builder.writeFloat(thenColumnType.getFloat(column, index));
        } else if (this.returnType instanceof DoubleType) {
            builder.writeDouble(thenColumnType.getDouble(column, index));
        } else if (this.returnType instanceof AbstractVarcharType || this.returnType instanceof BlobType) {
            builder.writeBinary(thenColumnType.getBinary(column, index));
        } else {
            throw new UnsupportedOperationException("Unsupported Type");
        }
    }
}

