/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.james.events.EventListener;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.mailbox.lucene.search.LuceneMessageSearchIndex;
import org.apache.james.mailbox.lucene.search.LuceneSearchHighlighter;
import org.apache.james.mailbox.searchhighligt.SearchHighlighter;
import org.apache.james.mailbox.searchhighligt.SearchHighlighterConfiguration;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class LuceneSearchMailboxModule
extends AbstractModule {
    protected void configure() {
        this.bind(SearchHighlighter.class).to(LuceneSearchHighlighter.class).in(Scopes.SINGLETON);
        this.bind(LuceneMessageSearchIndex.class).in(Scopes.SINGLETON);
        this.bind(MessageSearchIndex.class).to(LuceneMessageSearchIndex.class);
        this.bind(ListeningMessageSearchIndex.class).to(LuceneMessageSearchIndex.class);
        Multibinder.newSetBinder((Binder)this.binder(), EventListener.ReactiveGroupEventListener.class).addBinding().to(LuceneMessageSearchIndex.class);
    }

    @Provides
    @Singleton
    Directory provideDirectory(FileSystem fileSystem) throws IOException {
        return FSDirectory.open((Path)fileSystem.getBasedir().toPath());
    }

    @Provides
    @Singleton
    SearchHighlighterConfiguration provideSearchHighlighterConfiguration() {
        return SearchHighlighterConfiguration.DEFAULT;
    }
}

