/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail.task;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;

public class ConflictingEntry {
    private final DaoEntry mailboxDaoEntry;
    private final DaoEntry mailboxPathDaoEntry;

    public static Builder.RequireMailboxDaoEntry builder() {
        return mailboxDaoEntry -> mailboxPathDaoEntry -> new ConflictingEntry(mailboxDaoEntry, mailboxPathDaoEntry);
    }

    private ConflictingEntry(@JsonProperty(value="mailboxDaoEntry") DaoEntry mailboxDaoEntry, @JsonProperty(value="mailboxPathDaoEntry") DaoEntry mailboxPathDaoEntry) {
        this.mailboxDaoEntry = mailboxDaoEntry;
        this.mailboxPathDaoEntry = mailboxPathDaoEntry;
    }

    public DaoEntry getMailboxDaoEntry() {
        return this.mailboxDaoEntry;
    }

    public DaoEntry getMailboxPathDaoEntry() {
        return this.mailboxPathDaoEntry;
    }

    public final boolean equals(Object o) {
        if (o instanceof ConflictingEntry) {
            ConflictingEntry that = (ConflictingEntry)o;
            return Objects.equals(this.mailboxDaoEntry, that.mailboxDaoEntry) && Objects.equals(this.mailboxPathDaoEntry, that.mailboxPathDaoEntry);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.mailboxDaoEntry, this.mailboxPathDaoEntry);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mailboxDaoEntry", (Object)this.mailboxDaoEntry).add("mailboxPathDaoEntry", (Object)this.mailboxPathDaoEntry).toString();
    }

    public static interface Builder {

        @FunctionalInterface
        public static interface RequireMailboxPathDaoEntry {
            public ConflictingEntry mailboxPathDaoEntry(DaoEntry var1);

            default public ConflictingEntry mailboxPathDaoEntry(Mailbox mailbox) {
                return this.mailboxPathDaoEntry(mailbox.generateAssociatedPath(), mailbox.getMailboxId());
            }

            default public ConflictingEntry mailboxPathDaoEntry(MailboxPath path, MailboxId id) {
                return this.mailboxPathDaoEntry(new DaoEntry(path, id));
            }
        }

        @FunctionalInterface
        public static interface RequireMailboxDaoEntry {
            public RequireMailboxPathDaoEntry mailboxDaoEntry(DaoEntry var1);

            default public RequireMailboxPathDaoEntry mailboxDaoEntry(Mailbox mailbox) {
                return this.mailboxDaoEntry(mailbox.generateAssociatedPath(), mailbox.getMailboxId());
            }

            default public RequireMailboxPathDaoEntry mailboxDaoEntry(MailboxPath path, MailboxId id) {
                return this.mailboxDaoEntry(new DaoEntry(path, id));
            }
        }
    }

    public static class DaoEntry {
        private final String mailboxPath;
        private final String mailboxId;

        public DaoEntry(MailboxPath mailboxPath, MailboxId mailboxId) {
            this(mailboxPath.asString(), mailboxId.serialize());
        }

        private DaoEntry(@JsonProperty(value="mailboxPath") String mailboxPath, @JsonProperty(value="mailboxId") String mailboxId) {
            this.mailboxPath = mailboxPath;
            this.mailboxId = mailboxId;
        }

        public String getMailboxPath() {
            return this.mailboxPath;
        }

        public String getMailboxId() {
            return this.mailboxId;
        }

        public final boolean equals(Object o) {
            if (o instanceof DaoEntry) {
                DaoEntry daoEntry = (DaoEntry)o;
                return Objects.equals(this.mailboxPath, daoEntry.mailboxPath) && Objects.equals(this.mailboxId, daoEntry.mailboxId);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.mailboxPath, this.mailboxId);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("mailboxPath", (Object)this.mailboxPath).add("mailboxId", (Object)this.mailboxId).toString();
        }
    }
}

