/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.postgres;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.Domain;
import org.apache.james.rrt.lib.AbstractRecipientRewriteTable;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.rrt.lib.MappingsImpl;
import org.apache.james.rrt.postgres.PostgresRecipientRewriteTableDAO;
import reactor.core.publisher.Flux;

public class PostgresRecipientRewriteTable
extends AbstractRecipientRewriteTable {
    private PostgresRecipientRewriteTableDAO postgresRecipientRewriteTableDAO;

    @Inject
    public PostgresRecipientRewriteTable(PostgresRecipientRewriteTableDAO postgresRecipientRewriteTableDAO) {
        this.postgresRecipientRewriteTableDAO = postgresRecipientRewriteTableDAO;
    }

    public void addMapping(MappingSource source, Mapping mapping) {
        this.postgresRecipientRewriteTableDAO.addMapping(source, mapping).block();
    }

    public void removeMapping(MappingSource source, Mapping mapping) {
        this.postgresRecipientRewriteTableDAO.removeMapping(source, mapping).block();
    }

    public Mappings getStoredMappings(MappingSource source) {
        return (Mappings)this.postgresRecipientRewriteTableDAO.getMappings(source).block();
    }

    public Map<MappingSource, Mappings> getAllMappings() {
        return (Map)this.postgresRecipientRewriteTableDAO.getAllMappings().collect(ImmutableMap.toImmutableMap(Pair::getLeft, pair -> MappingsImpl.fromMappings((Mapping[])new Mapping[]{(Mapping)pair.getRight()}), Mappings::union)).block();
    }

    protected Mappings mapAddress(String user, Domain domain) {
        return this.postgresRecipientRewriteTableDAO.getMappings(MappingSource.fromUser((String)user, (Domain)domain)).filter(Predicate.not(Mappings::isEmpty)).blockOptional().orElse((Mappings)this.postgresRecipientRewriteTableDAO.getMappings(MappingSource.fromDomain((Domain)domain)).block());
    }

    public Stream<MappingSource> listSources(Mapping mapping) {
        Preconditions.checkArgument((boolean)listSourcesSupportedType.contains(mapping.getType()), (String)"Not supported mapping of type %s", (Object)mapping.getType());
        return this.postgresRecipientRewriteTableDAO.getSources(mapping).toStream();
    }

    public Flux<MappingSource> listSourcesReactive(Mapping mapping) {
        Preconditions.checkArgument((boolean)listSourcesSupportedType.contains(mapping.getType()), (String)"Not supported mapping of type %s", (Object)mapping.getType());
        return this.postgresRecipientRewriteTableDAO.getSources(mapping);
    }
}

