/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mail;

import eu.timepit.refined.api.Refined;
import eu.timepit.refined.boolean;
import eu.timepit.refined.collection;
import eu.timepit.refined.package$;
import eu.timepit.refined.string;
import java.io.Serializable;
import org.apache.james.jmap.core.CapabilityIdentifier$;
import org.apache.james.jmap.json.MailboxSerializer;
import org.apache.james.jmap.mail.InvalidPatchException;
import org.apache.james.jmap.mail.InvalidPropertyException;
import org.apache.james.jmap.mail.InvalidUpdateException;
import org.apache.james.jmap.mail.MailboxPatchObject$;
import org.apache.james.jmap.mail.PatchUpdateValidationException;
import org.apache.james.jmap.mail.Rfc4314Rights;
import org.apache.james.jmap.mail.SharedWithAnyoneValidator$;
import org.apache.james.jmap.mail.SharedWithPartialUpdate;
import org.apache.james.jmap.mail.Update;
import org.apache.james.mailbox.model.MailboxACL;
import play.api.libs.json.JsError;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class SharedWithPartialUpdate$
implements Serializable {
    public static final SharedWithPartialUpdate$ MODULE$ = new SharedWithPartialUpdate$();

    public Either<PatchUpdateValidationException, Update> parse(MailboxSerializer serializer, Set<Refined<String, string.Uri>> capabilities, String property, JsValue newValue) {
        if (capabilities.contains((Object)new Refined((Object)CapabilityIdentifier$.MODULE$.JAMES_SHARES()))) {
            return this.parseEntryKey(property).flatMap((Function1 & Serializable)entryKey -> MODULE$.parseRights(newValue, property, serializer).flatMap((Function1 & Serializable)rights -> MODULE$.createUpdateIfValidPatch((MailboxACL.EntryKey)entryKey, (Rfc4314Rights)rights)));
        }
        return MailboxPatchObject$.MODULE$.notFound(property);
    }

    private Either<PatchUpdateValidationException, Update> createUpdateIfValidPatch(MailboxACL.EntryKey entryKey, Rfc4314Rights rights) {
        if (SharedWithAnyoneValidator$.MODULE$.isValidPatch(entryKey, rights.toRights())) {
            return new Right((Object)new SharedWithPartialUpdate(entryKey, rights));
        }
        return new Left((Object)new InvalidPatchException("only the `Post` right can be granted to the identifier `anyone`"));
    }

    public Either<PatchUpdateValidationException, MailboxACL.EntryKey> parseEntryKey(String property) {
        Right right;
        try {
            right = new Right((Object)MailboxACL.EntryKey.deserialize((String)property.substring(MailboxPatchObject$.MODULE$.sharedWithPrefix().length())));
        }
        catch (Exception e) {
            right = new Left((Object)new InvalidPropertyException(property, e.getMessage()));
        }
        return right;
    }

    public Either<PatchUpdateValidationException, Rfc4314Rights> parseRights(JsValue newValue, String property, MailboxSerializer serializer) {
        JsResult<Rfc4314Rights> jsResult = serializer.deserializeRfc4314Rights(newValue);
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            Rfc4314Rights rights = (Rfc4314Rights)jsSuccess.value();
            return new Right((Object)rights);
        }
        if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            Seq errors = jsError.errors();
            Either refinedKey = package$.MODULE$.refineV().apply((Object)property, boolean.Not$.MODULE$.notValidate(collection.Empty$.MODULE$.emptyValidate((Function1 & Serializable)s -> Predef$.MODULE$.wrapString(s))));
            return (Either)refinedKey.fold((Function1 & Serializable)refinedError -> new Left((Object)new InvalidPropertyException(property, "Invalid property specified in a patch object: " + refinedError)), (Function1 & Serializable)refinedProperty -> SharedWithPartialUpdate$.$anonfun$parseRights$3(errors, (String)((Refined)refinedProperty).value()));
        }
        throw new MatchError(jsResult);
    }

    public SharedWithPartialUpdate apply(MailboxACL.EntryKey entryKey, Rfc4314Rights rights) {
        return new SharedWithPartialUpdate(entryKey, rights);
    }

    public Option<Tuple2<MailboxACL.EntryKey, Rfc4314Rights>> unapply(SharedWithPartialUpdate x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)x$0.entryKey(), (Object)x$0.rights()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SharedWithPartialUpdate$.class);
    }

    public static final /* synthetic */ Left $anonfun$parseRights$3(Seq errors$1, String refinedProperty) {
        return new Left((Object)new InvalidUpdateException(refinedProperty, "Specified value do not match the expected JSON format: " + errors$1));
    }

    private SharedWithPartialUpdate$() {
    }
}

