/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.indices.stats.IndexStats;
import org.opensearch.client.opensearch.indices.stats.ShardStats;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class IndicesStats
implements PlainJsonSerializable {
    private final IndexStats primaries;
    private final Map<String, List<ShardStats>> shards;
    private final IndexStats total;
    @Nullable
    private final String uuid;
    public static final JsonpDeserializer<IndicesStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndicesStats::setupIndicesStatsDeserializer);

    private IndicesStats(Builder builder) {
        this.primaries = ApiTypeHelper.requireNonNull(builder.primaries, this, "primaries");
        this.shards = ApiTypeHelper.unmodifiable(builder.shards);
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
        this.uuid = builder.uuid;
    }

    public static IndicesStats of(Function<Builder, ObjectBuilder<IndicesStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final IndexStats primaries() {
        return this.primaries;
    }

    public final Map<String, List<ShardStats>> shards() {
        return this.shards;
    }

    public final IndexStats total() {
        return this.total;
    }

    @Nullable
    public final String uuid() {
        return this.uuid;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("primaries");
        this.primaries.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.shards)) {
            generator.writeKey("shards");
            generator.writeStartObject();
            for (Map.Entry<String, List<ShardStats>> item0 : this.shards.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.writeStartArray();
                if (item0.getValue() != null) {
                    for (ShardStats item1 : item0.getValue()) {
                        item1.serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        generator.writeKey("total");
        this.total.serialize(generator, mapper);
        if (this.uuid != null) {
            generator.writeKey("uuid");
            generator.write(this.uuid);
        }
    }

    protected static void setupIndicesStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::primaries, IndexStats._DESERIALIZER, "primaries");
        op.add(Builder::shards, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(ShardStats._DESERIALIZER)), "shards");
        op.add(Builder::total, IndexStats._DESERIALIZER, "total");
        op.add(Builder::uuid, JsonpDeserializer.stringDeserializer(), "uuid");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<IndicesStats> {
        private IndexStats primaries;
        @Nullable
        private Map<String, List<ShardStats>> shards;
        private IndexStats total;
        @Nullable
        private String uuid;

        public final Builder primaries(IndexStats value) {
            this.primaries = value;
            return this;
        }

        public final Builder primaries(Function<IndexStats.Builder, ObjectBuilder<IndexStats>> fn) {
            return this.primaries(fn.apply(new IndexStats.Builder()).build());
        }

        public final Builder shards(Map<String, List<ShardStats>> map) {
            this.shards = Builder._mapPutAll(this.shards, map);
            return this;
        }

        public final Builder shards(String key, List<ShardStats> value) {
            this.shards = Builder._mapPut(this.shards, key, value);
            return this;
        }

        public final Builder total(IndexStats value) {
            this.total = value;
            return this;
        }

        public final Builder total(Function<IndexStats.Builder, ObjectBuilder<IndexStats>> fn) {
            return this.total(fn.apply(new IndexStats.Builder()).build());
        }

        public final Builder uuid(@Nullable String value) {
            this.uuid = value;
            return this;
        }

        @Override
        public IndicesStats build() {
            this._checkSingleUse();
            return new IndicesStats(this);
        }
    }
}

