/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.pages.haddock;

import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.Selenide;
import java.util.List;
import org.apache.wiki.pages.Page;
import org.apache.wiki.pages.haddock.HaddockPage;
import org.apache.wiki.pages.haddock.ViewWikiPage;
import org.openqa.selenium.By;

public class SearchResultsPage
implements HaddockPage {
    private static final String SEARCH_PAGE_NAME_RESULTS = ".wikitable.table-striped tr:not(:first-child) td:first-child";

    public static SearchResultsPage open(String pageName) {
        return Page.withUrl(Page.baseUrl() + "/Search.jsp?query=" + pageName).openAs(new SearchResultsPage());
    }

    public List<String> pagesFound() {
        return Selenide.$$((By)By.cssSelector((String)SEARCH_PAGE_NAME_RESULTS)).texts();
    }

    public SearchResultsPage shouldContain(String ... pageNames) {
        ElementsCollection resultsTableRows = Selenide.$$((By)By.cssSelector((String)SEARCH_PAGE_NAME_RESULTS));
        for (String pageName : pageNames) {
            resultsTableRows.shouldHave(new CollectionCondition[]{CollectionCondition.itemWithText((String)pageName)});
        }
        return this;
    }

    public ViewWikiPage navigateTo(String result) {
        Selenide.$((By)By.cssSelector((String)".wikitable.table-striped")).find(By.linkText((String)result)).click();
        return new ViewWikiPage();
    }
}

