/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.TopologyConfig;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.AbstractTask;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.apache.kafka.streams.processor.internals.StateManagerUtil;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.streams.processor.internals.TaskManager;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.TaskMetrics;
import org.apache.kafka.streams.processor.internals.metrics.ThreadMetrics;
import org.apache.kafka.streams.state.internals.ThreadCache;

public class StandbyTask
extends AbstractTask
implements Task {
    private final boolean eosEnabled;
    private final Sensor closeTaskSensor;
    private final Sensor updateSensor;
    private final StreamsMetricsImpl streamsMetrics;
    protected final InternalProcessorContext<?, ?> processorContext;

    StandbyTask(TaskId id, Set<TopicPartition> inputPartitions, ProcessorTopology topology, TopologyConfig.TaskConfig config, StreamsMetricsImpl streamsMetrics, ProcessorStateManager stateMgr, StateDirectory stateDirectory, ThreadCache cache, InternalProcessorContext<?, ?> processorContext) {
        super(id, topology, stateDirectory, stateMgr, inputPartitions, config, "standby-task", StandbyTask.class);
        this.processorContext = processorContext;
        this.streamsMetrics = streamsMetrics;
        processorContext.transitionToStandby(cache);
        this.closeTaskSensor = ThreadMetrics.closeTaskSensor(Thread.currentThread().getName(), streamsMetrics);
        this.updateSensor = TaskMetrics.updateSensor(Thread.currentThread().getName(), id.toString(), streamsMetrics, new Sensor[0]);
        this.eosEnabled = config.eosEnabled;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public void recordRestoration(Time time, long numRecords, boolean initRemaining) {
        if (initRemaining) {
            throw new IllegalStateException("Standby task would not record remaining records to restore");
        }
        StreamsMetricsImpl.maybeRecordSensor(numRecords, time, this.updateSensor);
    }

    @Override
    public void initializeIfNeeded() {
        if (this.state() == Task.State.CREATED) {
            StateManagerUtil.registerStateStores(this.log, this.logPrefix, this.topology, this.stateMgr, this.stateDirectory, this.processorContext);
            this.offsetSnapshotSinceLastFlush = Collections.emptyMap();
            this.transitionTo(Task.State.RESTORING);
            this.transitionTo(Task.State.RUNNING);
            this.processorContext.initialize();
            this.log.info("Initialized");
        } else if (this.state() == Task.State.RESTORING) {
            throw new IllegalStateException("Illegal state " + String.valueOf((Object)this.state()) + " while initializing standby task " + String.valueOf(this.id));
        }
    }

    @Override
    public void completeRestoration(Consumer<Set<TopicPartition>> offsetResetter) {
        throw new IllegalStateException("Standby task " + String.valueOf(this.id) + " should never be completing restoration");
    }

    @Override
    public void suspend() {
        switch (this.state()) {
            case CREATED: {
                this.log.info("Suspended created");
                this.transitionTo(Task.State.SUSPENDED);
                break;
            }
            case RUNNING: {
                this.log.info("Suspended running");
                this.transitionTo(Task.State.SUSPENDED);
                break;
            }
            case SUSPENDED: {
                this.log.info("Skip suspending since state is {}", (Object)this.state());
                break;
            }
            case RESTORING: 
            case CLOSED: {
                throw new IllegalStateException("Illegal state " + String.valueOf((Object)this.state()) + " while suspending standby task " + String.valueOf(this.id));
            }
            default: {
                throw new IllegalStateException("Unknown state " + String.valueOf((Object)this.state()) + " while suspending standby task " + String.valueOf(this.id));
            }
        }
    }

    @Override
    public void resume() {
        if (this.state() == Task.State.RESTORING) {
            throw new IllegalStateException("Illegal state " + String.valueOf((Object)this.state()) + " while resuming standby task " + String.valueOf(this.id));
        }
        this.log.trace("No-op resume with state {}", (Object)this.state());
    }

    @Override
    public Map<TopicPartition, OffsetAndMetadata> prepareCommit() {
        switch (this.state()) {
            case CREATED: {
                this.log.debug("Skipped preparing created task for commit");
                break;
            }
            case RUNNING: 
            case SUSPENDED: {
                this.log.debug("Prepared {} task for committing", (Object)this.state());
                break;
            }
            default: {
                throw new IllegalStateException("Illegal state " + String.valueOf((Object)this.state()) + " while preparing standby task " + String.valueOf(this.id) + " for committing ");
            }
        }
        return Collections.emptyMap();
    }

    @Override
    public void postCommit(boolean enforceCheckpoint) {
        switch (this.state()) {
            case CREATED: {
                this.log.debug("Skipped writing checkpoint for created task");
                break;
            }
            case RUNNING: 
            case SUSPENDED: {
                this.maybeCheckpoint(enforceCheckpoint);
                this.log.debug("Finalized commit for {} task", (Object)this.state());
                break;
            }
            default: {
                throw new IllegalStateException("Illegal state " + String.valueOf((Object)this.state()) + " while post committing standby task " + String.valueOf(this.id));
            }
        }
    }

    @Override
    public void closeClean() {
        this.streamsMetrics.removeAllTaskLevelSensors(Thread.currentThread().getName(), this.id.toString());
        this.close(true);
        this.log.info("Closed clean");
    }

    @Override
    public void closeDirty() {
        this.streamsMetrics.removeAllTaskLevelSensors(Thread.currentThread().getName(), this.id.toString());
        this.close(false);
        this.log.info("Closed dirty");
    }

    @Override
    public void prepareRecycle() {
        this.streamsMetrics.removeAllTaskLevelSensors(Thread.currentThread().getName(), this.id.toString());
        if (this.state() != Task.State.SUSPENDED) {
            throw new IllegalStateException("Illegal state " + String.valueOf((Object)this.state()) + " while closing standby task " + String.valueOf(this.id));
        }
        this.stateMgr.recycle();
        this.closeTaskSensor.record();
        this.transitionTo(Task.State.CLOSED);
        this.log.info("Closed and recycled state");
    }

    @Override
    public void resumePollingForPartitionsWithAvailableSpace() {
    }

    @Override
    public void updateLags() {
    }

    private void close(boolean clean) {
        switch (this.state()) {
            case SUSPENDED: {
                TaskManager.executeAndMaybeSwallow(clean, () -> StateManagerUtil.closeStateManager(this.log, this.logPrefix, clean, this.eosEnabled, this.stateMgr, this.stateDirectory, Task.TaskType.STANDBY), "state manager close", this.log);
                break;
            }
            case CLOSED: {
                this.log.trace("Skip closing since state is {}", (Object)this.state());
                return;
            }
            case CREATED: 
            case RUNNING: 
            case RESTORING: {
                throw new IllegalStateException("Illegal state " + String.valueOf((Object)this.state()) + " while closing standby task " + String.valueOf(this.id));
            }
            default: {
                throw new IllegalStateException("Unknown state " + String.valueOf((Object)this.state()) + " while closing standby task " + String.valueOf(this.id));
            }
        }
        this.closeTaskSensor.record();
        this.transitionTo(Task.State.CLOSED);
    }

    @Override
    public boolean commitNeeded() {
        return StateManagerUtil.checkpointNeeded(false, this.offsetSnapshotSinceLastFlush, this.stateMgr.changelogOffsets());
    }

    @Override
    public Map<TopicPartition, Long> changelogOffsets() {
        return Collections.unmodifiableMap(this.stateMgr.changelogOffsets());
    }

    @Override
    public Map<TopicPartition, Long> committedOffsets() {
        return Collections.emptyMap();
    }

    @Override
    public Map<TopicPartition, Long> highWaterMark() {
        return Collections.emptyMap();
    }

    @Override
    public Optional<Long> timeCurrentIdlingStarted() {
        return Optional.empty();
    }

    @Override
    public void addRecords(TopicPartition partition, Iterable<ConsumerRecord<byte[], byte[]>> records) {
        throw new IllegalStateException("Attempted to add records to task " + String.valueOf(this.id()) + " for invalid input partition " + String.valueOf(partition));
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(indent);
        sb.append("TaskId: ");
        sb.append(this.id);
        sb.append("\n");
        if (this.topology != null) {
            sb.append(indent).append(this.topology.toString(indent + "\t"));
        }
        return sb.toString();
    }
}

