/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.share;

import java.util.Optional;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.utils.Utils;

public class ShareCoordinatorConfig {
    public static final String STATE_TOPIC_NUM_PARTITIONS_CONFIG = "share.coordinator.state.topic.num.partitions";
    public static final int STATE_TOPIC_NUM_PARTITIONS_DEFAULT = 50;
    public static final String STATE_TOPIC_NUM_PARTITIONS_DOC = "The number of partitions for the share-group state topic (should not change after deployment).";
    public static final String STATE_TOPIC_REPLICATION_FACTOR_CONFIG = "share.coordinator.state.topic.replication.factor";
    public static final short STATE_TOPIC_REPLICATION_FACTOR_DEFAULT = 3;
    public static final String STATE_TOPIC_REPLICATION_FACTOR_DOC = "Replication factor for the share-group state topic. Topic creation will fail until the cluster size meets this replication factor requirement.";
    public static final String STATE_TOPIC_MIN_ISR_CONFIG = "share.coordinator.state.topic.min.isr";
    public static final short STATE_TOPIC_MIN_ISR_DEFAULT = 2;
    public static final String STATE_TOPIC_MIN_ISR_DOC = "Overridden min.insync.replicas for the share-group state topic.";
    public static final String STATE_TOPIC_SEGMENT_BYTES_CONFIG = "share.coordinator.state.topic.segment.bytes";
    public static final int STATE_TOPIC_SEGMENT_BYTES_DEFAULT = 0x6400000;
    public static final String STATE_TOPIC_SEGMENT_BYTES_DOC = "The log segment size for the share-group state topic.";
    public static final String NUM_THREADS_CONFIG = "share.coordinator.threads";
    public static final int NUM_THREADS_DEFAULT = 1;
    public static final String NUM_THREADS_DOC = "The number of threads used by the share coordinator.";
    public static final String SNAPSHOT_UPDATE_RECORDS_PER_SNAPSHOT_CONFIG = "share.coordinator.snapshot.update.records.per.snapshot";
    public static final int SNAPSHOT_UPDATE_RECORDS_PER_SNAPSHOT_DEFAULT = 500;
    public static final String SNAPSHOT_UPDATE_RECORDS_PER_SNAPSHOT_DOC = "The number of update records the share coordinator writes between snapshot records.";
    public static final String WRITE_TIMEOUT_MS_CONFIG = "share.coordinator.write.timeout.ms";
    public static final int WRITE_TIMEOUT_MS_DEFAULT = 5000;
    public static final String WRITE_TIMEOUT_MS_DOC = "The duration in milliseconds that the share coordinator will wait for all replicas of the share-group state topic to receive a write.";
    public static final String LOAD_BUFFER_SIZE_CONFIG = "share.coordinator.load.buffer.size";
    public static final int LOAD_BUFFER_SIZE_DEFAULT = 0x500000;
    public static final String LOAD_BUFFER_SIZE_DOC = "Batch size for reading from the share-group state topic when loading state information into the cache (soft-limit, overridden if records are too large).";
    public static final String STATE_TOPIC_COMPRESSION_CODEC_CONFIG = "share.coordinator.state.topic.compression.codec";
    public static final CompressionType STATE_TOPIC_COMPRESSION_CODEC_DEFAULT = CompressionType.NONE;
    public static final String STATE_TOPIC_COMPRESSION_CODEC_DOC = "Compression codec for the share-group state topic.";
    public static final String APPEND_LINGER_MS_CONFIG = "share.coordinator.append.linger.ms";
    public static final int APPEND_LINGER_MS_DEFAULT = 10;
    public static final String APPEND_LINGER_MS_DOC = "The duration in milliseconds that the share coordinator will wait for writes to accumulate before flushing them to disk.";
    public static final String STATE_TOPIC_PRUNE_INTERVAL_MS_CONFIG = "share.coordinator.state.topic.prune.interval.ms";
    public static final int STATE_TOPIC_PRUNE_INTERVAL_MS_DEFAULT = 300000;
    public static final String STATE_TOPIC_PRUNE_INTERVAL_MS_DOC = "The duration in milliseconds that the share coordinator will wait between pruning eligible records in share-group state topic.";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("share.coordinator.state.topic.num.partitions", ConfigDef.Type.INT, (Object)50, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "The number of partitions for the share-group state topic (should not change after deployment).").define("share.coordinator.state.topic.replication.factor", ConfigDef.Type.SHORT, (Object)3, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "Replication factor for the share-group state topic. Topic creation will fail until the cluster size meets this replication factor requirement.").define("share.coordinator.state.topic.min.isr", ConfigDef.Type.SHORT, (Object)2, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "Overridden min.insync.replicas for the share-group state topic.").define("share.coordinator.state.topic.segment.bytes", ConfigDef.Type.INT, (Object)0x6400000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "The log segment size for the share-group state topic.").define("share.coordinator.threads", ConfigDef.Type.INT, (Object)1, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The number of threads used by the share coordinator.").define("share.coordinator.snapshot.update.records.per.snapshot", ConfigDef.Type.INT, (Object)500, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "The number of update records the share coordinator writes between snapshot records.").define("share.coordinator.load.buffer.size", ConfigDef.Type.INT, (Object)0x500000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "Batch size for reading from the share-group state topic when loading state information into the cache (soft-limit, overridden if records are too large).").define("share.coordinator.state.topic.compression.codec", ConfigDef.Type.INT, (Object)ShareCoordinatorConfig.STATE_TOPIC_COMPRESSION_CODEC_DEFAULT.id, ConfigDef.Importance.HIGH, "Compression codec for the share-group state topic.").define("share.coordinator.append.linger.ms", ConfigDef.Type.INT, (Object)10, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "The duration in milliseconds that the share coordinator will wait for writes to accumulate before flushing them to disk.").define("share.coordinator.write.timeout.ms", ConfigDef.Type.INT, (Object)5000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "The duration in milliseconds that the share coordinator will wait for all replicas of the share-group state topic to receive a write.").defineInternal("share.coordinator.state.topic.prune.interval.ms", ConfigDef.Type.INT, (Object)300000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, "The duration in milliseconds that the share coordinator will wait between pruning eligible records in share-group state topic.");
    private final int stateTopicNumPartitions;
    private final short stateTopicReplicationFactor;
    private final int stateTopicMinIsr;
    private final int stateTopicSegmentBytes;
    private final int numThreads;
    private final int snapshotUpdateRecordsPerSnapshot;
    private final int writeTimeoutMs;
    private final int loadBufferSize;
    private final CompressionType compressionType;
    private final int appendLingerMs;
    private final int pruneIntervalMs;

    public ShareCoordinatorConfig(AbstractConfig config) {
        this.stateTopicNumPartitions = config.getInt(STATE_TOPIC_NUM_PARTITIONS_CONFIG);
        this.stateTopicReplicationFactor = config.getShort(STATE_TOPIC_REPLICATION_FACTOR_CONFIG);
        this.stateTopicMinIsr = config.getShort(STATE_TOPIC_MIN_ISR_CONFIG).shortValue();
        this.stateTopicSegmentBytes = config.getInt(STATE_TOPIC_SEGMENT_BYTES_CONFIG);
        this.numThreads = config.getInt(NUM_THREADS_CONFIG);
        this.snapshotUpdateRecordsPerSnapshot = config.getInt(SNAPSHOT_UPDATE_RECORDS_PER_SNAPSHOT_CONFIG);
        this.writeTimeoutMs = config.getInt(WRITE_TIMEOUT_MS_CONFIG);
        this.loadBufferSize = config.getInt(LOAD_BUFFER_SIZE_CONFIG);
        this.compressionType = Optional.ofNullable(config.getInt(STATE_TOPIC_COMPRESSION_CODEC_CONFIG)).map(CompressionType::forId).orElse(null);
        this.appendLingerMs = config.getInt(APPEND_LINGER_MS_CONFIG);
        this.pruneIntervalMs = config.getInt(STATE_TOPIC_PRUNE_INTERVAL_MS_CONFIG);
        this.validate();
    }

    public int shareCoordinatorStateTopicNumPartitions() {
        return this.stateTopicNumPartitions;
    }

    public short shareCoordinatorStateTopicReplicationFactor() {
        return this.stateTopicReplicationFactor;
    }

    public int shareCoordinatorStateTopicMinIsr() {
        return this.stateTopicMinIsr;
    }

    public int shareCoordinatorStateTopicSegmentBytes() {
        return this.stateTopicSegmentBytes;
    }

    public int shareCoordinatorNumThreads() {
        return this.numThreads;
    }

    public int shareCoordinatorSnapshotUpdateRecordsPerSnapshot() {
        return this.snapshotUpdateRecordsPerSnapshot;
    }

    public int shareCoordinatorWriteTimeoutMs() {
        return this.writeTimeoutMs;
    }

    public int shareCoordinatorLoadBufferSize() {
        return this.loadBufferSize;
    }

    public int shareCoordinatorAppendLingerMs() {
        return this.appendLingerMs;
    }

    public CompressionType shareCoordinatorStateTopicCompressionType() {
        return this.compressionType;
    }

    public int shareCoordinatorTopicPruneIntervalMs() {
        return this.pruneIntervalMs;
    }

    private void validate() {
        Utils.require((this.snapshotUpdateRecordsPerSnapshot >= 0 && this.snapshotUpdateRecordsPerSnapshot <= 500 ? 1 : 0) != 0, (String)String.format("%s must be between [0, 500]", SNAPSHOT_UPDATE_RECORDS_PER_SNAPSHOT_CONFIG));
    }
}

