/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.codecs.asserting;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.codecs.LiveDocsFormat;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.tests.util.TestUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;

public class AssertingLiveDocsFormat
extends LiveDocsFormat {
    private final LiveDocsFormat in = TestUtil.getDefaultCodec().liveDocsFormat();

    public Bits readLiveDocs(Directory dir, SegmentCommitInfo info, IOContext context) throws IOException {
        Bits raw = this.in.readLiveDocs(dir, info, context);
        assert (raw != null);
        this.check(raw, info.info.maxDoc(), info.getDelCount());
        return new AssertingBits(raw);
    }

    public void writeLiveDocs(Bits bits, Directory dir, SegmentCommitInfo info, int newDelCount, IOContext context) throws IOException {
        this.check(bits, info.info.maxDoc(), info.getDelCount() + newDelCount);
        this.in.writeLiveDocs(bits, dir, info, newDelCount, context);
    }

    private void check(Bits bits, int expectedLength, int expectedDeleteCount) {
        assert (bits.length() == expectedLength);
        int deletedCount = 0;
        for (int i = 0; i < bits.length(); ++i) {
            if (bits.get(i)) continue;
            ++deletedCount;
        }
        assert (deletedCount == expectedDeleteCount) : "deleted: " + deletedCount + " != expected: " + expectedDeleteCount;
    }

    public void files(SegmentCommitInfo info, Collection<String> files) throws IOException {
        this.in.files(info, files);
    }

    public String toString() {
        return "Asserting(" + String.valueOf(this.in) + ")";
    }

    static class AssertingBits
    implements Bits {
        final Bits in;

        AssertingBits(Bits in) {
            this.in = in;
            assert (in.length() >= 0);
        }

        public boolean get(int index) {
            assert (index >= 0);
            assert (index < this.in.length()) : "index=" + index + " vs in.length()=" + this.in.length();
            return this.in.get(index);
        }

        public int length() {
            return this.in.length();
        }

        public void applyMask(FixedBitSet bitSet, int offset) {
            assert (offset >= 0);
            this.in.applyMask(bitSet, offset);
        }

        public String toString() {
            return "Asserting(" + String.valueOf(this.in) + ")";
        }
    }
}

