/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal.concurrent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.lifecycle.internal.concurrent.BuildStep;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;

public class BuildPlan {
    private final Map<MavenProject, Map<String, BuildStep>> plan = new LinkedHashMap<MavenProject, Map<String, BuildStep>>();
    private final Map<MavenProject, List<MavenProject>> projects;
    private final Map<String, String> aliases = new HashMap<String, String>();
    private volatile Set<String> duplicateIds;
    private volatile List<BuildStep> sortedNodes;

    BuildPlan() {
        this.projects = null;
    }

    public BuildPlan(Map<MavenProject, List<MavenProject>> projects) {
        this.projects = projects;
    }

    public Map<MavenProject, List<MavenProject>> getAllProjects() {
        return this.projects;
    }

    public Map<String, String> aliases() {
        return this.aliases;
    }

    public Stream<MavenProject> projects() {
        return this.plan.keySet().stream();
    }

    public void addProject(MavenProject project, Map<String, BuildStep> steps) {
        this.plan.put(project, steps);
    }

    public void addStep(MavenProject project, String name, BuildStep step) {
        this.plan.get(project).put(name, step);
    }

    public Stream<BuildStep> allSteps() {
        return this.plan.values().stream().flatMap(m -> m.values().stream());
    }

    public Stream<BuildStep> steps(MavenProject project) {
        return Optional.ofNullable(this.plan.get(project)).map(m -> m.values().stream()).orElse(Stream.empty());
    }

    public Optional<BuildStep> step(MavenProject project, String name) {
        return Optional.ofNullable(this.plan.get(project)).map(m -> (BuildStep)m.get(name));
    }

    public BuildStep requiredStep(MavenProject project, String name) {
        return this.step(project, name).orElseThrow(() -> new NoSuchElementException("Step " + name + " not found"));
    }

    public void then(BuildPlan step) {
        step.plan.forEach((k, v) -> this.plan.merge((MavenProject)k, (Map<String, BuildStep>)v, this::merge));
        this.aliases.putAll(step.aliases);
    }

    private Map<String, BuildStep> merge(Map<String, BuildStep> org, Map<String, BuildStep> add) {
        List<BuildStep> lasts = org.values().stream().filter(b -> b.successors.isEmpty()).toList();
        List<BuildStep> firsts = add.values().stream().filter(b -> b.predecessors.isEmpty()).toList();
        firsts.stream().filter(addNode -> !org.containsKey(addNode.name)).forEach(addNode -> lasts.forEach(orgNode -> addNode.executeAfter((BuildStep)orgNode)));
        add.forEach((name, node) -> org.merge((String)name, (BuildStep)node, this::merge));
        return org;
    }

    private BuildStep merge(BuildStep node1, BuildStep node2) {
        node1.predecessors.addAll(node2.predecessors);
        node1.successors.addAll(node2.successors);
        node2.mojos.forEach((k, v) -> node1.mojos.merge((Integer)k, (Map<String, MojoExecution>)v, this::mergeMojos));
        return node1;
    }

    private Map<String, MojoExecution> mergeMojos(Map<String, MojoExecution> l1, Map<String, MojoExecution> l2) {
        l2.forEach(l1::putIfAbsent);
        return l1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> duplicateIds() {
        if (this.duplicateIds == null) {
            BuildPlan buildPlan = this;
            synchronized (buildPlan) {
                if (this.duplicateIds == null) {
                    this.duplicateIds = this.projects().map(MavenProject::getArtifactId).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(p -> (Long)p.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
                }
            }
        }
        return this.duplicateIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BuildStep> sortedNodes() {
        if (this.sortedNodes == null) {
            BuildPlan buildPlan = this;
            synchronized (buildPlan) {
                if (this.sortedNodes == null) {
                    ArrayList<BuildStep> sortedNodes = new ArrayList<BuildStep>();
                    HashSet visited = new HashSet();
                    this.allSteps().forEach(node -> BuildPlan.visitNode(node, visited, sortedNodes));
                    Collections.reverse(sortedNodes);
                    this.sortedNodes = sortedNodes;
                }
            }
        }
        return this.sortedNodes;
    }

    private static void visitNode(BuildStep node, Set<BuildStep> visited, List<BuildStep> sortedNodes) {
        if (visited.add(node)) {
            node.successors.forEach(successor -> BuildPlan.visitNode(successor, visited, sortedNodes));
            sortedNodes.add(node);
        }
    }
}

