/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.interfaces.messagesets;

import de.vandermeer.skb.interfaces.messagesets.IsMessageSet;
import de.vandermeer.skb.interfaces.render.DoesRender;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.text.StrBuilder;

public interface IsErrorSet<M>
extends IsMessageSet {
    default public void clearErrorMessages() {
        this.getErrorMessages().clear();
    }

    public Set<M> getErrorMessages();

    default public void addError(M error) {
        this.getErrorMessages().add(error);
    }

    default public void addAllErrors(Collection<M> errors) {
        this.getErrorMessages().addAll(errors);
    }

    default public boolean hasErrors() {
        return this.getErrorMessages().size() != 0;
    }

    @Override
    default public String render() {
        StrBuilder ret = new StrBuilder(100);
        for (M m : this.getErrorMessages()) {
            if (m instanceof DoesRender) {
                ret.append(((DoesRender)m).render());
            } else {
                ret.append(m);
            }
            ret.appendNewLine();
        }
        return ret.toString();
    }

    public static <M> IsErrorSet<M> create() {
        return new IsErrorSet<M>(){
            final Set<M> errorSet = new LinkedHashSet();

            @Override
            public Set<M> getErrorMessages() {
                return this.errorSet;
            }
        };
    }
}

