/*
 * Decompiled with CFR 0.152.
 */
package kafka.security;

import java.util.Collection;
import java.util.Properties;
import kafka.security.CredentialProvider$;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005%a\u0001\u0002\b\u0010\u0001QA\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001\b\u0005\t_\u0001\u0011)\u0019!C\u0001a!A1\t\u0001B\u0001B\u0003%\u0011\u0007C\u0003E\u0001\u0011\u0005Q\tC\u0004K\u0001\t\u0007I\u0011A&\t\rI\u0003\u0001\u0015!\u0003M\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u0015y\u0006\u0001\"\u0001a\u0011\u0015)\b\u0001\"\u0001w\u000f\u0015Ix\u0002#\u0001{\r\u0015qq\u0002#\u0001|\u0011\u0015!5\u0002\"\u0001}\u0011\u0015i8\u0002\"\u0001\u007f\u0005I\u0019%/\u001a3f]RL\u0017\r\u001c)s_ZLG-\u001a:\u000b\u0005A\t\u0012\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0003I\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001+A\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\t1\u0011I\\=SK\u001a\fqb]2sC6lUm\u00195b]&\u001cXn\u001d\t\u0004;\t\"S\"\u0001\u0010\u000b\u0005}\u0001\u0013\u0001B;uS2T\u0011!I\u0001\u0005U\u00064\u0018-\u0003\u0002$=\tQ1i\u001c7mK\u000e$\u0018n\u001c8\u0011\u0005\u0015bcB\u0001\u0014+!\t9s#D\u0001)\u0015\tI3#\u0001\u0004=e>|GOP\u0005\u0003W]\ta\u0001\u0015:fI\u00164\u0017BA\u0017/\u0005\u0019\u0019FO]5oO*\u00111fF\u0001\u000bi>\\WM\\\"bG\",W#A\u0019\u0011\u0005I\nU\"A\u001a\u000b\u0005Q*\u0014!C5oi\u0016\u0014h.\u00197t\u0015\t1t'\u0001\u0006eK2,w-\u0019;j_:T!\u0001O\u001d\u0002\u000bQ|7.\u001a8\u000b\u0005AQ$BA\u001e=\u0003\u0019\u0019w.\\7p]*\u0011!#\u0010\u0006\u0003}}\na!\u00199bG\",'\"\u0001!\u0002\u0007=\u0014x-\u0003\u0002Cg\t!B)\u001a7fO\u0006$\u0018n\u001c8U_.,gnQ1dQ\u0016\f1\u0002^8lK:\u001c\u0015m\u00195fA\u00051A(\u001b8jiz\"2A\u0012%J!\t9\u0005!D\u0001\u0010\u0011\u0015YB\u00011\u0001\u001d\u0011\u0015yC\u00011\u00012\u0003=\u0019'/\u001a3f]RL\u0017\r\\\"bG\",W#\u0001'\u0011\u00055\u0003V\"\u0001(\u000b\u0005=K\u0014!D1vi\",g\u000e^5dCR|'/\u0003\u0002R\u001d\ny1I]3eK:$\u0018.\u00197DC\u000eDW-\u0001\tde\u0016$WM\u001c;jC2\u001c\u0015m\u00195fA\u0005\tR\u000f\u001d3bi\u0016\u001c%/\u001a3f]RL\u0017\r\\:\u0015\u0007UC&\f\u0005\u0002\u0017-&\u0011qk\u0006\u0002\u0005+:LG\u000fC\u0003Z\u000f\u0001\u0007A%\u0001\u0005vg\u0016\u0014h.Y7f\u0011\u0015Yv\u00011\u0001]\u0003\u0019\u0019wN\u001c4jOB\u0011Q$X\u0005\u0003=z\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0003A)\b\u000fZ1uK\u000e\u0013X\rZ3oi&\fG\u000e\u0006\u0003VC.l\u0007\"\u00022\t\u0001\u0004\u0019\u0017!C7fG\"\fg.[:n!\t!\u0017.D\u0001f\u0015\t1w-A\u0003bI6LgN\u0003\u0002iy\u000591\r\\5f]R\u001c\u0018B\u00016f\u00059\u00196M]1n\u001b\u0016\u001c\u0007.\u00198jg6DQ\u0001\u001c\u0005A\u0002\u0011\nAA\\1nK\")a\u000e\u0003a\u0001_\u0006Q1M]3eK:$\u0018.\u00197\u0011\u0005A\u001cX\"A9\u000b\u0005IL\u0014!B:de\u0006l\u0017B\u0001;r\u0005=\u00196M]1n\u0007J,G-\u001a8uS\u0006d\u0017!\u0005:f[>4Xm\u0011:fI\u0016tG/[1mgR\u0019Qk\u001e=\t\u000b\tL\u0001\u0019A2\t\u000b1L\u0001\u0019\u0001\u0013\u0002%\r\u0013X\rZ3oi&\fG\u000e\u0015:pm&$WM\u001d\t\u0003\u000f.\u0019\"aC\u000b\u0015\u0003i\fQ#^:fe\u000e\u0013X\rZ3oi&\fGnQ8oM&<7/F\u0001\u0000!\u0011\t\t!!\u0002\u000e\u0005\u0005\r!BA.;\u0013\u0011\t9!a\u0001\u0003\u0013\r{gNZ5h\t\u00164\u0007")
public class CredentialProvider {
    private final DelegationTokenCache tokenCache;
    private final CredentialCache credentialCache;

    public static ConfigDef userCredentialConfigs() {
        return CredentialProvider$.MODULE$.userCredentialConfigs();
    }

    public DelegationTokenCache tokenCache() {
        return this.tokenCache;
    }

    public CredentialCache credentialCache() {
        return this.credentialCache;
    }

    public void updateCredentials(String username, Properties config) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ScramMechanism.values())).foreach((Function1 & java.io.Serializable & Serializable)mechanism -> {
            CredentialCache.Cache cache = this.credentialCache().cache(mechanism.mechanismName(), ScramCredential.class);
            if (cache != null) {
                String string = config.getProperty(mechanism.mechanismName());
                if (string == null) {
                    return (ScramCredential)cache.remove(username);
                }
                return (ScramCredential)cache.put(username, (Object)ScramCredentialUtils.credentialFromString((String)string));
            }
            return BoxedUnit.UNIT;
        });
    }

    public void updateCredential(org.apache.kafka.clients.admin.ScramMechanism mechanism, String name, ScramCredential credential) {
        this.credentialCache().cache(mechanism.mechanismName(), ScramCredential.class).put(name, (Object)credential);
    }

    public void removeCredentials(org.apache.kafka.clients.admin.ScramMechanism mechanism, String name) {
        CredentialCache.Cache cache = this.credentialCache().cache(mechanism.mechanismName(), ScramCredential.class);
        if (cache != null) {
            cache.remove(name);
            return;
        }
    }

    public CredentialProvider(Collection<String> scramMechanisms, DelegationTokenCache tokenCache) {
        this.tokenCache = tokenCache;
        this.credentialCache = new CredentialCache();
        ScramCredentialUtils.createCache((CredentialCache)this.credentialCache(), scramMechanisms);
    }
}

