/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.view;

import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.metrics.Aggregation;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.internal.aggregator.DoubleExplicitBucketHistogramAggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.ExplicitBucketHistogramUtils;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import java.util.List;

public final class ExplicitBucketHistogramAggregation
implements Aggregation,
AggregatorFactory {
    private static final Aggregation DEFAULT = new ExplicitBucketHistogramAggregation(ExplicitBucketHistogramUtils.DEFAULT_HISTOGRAM_BUCKET_BOUNDARIES);
    private final List<Double> bucketBoundaries;
    private final double[] bucketBoundaryArray;

    public static Aggregation getDefault() {
        return DEFAULT;
    }

    public static Aggregation create(List<Double> bucketBoundaries) {
        return new ExplicitBucketHistogramAggregation(bucketBoundaries);
    }

    private ExplicitBucketHistogramAggregation(List<Double> bucketBoundaries) {
        this.bucketBoundaries = bucketBoundaries;
        this.bucketBoundaryArray = ExplicitBucketHistogramUtils.createBoundaryArray(bucketBoundaries);
    }

    @Override
    public <T, U extends ExemplarData> Aggregator<T, U> createAggregator(InstrumentDescriptor instrumentDescriptor, ExemplarFilter exemplarFilter) {
        return new DoubleExplicitBucketHistogramAggregator(this.bucketBoundaryArray, () -> ExemplarReservoir.filtered(exemplarFilter, ExemplarReservoir.histogramBucketReservoir(Clock.getDefault(), this.bucketBoundaries)));
    }

    @Override
    public boolean isCompatibleWithInstrument(InstrumentDescriptor instrumentDescriptor) {
        switch (instrumentDescriptor.getType()) {
            case COUNTER: 
            case HISTOGRAM: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "ExplicitBucketHistogramAggregation(" + this.bucketBoundaries.toString() + ")";
    }
}

