/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.gzip;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.archive.format.gzip.GZIPConstants;
import org.archive.format.gzip.GZIPFormatException;
import org.archive.util.ByteOp;

public class GZIPStaticHeader
implements GZIPConstants {
    private static final int GZIP_STATIC_HEADER_SIZE_MINUS_3 = 7;
    public static final byte[] DEFAULT_HEADER_DATA = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 3};
    private byte[] data = null;

    public GZIPStaticHeader() {
        this.data = ByteOp.copy(DEFAULT_HEADER_DATA);
    }

    public GZIPStaticHeader(InputStream is, boolean assume1st3) throws GZIPFormatException, IOException {
        this.data = ByteOp.copy(DEFAULT_HEADER_DATA);
        int amt = is.read(this.data, 3, 7);
        if (amt != 7) {
            throw new GZIPFormatException("Short header");
        }
        this.validateBuffer();
    }

    public GZIPStaticHeader(InputStream is) throws GZIPFormatException, IOException {
        try {
            this.data = ByteOp.readNBytes(is, 10);
        }
        catch (EOFException e) {
            throw new GZIPFormatException("Short header", e);
        }
        this.validateBuffer();
    }

    public GZIPStaticHeader(byte[] data) throws GZIPFormatException {
        if (data.length != 10) {
            throw new GZIPFormatException("Short header");
        }
        this.data = data;
        this.validateBuffer();
    }

    public int getLength() {
        return 10;
    }

    public void writeTo(byte[] buf, int offset) {
        if (buf.length - offset < 10) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.data, 0, buf, offset, 10);
    }

    public void writeTo(OutputStream os) throws IOException {
        os.write(this.data);
    }

    private void validateBuffer() throws GZIPFormatException {
        if ((this.data[0] & 0xFF) != 31) {
            throw new GZIPFormatException("bad magic 1");
        }
        if ((this.data[1] & 0xFF) != 139) {
            throw new GZIPFormatException("bad magic 2");
        }
        if ((this.data[2] & 0xFF) != 8) {
            throw new GZIPFormatException("bad compression method");
        }
        byte flg = (byte)(this.data[3] & 0xFF);
        if ((flg & 0x1F) != flg) {
            throw new GZIPFormatException("bad flag bits");
        }
    }

    private void setFLG(int flag, boolean val) {
        this.data[3] = val ? (byte)(this.data[3] | (byte)flag) : (byte)(this.data[3] & (byte)(~flag));
    }

    private boolean isFLGSet(int flag) {
        return (this.data[3] & flag) == flag;
    }

    public int getIntVal(int offset) {
        return this.data[offset] & 0xFF;
    }

    public int getOS() {
        return this.getIntVal(9);
    }

    public long getMTime() {
        return ByteOp.bytesToInt(this.data, 4);
    }

    public boolean isFTextSet() {
        return this.isFLGSet(1);
    }

    public void setFTextFlag(boolean val) {
        this.setFLG(1, val);
    }

    public boolean isFHCRCSet() {
        return this.isFLGSet(2);
    }

    public void setFHCRCFlag(boolean val) {
        this.setFLG(2, val);
    }

    public boolean isFExtraSet() {
        return this.isFLGSet(4);
    }

    public void setFExtraFlag(boolean val) {
        this.setFLG(4, val);
    }

    public boolean isFNameSet() {
        return this.isFLGSet(8);
    }

    public void setFNameFlag(boolean val) {
        this.setFLG(8, val);
    }

    public boolean isFCommentSet() {
        return this.isFLGSet(16);
    }

    public void setFCommentFlag(boolean val) {
        this.setFLG(16, val);
    }
}

