/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.gzip.zipnum;

import java.io.IOException;
import org.archive.util.iterator.AbstractPeekableIterator;
import org.archive.util.iterator.CloseableIterator;

public class TimestampDedupIterator
extends AbstractPeekableIterator<String> {
    protected int timestampDedupLength = 0;
    protected CloseableIterator<String> inner;
    protected boolean isFirst = true;
    protected String nextLine = null;
    protected String nextStamp = null;

    public TimestampDedupIterator(CloseableIterator<String> inner, int timestampDedupLength) {
        this.inner = inner;
        this.timestampDedupLength = timestampDedupLength;
    }

    protected String extractMatchKey(String line) {
        if (line == null) {
            return null;
        }
        if (this.timestampDedupLength <= 0) {
            return null;
        }
        int space = line.indexOf(32);
        if (space >= 0) {
            return line.substring(0, space + 1 + this.timestampDedupLength);
        }
        return line;
    }

    protected boolean isSame(String currStamp, String nextStamp, String currLine, String nextLine) {
        if (currStamp == null || nextStamp == null) {
            return false;
        }
        return currStamp.equals(nextStamp);
    }

    @Override
    public String getNextInner() {
        if (this.isFirst) {
            if (this.inner.hasNext()) {
                this.nextLine = (String)this.inner.next();
                this.nextStamp = this.extractMatchKey(this.nextLine);
            }
            this.isFirst = false;
        }
        String currLine = null;
        String currStamp = null;
        do {
            currLine = this.nextLine;
            currStamp = this.nextStamp;
            this.nextLine = this.inner.hasNext() ? (String)this.inner.next() : null;
            this.nextStamp = this.extractMatchKey(this.nextLine);
        } while (this.nextLine != null && this.isSame(currStamp, this.nextStamp, currLine, this.nextLine));
        return currLine;
    }

    protected String getNthField(String source, int start, int num, int ch) {
        int lastIndex = -1;
        int index = start;
        for (int i = 0; i <= num; ++i) {
            lastIndex = index;
            if ((index = source.indexOf(32, index) + 1) >= 0) continue;
            return null;
        }
        return source.substring(lastIndex, index - 1);
    }

    @Override
    public void close() throws IOException {
        if (this.inner != null) {
            this.inner.close();
            this.inner = null;
        }
    }
}

