/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.http;

import java.io.IOException;
import java.io.InputStream;
import org.archive.format.http.HttpMessageParser;
import org.archive.format.http.HttpParseException;
import org.archive.format.http.HttpRequestMessage;
import org.archive.format.http.HttpRequestMessageObserver;

public class HttpRequestMessageParser
extends HttpMessageParser {
    public int maxBytes = 0x100000;
    public boolean strict = false;

    public HttpRequestMessage parse(InputStream is) throws HttpParseException, IOException {
        HttpRequestMessage message = new HttpRequestMessage();
        this.parse(is, message);
        return message;
    }

    public int parse(InputStream is, HttpRequestMessageObserver obs) throws HttpParseException, IOException {
        byte[] buf = new byte[this.maxBytes];
        for (int bytesRead = 0; bytesRead < this.maxBytes; ++bytesRead) {
            byte b;
            int i = is.read();
            if (i == -1) {
                if (this.strict) {
                    throw new HttpParseException("EOF before CRLF");
                }
                obs.messageCorrupt();
                return bytesRead;
            }
            if (i > 127) {
                if (this.strict) {
                    throw new HttpParseException("Non ASCII byte in message");
                }
                obs.messageCorrupt();
                return bytesRead;
            }
            buf[bytesRead] = b = (byte)(i & 0xFF);
            if (b != 10) continue;
            return this.parse(buf, bytesRead, obs);
        }
        throw new HttpParseException("Response Message too long");
    }

    public int parse(byte[] buf, int len, HttpRequestMessageObserver obs) throws HttpParseException, IOException {
        return this.strict ? this.parseStrict(buf, len, obs) : this.parseLax(buf, len, obs);
    }

    public int parseStrict(byte[] buf, int len, HttpRequestMessageObserver obs) throws HttpParseException {
        int origLen = len;
        if (buf[len - 1] != 10) {
            throw new HttpParseException("Response Message missing LF");
        }
        if (buf[--len - 1] != 13) {
            throw new HttpParseException("Response Message missing CRLF");
        }
        --len;
        int version = 0;
        int method = 0;
        String path = null;
        int idx = 0;
        int ms = 0;
        int ml = 0;
        int ps = -1;
        int pl = 0;
        int vs = -1;
        int vl = 0;
        while (buf[idx] != 32) {
            ++ml;
            if (++idx < len) continue;
            throw new HttpParseException("No spaces in message");
        }
        if (idx == 0) {
            throw new HttpParseException("Http Request starts with SP");
        }
        method = this.parseMethodStrict(buf, ms, idx);
        ps = ++idx;
        while (buf[idx] != 32) {
            ++pl;
            if (++idx < len) continue;
            throw new HttpParseException("No spaces in message");
        }
        if (pl == 0) {
            throw new HttpParseException("Empty Path");
        }
        path = new String(buf, ps, pl, UTF8);
        vs = ++idx;
        vl = len - vs;
        while (idx < len) {
            if (buf[idx] == 32) {
                throw new HttpParseException("Too many fields in HTTP Request");
            }
            ++idx;
        }
        version = this.parseVersionStrict(buf, vs, vl);
        obs.messageParsed(method, path, version, origLen);
        return origLen;
    }

    public int parseLax(byte[] buf, int len, HttpRequestMessageObserver obs) throws HttpParseException {
        int origLen = len;
        if (buf[len - 1] != 10) {
            throw new HttpParseException("Response Message missing LF");
        }
        if (buf[--len - 1] == 13) {
            --len;
        }
        int version = 0;
        int method = 0;
        String path = "";
        int idx = 0;
        int ms = 0;
        int ml = 0;
        int ps = -1;
        int pl = 0;
        int vs = -1;
        int vl = 0;
        while (buf[idx] == 32) {
            if (++idx < len) continue;
            throw new HttpParseException("No spaces in message");
        }
        ms = idx;
        while (buf[idx] != 32) {
            ++ml;
            if (++idx < len) continue;
            throw new HttpParseException("No spaces in message");
        }
        method = this.parseMethodLax(buf, ms, ml);
        while (buf[idx] == 32) {
            if (++idx < len) continue;
            throw new HttpParseException("No spaces in message");
        }
        ps = idx;
        while (buf[idx] != 32) {
            ++pl;
            if (++idx < len) continue;
            throw new HttpParseException("No spaces in message");
        }
        if (pl > 0) {
            path = new String(buf, ps, pl, UTF8);
        }
        while (buf[idx] == 32) {
            if (++idx < len) continue;
            throw new HttpParseException("No spaces in message");
        }
        vs = idx;
        while (idx < len && buf[idx] != 32) {
            ++vl;
            ++idx;
        }
        version = this.parseVersionLax(buf, vs, vl);
        obs.messageParsed(method, path, version, origLen);
        return len;
    }

    protected int parseMethodStrict(byte[] buf, int start, int len) throws HttpParseException {
        String v = new String(buf, start, len, UTF8);
        if (v.compareTo("GET") == 0) {
            return 1;
        }
        if (v.compareTo("HEAD") == 0) {
            return 2;
        }
        if (v.compareTo("POST") == 0) {
            return 3;
        }
        if (v.compareTo("PUT") == 0) {
            return 4;
        }
        if (v.compareTo("TRACE") == 0) {
            return 5;
        }
        if (v.compareTo("DELETE") == 0) {
            return 6;
        }
        if (v.compareTo("CONNECT") == 0) {
            return 7;
        }
        throw new HttpParseException("Unknown version");
    }

    protected int parseMethodLax(byte[] buf, int start, int len) throws HttpParseException {
        String v = new String(buf, start, len, UTF8).toUpperCase();
        if (v.compareTo("GET") == 0) {
            return 1;
        }
        if (v.compareTo("HEAD") == 0) {
            return 2;
        }
        if (v.compareTo("POST") == 0) {
            return 3;
        }
        if (v.compareTo("PUT") == 0) {
            return 4;
        }
        if (v.compareTo("TRACE") == 0) {
            return 5;
        }
        if (v.compareTo("DELETE") == 0) {
            return 6;
        }
        if (v.compareTo("CONNECT") == 0) {
            return 7;
        }
        return 0;
    }
}

