/*
 * Decompiled with CFR 0.152.
 */
package org.archive.streamcontext;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.archive.streamcontext.AbstractBufferingStream;

public class RandomAccessFileStream
extends AbstractBufferingStream {
    private RandomAccessFile raf = null;
    private File file = null;

    public RandomAccessFileStream(File file) throws IndexOutOfBoundsException, FileNotFoundException, IOException {
        this(file, 0L, DEFAULT_READ_SIZE);
    }

    public RandomAccessFileStream(File file, long offset) throws IndexOutOfBoundsException, FileNotFoundException, IOException {
        this(file, offset, DEFAULT_READ_SIZE);
    }

    public RandomAccessFileStream(File file, long offset, int readSize) throws IndexOutOfBoundsException, FileNotFoundException, IOException {
        super(offset, readSize);
        this.raf = new RandomAccessFile(file, "r");
        if (offset > 0L) {
            this.raf.seek(offset);
        }
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public void doClose() throws IOException {
        this.raf.close();
    }

    @Override
    public int doRead(byte[] b, int off, int len) throws IOException {
        return this.raf.read(b, off, len);
    }

    @Override
    public void doSeek(long offset) throws IOException {
        this.raf.seek(offset);
    }
}

