/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.iterator;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.archive.util.iterator.CloseableIterator;

public class CloseableCompositeIterator<E>
implements CloseableIterator<E> {
    protected LinkedList<CloseableIterator<E>> iters = new LinkedList();
    protected Iterator<CloseableIterator<E>> iterPtr;
    protected CloseableIterator<E> currIter;

    public void addFirst(CloseableIterator<E> e) {
        this.iters.addFirst(e);
    }

    public void addLast(CloseableIterator<E> e) {
        this.iters.addLast(e);
    }

    @Override
    public boolean hasNext() {
        if (this.iterPtr == null) {
            this.iterPtr = this.iters.iterator();
            this.currIter = this.iterPtr.next();
        }
        if (this.currIter == null) {
            return false;
        }
        while (this.currIter != null) {
            if (this.currIter.hasNext()) {
                return true;
            }
            this.currIter = this.iterPtr.hasNext() ? this.iterPtr.next() : null;
        }
        return false;
    }

    @Override
    public E next() {
        return this.currIter.next();
    }

    @Override
    public void remove() {
        this.currIter.remove();
    }

    @Override
    public void close() throws IOException {
        for (CloseableIterator closeableIterator : this.iters) {
            if (closeableIterator == null) continue;
            try {
                closeableIterator.close();
            }
            catch (IOException iOException) {}
        }
    }
}

