/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// Reply is the corresponding interface of Reply
type Reply interface {
	ReplyContract
	ReplyRequirements
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsReply is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsReply()
	// CreateBuilder creates a ReplyBuilder
	CreateReplyBuilder() ReplyBuilder
}

// ReplyContract provides a set of functions which can be overwritten by a sub struct
type ReplyContract interface {
	// GetPeekedByte returns PeekedByte (property field)
	GetPeekedByte() byte
	// GetCBusOptions() returns a parser argument
	GetCBusOptions() CBusOptions
	// GetRequestContext() returns a parser argument
	GetRequestContext() RequestContext
	// IsReply is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsReply()
	// CreateBuilder creates a ReplyBuilder
	CreateReplyBuilder() ReplyBuilder
}

// ReplyRequirements provides a set of functions which need to be implemented by a sub struct
type ReplyRequirements interface {
	GetLengthInBits(ctx context.Context) uint16
	GetLengthInBytes(ctx context.Context) uint16
	// GetPeekedByte returns PeekedByte (discriminator field)
	GetPeekedByte() byte
}

// _Reply is the data-structure of this message
type _Reply struct {
	_SubType interface {
		ReplyContract
		ReplyRequirements
	}
	PeekedByte byte

	// Arguments.
	CBusOptions    CBusOptions
	RequestContext RequestContext
}

var _ ReplyContract = (*_Reply)(nil)

// NewReply factory function for _Reply
func NewReply(peekedByte byte, cBusOptions CBusOptions, requestContext RequestContext) *_Reply {
	return &_Reply{PeekedByte: peekedByte, CBusOptions: cBusOptions, RequestContext: requestContext}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ReplyBuilder is a builder for Reply
type ReplyBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(peekedByte byte) ReplyBuilder
	// WithPeekedByte adds PeekedByte (property field)
	WithPeekedByte(byte) ReplyBuilder
	// WithArgCBusOptions sets a parser argument
	WithArgCBusOptions(CBusOptions) ReplyBuilder
	// WithArgRequestContext sets a parser argument
	WithArgRequestContext(RequestContext) ReplyBuilder
	// AsPowerUpReply converts this build to a subType of Reply. It is always possible to return to current builder using Done()
	AsPowerUpReply() PowerUpReplyBuilder
	// AsParameterChangeReply converts this build to a subType of Reply. It is always possible to return to current builder using Done()
	AsParameterChangeReply() ParameterChangeReplyBuilder
	// AsReplyEncodedReply converts this build to a subType of Reply. It is always possible to return to current builder using Done()
	AsReplyEncodedReply() ReplyEncodedReplyBuilder
	// Build builds the Reply or returns an error if something is wrong
	PartialBuild() (ReplyContract, error)
	// MustBuild does the same as Build but panics on error
	PartialMustBuild() ReplyContract
	// Build builds the Reply or returns an error if something is wrong
	Build() (Reply, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() Reply
}

// NewReplyBuilder() creates a ReplyBuilder
func NewReplyBuilder() ReplyBuilder {
	return &_ReplyBuilder{_Reply: new(_Reply)}
}

type _ReplyChildBuilder interface {
	utils.Copyable
	setParent(ReplyContract)
	buildForReply() (Reply, error)
}

type _ReplyBuilder struct {
	*_Reply

	childBuilder _ReplyChildBuilder

	collectedErr []error
}

var _ (ReplyBuilder) = (*_ReplyBuilder)(nil)

func (b *_ReplyBuilder) WithMandatoryFields(peekedByte byte) ReplyBuilder {
	return b.WithPeekedByte(peekedByte)
}

func (b *_ReplyBuilder) WithPeekedByte(peekedByte byte) ReplyBuilder {
	b.PeekedByte = peekedByte
	return b
}

func (b *_ReplyBuilder) WithArgCBusOptions(cBusOptions CBusOptions) ReplyBuilder {
	b.CBusOptions = cBusOptions
	return b
}
func (b *_ReplyBuilder) WithArgRequestContext(requestContext RequestContext) ReplyBuilder {
	b.RequestContext = requestContext
	return b
}

func (b *_ReplyBuilder) PartialBuild() (ReplyContract, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._Reply.deepCopy(), nil
}

func (b *_ReplyBuilder) PartialMustBuild() ReplyContract {
	build, err := b.PartialBuild()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ReplyBuilder) AsPowerUpReply() PowerUpReplyBuilder {
	if cb, ok := b.childBuilder.(PowerUpReplyBuilder); ok {
		return cb
	}
	cb := NewPowerUpReplyBuilder().(*_PowerUpReplyBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ReplyBuilder) AsParameterChangeReply() ParameterChangeReplyBuilder {
	if cb, ok := b.childBuilder.(ParameterChangeReplyBuilder); ok {
		return cb
	}
	cb := NewParameterChangeReplyBuilder().(*_ParameterChangeReplyBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ReplyBuilder) AsReplyEncodedReply() ReplyEncodedReplyBuilder {
	if cb, ok := b.childBuilder.(ReplyEncodedReplyBuilder); ok {
		return cb
	}
	cb := NewReplyEncodedReplyBuilder().(*_ReplyEncodedReplyBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ReplyBuilder) Build() (Reply, error) {
	v, err := b.PartialBuild()
	if err != nil {
		return nil, errors.Wrap(err, "error occurred during partial build")
	}
	if b.childBuilder == nil {
		return nil, errors.New("no child builder present")
	}
	b.childBuilder.setParent(v)
	return b.childBuilder.buildForReply()
}

func (b *_ReplyBuilder) MustBuild() Reply {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ReplyBuilder) DeepCopy() any {
	_copy := b.CreateReplyBuilder().(*_ReplyBuilder)
	_copy.childBuilder = b.childBuilder.DeepCopy().(_ReplyChildBuilder)
	_copy.childBuilder.setParent(_copy)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateReplyBuilder creates a ReplyBuilder
func (b *_Reply) CreateReplyBuilder() ReplyBuilder {
	if b == nil {
		return NewReplyBuilder()
	}
	return &_ReplyBuilder{_Reply: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_Reply) GetPeekedByte() byte {
	return m.PeekedByte
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastReply(structType any) Reply {
	if casted, ok := structType.(Reply); ok {
		return casted
	}
	if casted, ok := structType.(*Reply); ok {
		return *casted
	}
	return nil
}

func (m *_Reply) GetTypeName() string {
	return "Reply"
}

func (m *_Reply) getLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	return lengthInBits
}

func (m *_Reply) GetLengthInBits(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx)
}

func (m *_Reply) GetLengthInBytes(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx) / 8
}

func ReplyParse[T Reply](ctx context.Context, theBytes []byte, cBusOptions CBusOptions, requestContext RequestContext) (T, error) {
	return ReplyParseWithBuffer[T](ctx, utils.NewReadBufferByteBased(theBytes), cBusOptions, requestContext)
}

func ReplyParseWithBufferProducer[T Reply](cBusOptions CBusOptions, requestContext RequestContext) func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
		v, err := ReplyParseWithBuffer[T](ctx, readBuffer, cBusOptions, requestContext)
		if err != nil {
			var zero T
			return zero, err
		}
		return v, nil
	}
}

func ReplyParseWithBuffer[T Reply](ctx context.Context, readBuffer utils.ReadBuffer, cBusOptions CBusOptions, requestContext RequestContext) (T, error) {
	v, err := (&_Reply{CBusOptions: cBusOptions, RequestContext: requestContext}).parse(ctx, readBuffer, cBusOptions, requestContext)
	if err != nil {
		var zero T
		return zero, err
	}
	vc, ok := v.(T)
	if !ok {
		var zero T
		return zero, errors.Errorf("Unexpected type %T. Expected type %T", v, *new(T))
	}
	return vc, nil
}

func (m *_Reply) parse(ctx context.Context, readBuffer utils.ReadBuffer, cBusOptions CBusOptions, requestContext RequestContext) (__reply Reply, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("Reply"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for Reply")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	peekedByte, err := ReadPeekField[byte](ctx, "peekedByte", ReadByte(readBuffer, 8), 0)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'peekedByte' field"))
	}
	m.PeekedByte = peekedByte

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _child Reply
	switch {
	case peekedByte == 0x2B: // PowerUpReply
		if _child, err = new(_PowerUpReply).parse(ctx, readBuffer, m, cBusOptions, requestContext); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type PowerUpReply for type-switch of Reply")
		}
	case peekedByte == 0x3D: // ParameterChangeReply
		if _child, err = new(_ParameterChangeReply).parse(ctx, readBuffer, m, cBusOptions, requestContext); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ParameterChangeReply for type-switch of Reply")
		}
	case 0 == 0: // ReplyEncodedReply
		if _child, err = new(_ReplyEncodedReply).parse(ctx, readBuffer, m, cBusOptions, requestContext); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ReplyEncodedReply for type-switch of Reply")
		}
	default:
		return nil, errors.Errorf("Unmapped type for parameters [peekedByte=%v]", peekedByte)
	}

	if closeErr := readBuffer.CloseContext("Reply"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for Reply")
	}

	return _child, nil
}

func (pm *_Reply) serializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child Reply, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("Reply"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for Reply")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("Reply"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for Reply")
	}
	return nil
}

////
// Arguments Getter

func (m *_Reply) GetCBusOptions() CBusOptions {
	return m.CBusOptions
}
func (m *_Reply) GetRequestContext() RequestContext {
	return m.RequestContext
}

//
////

func (m *_Reply) IsReply() {}

func (m *_Reply) DeepCopy() any {
	return m.deepCopy()
}

func (m *_Reply) deepCopy() *_Reply {
	if m == nil {
		return nil
	}
	_ReplyCopy := &_Reply{
		nil, // will be set by child
		m.PeekedByte,
		m.CBusOptions,
		m.RequestContext,
	}
	return _ReplyCopy
}
