/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class BACnetConfirmedServiceRequest implements Message {

  // Abstract accessors for discriminator values.
  public abstract BACnetConfirmedServiceChoice getServiceChoice();

  // Arguments.
  protected final Long serviceRequestLength;

  public BACnetConfirmedServiceRequest(Long serviceRequestLength) {
    super();
    this.serviceRequestLength = serviceRequestLength;
  }

  public long getServiceRequestPayloadLength() {
    return (long) (((((serviceRequestLength) > (0))) ? ((serviceRequestLength) - (1L)) : 0L));
  }

  protected abstract void serializeBACnetConfirmedServiceRequestChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetConfirmedServiceRequest");

    // Discriminator Field (serviceChoice) (Used as input to a switch field)
    writeDiscriminatorEnumField(
        "serviceChoice",
        "BACnetConfirmedServiceChoice",
        getServiceChoice(),
        writeEnum(
            BACnetConfirmedServiceChoice::getValue,
            BACnetConfirmedServiceChoice::name,
            writeUnsignedShort(writeBuffer, 8)));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    long serviceRequestPayloadLength = getServiceRequestPayloadLength();
    writeBuffer.writeVirtual("serviceRequestPayloadLength", serviceRequestPayloadLength);

    // Switch field (Serialize the sub-type)
    serializeBACnetConfirmedServiceRequestChild(writeBuffer);

    writeBuffer.popContext("BACnetConfirmedServiceRequest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    BACnetConfirmedServiceRequest _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Discriminator Field (serviceChoice)
    lengthInBits += 8;

    // A virtual field doesn't have any in- or output.

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static BACnetConfirmedServiceRequest staticParse(
      ReadBuffer readBuffer, Long serviceRequestLength) throws ParseException {
    readBuffer.pullContext("BACnetConfirmedServiceRequest");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetConfirmedServiceChoice serviceChoice =
        readDiscriminatorEnumField(
            "serviceChoice",
            "BACnetConfirmedServiceChoice",
            readEnum(BACnetConfirmedServiceChoice::enumForValue, readUnsignedShort(readBuffer, 8)));
    long serviceRequestPayloadLength =
        readVirtualField(
            "serviceRequestPayloadLength",
            long.class,
            ((((serviceRequestLength) > (0))) ? ((serviceRequestLength) - (1L)) : 0L));

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    BACnetConfirmedServiceRequestBuilder builder = null;
    if (EvaluationHelper.equals(serviceChoice, BACnetConfirmedServiceChoice.ACKNOWLEDGE_ALARM)) {
      builder =
          BACnetConfirmedServiceRequestAcknowledgeAlarm
              .staticParseBACnetConfirmedServiceRequestBuilder(readBuffer, serviceRequestLength);
    } else if (EvaluationHelper.equals(
        serviceChoice, BACnetConfirmedServiceChoice.CONFIRMED_COV_NOTIFICATION)) {
      builder =
          BACnetConfirmedServiceRequestConfirmedCOVNotification
              .staticParseBACnetConfirmedServiceRequestBuilder(readBuffer, serviceRequestLength);
    } else if (EvaluationHelper.equals(
        serviceChoice, BACnetConfirmedServiceChoice.CONFIRMED_COV_NOTIFICATION_MULTIPLE)) {
      builder =
          BACnetConfirmedServiceRequestConfirmedCOVNotificationMultiple
              .staticParseBACnetConfirmedServiceRequestBuilder(readBuffer, serviceRequestLength);
    } else if (EvaluationHelper.equals(
        serviceChoice, BACnetConfirmedServiceChoice.CONFIRMED_EVENT_NOTIFICATION)) {
      builder =
          BACnetConfirmedServiceRequestConfirmedEventNotification
              .staticParseBACnetConfirmedServiceRequestBuilder(readBuffer, serviceRequestLength);
    } else if (EvaluationHelper.equals(
        serviceChoice, BACnetConfirmedServiceChoice.GET_ENROLLMENT_SUMMARY)) {
      builder =
          BACnetConfirmedServiceRequestGetEnrollmentSummary
              .staticParseBACnetConfirmedServiceRequestBuilder(readBuffer, serviceRequestLength);
    } else if (EvaluationHelper.equals(
        serviceChoice, BACnetConfirmedServiceChoice.GET_EVENT_INFORMATION)) {
      builder =
          BACnetConfirmedServiceRequestGetEventInformation
              .staticParseBACnetConfirmedServiceRequestBuilder(readBuffer, serviceRequestLength);
    } else if (EvaluationHelper.equals(
        serviceChoice, BACnetConfirmedServiceChoice.LIFE_SAFETY_OPERATION)) {
      builder =
          BACnetConfirmedServiceRequestLifeSafetyOperation
              .staticParseBACnetConfirmedServiceRequestBuilder(readBuffer, serviceRequestLength);
    } else if (EvaluationHelper.equals(serviceChoice, BACnetConfirmedServiceChoice.SUBSCRIBE_COV)) {
      builder =
          BACnetConfirmedServiceRequestSubscribeCOV.staticParseBACnetConfirmedServiceRequestBuilder(
              readBuffer, serviceRequestLength);
    } else if (EvaluationHelper.equals(
        serviceChoice, BACnetConfirmedServiceChoice.SUBSCRIBE_COV_PROPERTY)) {
      builder =
          BACnetConfirmedServiceRequestSubscribeCOVProperty
              .staticParseBACnetConfirmedServiceRequestBuilder(readBuffer, serviceRequestLength);
    } else if (EvaluationHelper.equals(
        serviceChoice, BACnetConfirmedServiceChoice.SUBSCRIBE_COV_PROPERTY_MULTIPLE)) {
      builder =
          BACnetConfirmedServiceRequestSubscribeCOVPropertyMultiple
              .staticParseBACnetConfirmedServiceRequestBuilder(readBuffer, serviceRequestLength);
    } else if (EvaluationHelper.equals(
        serviceChoice, BACnetConfirmedServiceChoice.ATOMIC_READ_FILE)) {
      builder =
          BACnetConfirmedServiceRequestAtomicReadFile
              .staticParseBACnetConfirmedServiceRequestBuilder(readBuffer, serviceRequestLength);
    } else if (EvaluationHelper.equals(
        serviceChoice, BACnetConfirmedServiceChoice.ATOMIC_WRITE_FILE)) {
      builder =
          BACnetConfirmedServiceRequestAtomicWriteFile
              .staticParseBACnetConfirmedServiceRequestBuilder(readBuffer, serviceRequestLength);
    } else if (EvaluationHelper.equals(
        serviceChoice, BACnetConfirmedServiceChoice.ADD_LIST_ELEMENT)) {
      builder =
          BACnetConfirmedServiceRequestAddListElement
              .staticParseBACnetConfirmedServiceRequestBuilder(readBuffer, serviceRequestLength);
    } else if (EvaluationHelper.equals(
        serviceChoice, BACnetConfirmedServiceChoice.REMOVE_LIST_ELEMENT)) {
      builder =
          BACnetConfirmedServiceRequestRemoveListElement
              .staticParseBACnetConfirmedServiceRequestBuilder(readBuffer, serviceRequestLength);
    } else if (EvaluationHelper.equals(serviceChoice, BACnetConfirmedServiceChoice.CREATE_OBJECT)) {
      builder =
          BACnetConfirmedServiceRequestCreateObject.staticParseBACnetConfirmedServiceRequestBuilder(
              readBuffer, serviceRequestLength);
    } else if (EvaluationHelper.equals(serviceChoice, BACnetConfirmedServiceChoice.DELETE_OBJECT)) {
      builder =
          BACnetConfirmedServiceRequestDeleteObject.staticParseBACnetConfirmedServiceRequestBuilder(
              readBuffer, serviceRequestLength);
    } else if (EvaluationHelper.equals(serviceChoice, BACnetConfirmedServiceChoice.READ_PROPERTY)) {
      builder =
          BACnetConfirmedServiceRequestReadProperty.staticParseBACnetConfirmedServiceRequestBuilder(
              readBuffer, serviceRequestLength);
    } else if (EvaluationHelper.equals(
        serviceChoice, BACnetConfirmedServiceChoice.READ_PROPERTY_MULTIPLE)) {
      builder =
          BACnetConfirmedServiceRequestReadPropertyMultiple
              .staticParseBACnetConfirmedServiceRequestBuilder(
                  readBuffer, serviceRequestPayloadLength, serviceRequestLength);
    } else if (EvaluationHelper.equals(serviceChoice, BACnetConfirmedServiceChoice.READ_RANGE)) {
      builder =
          BACnetConfirmedServiceRequestReadRange.staticParseBACnetConfirmedServiceRequestBuilder(
              readBuffer, serviceRequestLength);
    } else if (EvaluationHelper.equals(
        serviceChoice, BACnetConfirmedServiceChoice.WRITE_PROPERTY)) {
      builder =
          BACnetConfirmedServiceRequestWriteProperty
              .staticParseBACnetConfirmedServiceRequestBuilder(readBuffer, serviceRequestLength);
    } else if (EvaluationHelper.equals(
        serviceChoice, BACnetConfirmedServiceChoice.WRITE_PROPERTY_MULTIPLE)) {
      builder =
          BACnetConfirmedServiceRequestWritePropertyMultiple
              .staticParseBACnetConfirmedServiceRequestBuilder(
                  readBuffer, serviceRequestPayloadLength, serviceRequestLength);
    } else if (EvaluationHelper.equals(
        serviceChoice, BACnetConfirmedServiceChoice.DEVICE_COMMUNICATION_CONTROL)) {
      builder =
          BACnetConfirmedServiceRequestDeviceCommunicationControl
              .staticParseBACnetConfirmedServiceRequestBuilder(readBuffer, serviceRequestLength);
    } else if (EvaluationHelper.equals(
        serviceChoice, BACnetConfirmedServiceChoice.CONFIRMED_PRIVATE_TRANSFER)) {
      builder =
          BACnetConfirmedServiceRequestConfirmedPrivateTransfer
              .staticParseBACnetConfirmedServiceRequestBuilder(readBuffer, serviceRequestLength);
    } else if (EvaluationHelper.equals(
        serviceChoice, BACnetConfirmedServiceChoice.CONFIRMED_TEXT_MESSAGE)) {
      builder =
          BACnetConfirmedServiceRequestConfirmedTextMessage
              .staticParseBACnetConfirmedServiceRequestBuilder(readBuffer, serviceRequestLength);
    } else if (EvaluationHelper.equals(
        serviceChoice, BACnetConfirmedServiceChoice.REINITIALIZE_DEVICE)) {
      builder =
          BACnetConfirmedServiceRequestReinitializeDevice
              .staticParseBACnetConfirmedServiceRequestBuilder(readBuffer, serviceRequestLength);
    } else if (EvaluationHelper.equals(serviceChoice, BACnetConfirmedServiceChoice.VT_OPEN)) {
      builder =
          BACnetConfirmedServiceRequestVTOpen.staticParseBACnetConfirmedServiceRequestBuilder(
              readBuffer, serviceRequestLength);
    } else if (EvaluationHelper.equals(serviceChoice, BACnetConfirmedServiceChoice.VT_CLOSE)) {
      builder =
          BACnetConfirmedServiceRequestVTClose.staticParseBACnetConfirmedServiceRequestBuilder(
              readBuffer, serviceRequestPayloadLength, serviceRequestLength);
    } else if (EvaluationHelper.equals(serviceChoice, BACnetConfirmedServiceChoice.VT_DATA)) {
      builder =
          BACnetConfirmedServiceRequestVTData.staticParseBACnetConfirmedServiceRequestBuilder(
              readBuffer, serviceRequestLength);
    } else if (EvaluationHelper.equals(serviceChoice, BACnetConfirmedServiceChoice.AUTHENTICATE)) {
      builder =
          BACnetConfirmedServiceRequestAuthenticate.staticParseBACnetConfirmedServiceRequestBuilder(
              readBuffer, serviceRequestPayloadLength, serviceRequestLength);
    } else if (EvaluationHelper.equals(serviceChoice, BACnetConfirmedServiceChoice.REQUEST_KEY)) {
      builder =
          BACnetConfirmedServiceRequestRequestKey.staticParseBACnetConfirmedServiceRequestBuilder(
              readBuffer, serviceRequestPayloadLength, serviceRequestLength);
    } else if (EvaluationHelper.equals(
        serviceChoice, BACnetConfirmedServiceChoice.READ_PROPERTY_CONDITIONAL)) {
      builder =
          BACnetConfirmedServiceRequestReadPropertyConditional
              .staticParseBACnetConfirmedServiceRequestBuilder(
                  readBuffer, serviceRequestPayloadLength, serviceRequestLength);
    } else if (true) {
      builder =
          BACnetConfirmedServiceRequestUnknown.staticParseBACnetConfirmedServiceRequestBuilder(
              readBuffer, serviceRequestPayloadLength, serviceRequestLength);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "serviceChoice="
              + serviceChoice
              + "]");
    }

    readBuffer.closeContext("BACnetConfirmedServiceRequest");
    // Create the instance
    BACnetConfirmedServiceRequest _bACnetConfirmedServiceRequest =
        builder.build(serviceRequestLength);

    return _bACnetConfirmedServiceRequest;
  }

  public interface BACnetConfirmedServiceRequestBuilder {
    BACnetConfirmedServiceRequest build(Long serviceRequestLength);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetConfirmedServiceRequest)) {
      return false;
    }
    BACnetConfirmedServiceRequest that = (BACnetConfirmedServiceRequest) o;
    return true;
  }

  @Override
  public int hashCode() {
    return Objects.hash();
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
