/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class TelephonyDataRecallLastNumberRequest extends TelephonyData implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final byte recallLastNumberType;

  public TelephonyDataRecallLastNumberRequest(
      TelephonyCommandTypeContainer commandTypeContainer,
      byte argument,
      byte recallLastNumberType) {
    super(commandTypeContainer, argument);
    this.recallLastNumberType = recallLastNumberType;
  }

  public byte getRecallLastNumberType() {
    return recallLastNumberType;
  }

  public boolean getIsNumberOfLastOutgoingCall() {
    return (boolean) ((getRecallLastNumberType()) == (0x01));
  }

  public boolean getIsNumberOfLastIncomingCall() {
    return (boolean) ((getRecallLastNumberType()) == (0x02));
  }

  @Override
  protected void serializeTelephonyDataChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("TelephonyDataRecallLastNumberRequest");

    // Simple Field (recallLastNumberType)
    writeSimpleField("recallLastNumberType", recallLastNumberType, writeByte(writeBuffer, 8));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isNumberOfLastOutgoingCall = getIsNumberOfLastOutgoingCall();
    writeBuffer.writeVirtual("isNumberOfLastOutgoingCall", isNumberOfLastOutgoingCall);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isNumberOfLastIncomingCall = getIsNumberOfLastIncomingCall();
    writeBuffer.writeVirtual("isNumberOfLastIncomingCall", isNumberOfLastIncomingCall);

    writeBuffer.popContext("TelephonyDataRecallLastNumberRequest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    TelephonyDataRecallLastNumberRequest _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (recallLastNumberType)
    lengthInBits += 8;

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    return lengthInBits;
  }

  public static TelephonyDataBuilder staticParseTelephonyDataBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("TelephonyDataRecallLastNumberRequest");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    byte recallLastNumberType = readSimpleField("recallLastNumberType", readByte(readBuffer, 8));
    boolean isNumberOfLastOutgoingCall =
        readVirtualField(
            "isNumberOfLastOutgoingCall", boolean.class, (recallLastNumberType) == (0x01));
    boolean isNumberOfLastIncomingCall =
        readVirtualField(
            "isNumberOfLastIncomingCall", boolean.class, (recallLastNumberType) == (0x02));

    readBuffer.closeContext("TelephonyDataRecallLastNumberRequest");
    // Create the instance
    return new TelephonyDataRecallLastNumberRequestBuilderImpl(recallLastNumberType);
  }

  public static class TelephonyDataRecallLastNumberRequestBuilderImpl
      implements TelephonyData.TelephonyDataBuilder {
    private final byte recallLastNumberType;

    public TelephonyDataRecallLastNumberRequestBuilderImpl(byte recallLastNumberType) {
      this.recallLastNumberType = recallLastNumberType;
    }

    public TelephonyDataRecallLastNumberRequest build(
        TelephonyCommandTypeContainer commandTypeContainer, byte argument) {
      TelephonyDataRecallLastNumberRequest telephonyDataRecallLastNumberRequest =
          new TelephonyDataRecallLastNumberRequest(
              commandTypeContainer, argument, recallLastNumberType);
      return telephonyDataRecallLastNumberRequest;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof TelephonyDataRecallLastNumberRequest)) {
      return false;
    }
    TelephonyDataRecallLastNumberRequest that = (TelephonyDataRecallLastNumberRequest) o;
    return (getRecallLastNumberType() == that.getRecallLastNumberType())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getRecallLastNumberType());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
