/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.client;

import com.netflix.config.DynamicPropertyFactory;
import org.apache.servicecomb.transport.common.TransportConfigUtils;
import org.apache.servicecomb.transport.rest.client.RestTransportClient;

public final class TransportClientConfig {
    private static Class<? extends RestTransportClient> restTransportClientCls = RestTransportClient.class;
    private static final int DEFAULT_IDLE_TIME_OUT = 150;
    private static final int DEFAULT_KEEP_ALIVE_TIME_OUT = 60;

    private TransportClientConfig() {
    }

    public static Class<? extends RestTransportClient> getRestTransportClientCls() {
        return restTransportClientCls;
    }

    public static void setRestTransportClientCls(Class<? extends RestTransportClient> restTransportClientCls) {
        TransportClientConfig.restTransportClientCls = restTransportClientCls;
    }

    public static int getThreadCount() {
        return TransportConfigUtils.readVerticleCount((String)"servicecomb.rest.client.verticle-count", (String)"servicecomb.rest.client.thread-count");
    }

    public static int getHttp2ConnectionMaxPoolSize() {
        return DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.rest.client.http2.maxPoolSize", 1).get();
    }

    public static int getHttp2MultiplexingLimit() {
        return DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.rest.client.http2.multiplexingLimit", -1).get();
    }

    public static boolean getUseAlpn() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.rest.client.http2.useAlpnEnabled", true).get();
    }

    public static boolean isHttp2TransportClientEnabled() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.rest.client.http2.enabled", true).get();
    }

    public static int getConnectionMaxPoolSize() {
        return DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.rest.client.connection.maxPoolSize", 5).get();
    }

    public static int getHttp2ConnectionIdleTimeoutInSeconds() {
        return DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.rest.client.http2.connection.idleTimeoutInSeconds", 150).get();
    }

    public static int getConnectionIdleTimeoutInSeconds() {
        return DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.rest.client.connection.idleTimeoutInSeconds", 150).get();
    }

    public static boolean getConnectionKeepAlive() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.rest.client.connection.keepAlive", true).get();
    }

    public static int getConnectionKeepAliveTimeoutInSeconds() {
        return DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.rest.client.connection.keepAliveTimeoutInSeconds", 60).get();
    }

    public static boolean enableLogActivity() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.rest.client.enableLogActivity", false).get();
    }

    public static int getHttp2ConnectionKeepAliveTimeoutInSeconds() {
        return DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.rest.client.http2.connection.keepAliveTimeoutInSeconds", 60).get();
    }

    public static boolean getConnectionCompression() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.rest.client.connection.compression", false).get();
    }

    public static int getMaxHeaderSize() {
        return DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.rest.client.maxHeaderSize", 8192).get();
    }

    public static int getMaxWaitQueueSize() {
        return DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.rest.client.maxWaitQueueSize", -1).get();
    }

    public static boolean isHttpTransportClientEnabled() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.rest.client.enabled", true).get();
    }

    public static int getConnectionTimeoutInMillis() {
        return DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.rest.client.connection.timeoutInMillis", 60000).get();
    }
}

