/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io;

import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.sis.io.AppendableWriter;
import org.apache.sis.io.Appender;
import org.apache.sis.util.resources.Vocabulary;

public final class IO {
    private IO() {
    }

    public static void flush(Appendable out) throws IOException {
        while (!(out instanceof Flushable)) {
            if (!(out instanceof Appender)) {
                return;
            }
            out = ((Appender)out).out;
        }
        ((Flushable)((Object)out)).flush();
    }

    public static void close(Appendable out) throws IOException {
        boolean isFlushed = false;
        while (!(out instanceof Closeable)) {
            if (!isFlushed && out instanceof Flushable) {
                ((Flushable)((Object)out)).flush();
                isFlushed = true;
            }
            if (!(out instanceof Appender)) {
                return;
            }
            out = ((Appender)out).out;
        }
        ((Closeable)((Object)out)).close();
    }

    public static CharSequence content(Appendable out) {
        while (!(out instanceof CharSequence)) {
            if (!(out instanceof Appender)) {
                if (out instanceof StringWriter) {
                    return ((StringWriter)out).getBuffer();
                }
                if (out instanceof CharArrayWriter) {
                    return ((CharArrayWriter)out).toString();
                }
                return null;
            }
            out = ((Appender)out).out;
        }
        return (CharSequence)((Object)out);
    }

    static String toString(Appendable out) {
        CharSequence content = IO.content(out);
        if (content != null) {
            return content.toString();
        }
        return Vocabulary.format((short)205);
    }

    public static Writer asWriter(Appendable out) {
        if (out == null || out instanceof Writer) {
            return (Writer)out;
        }
        return new AppendableWriter(out);
    }
}

