/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter.base;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.base.Node;

public abstract class BinaryFunction<R, A1, A2>
extends Node {
    private static final long serialVersionUID = -8632475810190545852L;
    protected final Expression<R, ? extends A1> expression1;
    protected final Expression<R, ? extends A2> expression2;

    protected BinaryFunction(Expression<R, ? extends A1> expression1, Expression<R, ? extends A2> expression2) {
        this.expression1 = Objects.requireNonNull(expression1);
        this.expression2 = Objects.requireNonNull(expression2);
    }

    public final Class<? super R> getResourceClass() {
        return BinaryFunction.specializedClass(this.expression1.getResourceClass(), this.expression2.getResourceClass());
    }

    public final List<Expression<R, ?>> getParameters() {
        return this.getExpressions();
    }

    public final List<Expression<R, ?>> getExpressions() {
        return List.of(this.expression1, this.expression2);
    }

    @Override
    protected final Collection<?> getChildren() {
        return this.getExpressions();
    }
}

