/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.sling.servlets.get.impl;

import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.request.builder.Builders;
import org.apache.sling.api.request.builder.SlingJakartaHttpServletResponseResult;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.servlets.get.impl.helpers.JsonRenderer;
import org.apache.sling.testing.mock.sling.junit.SlingContext;
import org.junit.Rule;

import static org.junit.Assert.assertEquals;

public class JsonRendererServletTest {

    @Rule
    public SlingContext context = new SlingContext();

    @org.junit.Before
    public void setup() {
        context.create().resource("/content/page", ResourceResolver.PROPERTY_RESOURCE_TYPE, "page");
        context.create().resource("/content/page/one", ResourceResolver.PROPERTY_RESOURCE_TYPE, "one");
        context.create().resource("/content/page/two", ResourceResolver.PROPERTY_RESOURCE_TYPE, "two");
        context.create().resource("/etc", ResourceResolver.PROPERTY_RESOURCE_TYPE, "etc");
        context.create().resource("/etc/tags", ResourceResolver.PROPERTY_RESOURCE_TYPE, "tags");

        for (int i = 0; i < 1085; i++) {
            context.create().resource("/etc/tags/" + i, ResourceResolver.PROPERTY_RESOURCE_TYPE, "" + i);
        }
    }

    @org.junit.Test
    public void test() throws Throwable {
        String response = getJSON("/content/page", "0");
        assertEquals("{\"sling:resourceType\":\"page\"}", response);

        response = getJSON("/content/page", "1");
        assertEquals(
                "{\"sling:resourceType\":\"page\",\"one\":{\"sling:resourceType\":\"one\"},\"two\":{\"sling:resourceType\":\"two\"}}",
                response);

        response = getJSON("/content/page", "infinity");
        assertEquals(
                "{\"sling:resourceType\":\"page\",\"one\":{\"sling:resourceType\":\"one\"},\"two\":{\"sling:resourceType\":\"two\"}}",
                response);

        response = getJSON("/content/page/one", "infinity");
        assertEquals("{\"sling:resourceType\":\"one\"}", response);

        response = getJSON("/etc", "infinity");
        assertEquals("[\"/etc.1.json\",\"/etc.0.json\"]", response);

        response = getJSON("/etc/tags", "1");
        assertEquals(
                "{\"sling:resourceType\":\"tags\",\"0\":{\"sling:resourceType\":\"0\"},\"1\":{\"sling:resourceType\":\"1\"},\"2\":{\"sling:resourceType\":\"2\"},\"3\":{\"sling:resourceType\":\"3\"},\"4\":{\"sling:resourceType\":\"4\"},\"5\":{\"sling:resourceType\":\"5\"},\"6\":{\"sling:resourceType\":\"6\"},\"7\":{\"sling:resourceType\":\"7\"},\"8\":{\"sling:resourceType\":\"8\"},\"9\":{\"sling:resourceType\":\"9\"},\"10\":{\"sling:resourceType\":\"10\"},\"11\":{\"sling:resourceType\":\"11\"},\"12\":{\"sling:resourceType\":\"12\"},\"13\":{\"sling:resourceType\":\"13\"},\"14\":{\"sling:resourceType\":\"14\"},\"15\":{\"sling:resourceType\":\"15\"},\"16\":{\"sling:resourceType\":\"16\"},\"17\":{\"sling:resourceType\":\"17\"},\"18\":{\"sling:resourceType\":\"18\"},\"19\":{\"sling:resourceType\":\"19\"},\"20\":{\"sling:resourceType\":\"20\"},\"21\":{\"sling:resourceType\":\"21\"},\"22\":{\"sling:resourceType\":\"22\"},\"23\":{\"sling:resourceType\":\"23\"},\"24\":{\"sling:resourceType\":\"24\"},\"25\":{\"sling:resourceType\":\"25\"},\"26\":{\"sling:resourceType\":\"26\"},\"27\":{\"sling:resourceType\":\"27\"},\"28\":{\"sling:resourceType\":\"28\"},\"29\":{\"sling:resourceType\":\"29\"},\"30\":{\"sling:resourceType\":\"30\"},\"31\":{\"sling:resourceType\":\"31\"},\"32\":{\"sling:resourceType\":\"32\"},\"33\":{\"sling:resourceType\":\"33\"},\"34\":{\"sling:resourceType\":\"34\"},\"35\":{\"sling:resourceType\":\"35\"},\"36\":{\"sling:resourceType\":\"36\"},\"37\":{\"sling:resourceType\":\"37\"},\"38\":{\"sling:resourceType\":\"38\"},\"39\":{\"sling:resourceType\":\"39\"},\"40\":{\"sling:resourceType\":\"40\"},\"41\":{\"sling:resourceType\":\"41\"},\"42\":{\"sling:resourceType\":\"42\"},\"43\":{\"sling:resourceType\":\"43\"},\"44\":{\"sling:resourceType\":\"44\"},\"45\":{\"sling:resourceType\":\"45\"},\"46\":{\"sling:resourceType\":\"46\"},\"47\":{\"sling:resourceType\":\"47\"},\"48\":{\"sling:resourceType\":\"48\"},\"49\":{\"sling:resourceType\":\"49\"},\"50\":{\"sling:resourceType\":\"50\"},\"51\":{\"sling:resourceType\":\"51\"},\"52\":{\"sling:resourceType\":\"52\"},\"53\":{\"sling:resourceType\":\"53\"},\"54\":{\"sling:resourceType\":\"54\"},\"55\":{\"sling:resourceType\":\"55\"},\"56\":{\"sling:resourceType\":\"56\"},\"57\":{\"sling:resourceType\":\"57\"},\"58\":{\"sling:resourceType\":\"58\"},\"59\":{\"sling:resourceType\":\"59\"},\"60\":{\"sling:resourceType\":\"60\"},\"61\":{\"sling:resourceType\":\"61\"},\"62\":{\"sling:resourceType\":\"62\"},\"63\":{\"sling:resourceType\":\"63\"},\"64\":{\"sling:resourceType\":\"64\"},\"65\":{\"sling:resourceType\":\"65\"},\"66\":{\"sling:resourceType\":\"66\"},\"67\":{\"sling:resourceType\":\"67\"},\"68\":{\"sling:resourceType\":\"68\"},\"69\":{\"sling:resourceType\":\"69\"},\"70\":{\"sling:resourceType\":\"70\"},\"71\":{\"sling:resourceType\":\"71\"},\"72\":{\"sling:resourceType\":\"72\"},\"73\":{\"sling:resourceType\":\"73\"},\"74\":{\"sling:resourceType\":\"74\"},\"75\":{\"sling:resourceType\":\"75\"},\"76\":{\"sling:resourceType\":\"76\"},\"77\":{\"sling:resourceType\":\"77\"},\"78\":{\"sling:resourceType\":\"78\"},\"79\":{\"sling:resourceType\":\"79\"},\"80\":{\"sling:resourceType\":\"80\"},\"81\":{\"sling:resourceType\":\"81\"},\"82\":{\"sling:resourceType\":\"82\"},\"83\":{\"sling:resourceType\":\"83\"},\"84\":{\"sling:resourceType\":\"84\"},\"85\":{\"sling:resourceType\":\"85\"},\"86\":{\"sling:resourceType\":\"86\"},\"87\":{\"sling:resourceType\":\"87\"},\"88\":{\"sling:resourceType\":\"88\"},\"89\":{\"sling:resourceType\":\"89\"},\"90\":{\"sling:resourceType\":\"90\"},\"91\":{\"sling:resourceType\":\"91\"},\"92\":{\"sling:resourceType\":\"92\"},\"93\":{\"sling:resourceType\":\"93\"},\"94\":{\"sling:resourceType\":\"94\"},\"95\":{\"sling:resourceType\":\"95\"},\"96\":{\"sling:resourceType\":\"96\"},\"97\":{\"sling:resourceType\":\"97\"},\"98\":{\"sling:resourceType\":\"98\"},\"99\":{\"sling:resourceType\":\"99\"},\"100\":{\"sling:resourceType\":\"100\"},\"101\":{\"sling:resourceType\":\"101\"},\"102\":{\"sling:resourceType\":\"102\"},\"103\":{\"sling:resourceType\":\"103\"},\"104\":{\"sling:resourceType\":\"104\"},\"105\":{\"sling:resourceType\":\"105\"},\"106\":{\"sling:resourceType\":\"106\"},\"107\":{\"sling:resourceType\":\"107\"},\"108\":{\"sling:resourceType\":\"108\"},\"109\":{\"sling:resourceType\":\"109\"},\"110\":{\"sling:resourceType\":\"110\"},\"111\":{\"sling:resourceType\":\"111\"},\"112\":{\"sling:resourceType\":\"112\"},\"113\":{\"sling:resourceType\":\"113\"},\"114\":{\"sling:resourceType\":\"114\"},\"115\":{\"sling:resourceType\":\"115\"},\"116\":{\"sling:resourceType\":\"116\"},\"117\":{\"sling:resourceType\":\"117\"},\"118\":{\"sling:resourceType\":\"118\"},\"119\":{\"sling:resourceType\":\"119\"},\"120\":{\"sling:resourceType\":\"120\"},\"121\":{\"sling:resourceType\":\"121\"},\"122\":{\"sling:resourceType\":\"122\"},\"123\":{\"sling:resourceType\":\"123\"},\"124\":{\"sling:resourceType\":\"124\"},\"125\":{\"sling:resourceType\":\"125\"},\"126\":{\"sling:resourceType\":\"126\"},\"127\":{\"sling:resourceType\":\"127\"},\"128\":{\"sling:resourceType\":\"128\"},\"129\":{\"sling:resourceType\":\"129\"},\"130\":{\"sling:resourceType\":\"130\"},\"131\":{\"sling:resourceType\":\"131\"},\"132\":{\"sling:resourceType\":\"132\"},\"133\":{\"sling:resourceType\":\"133\"},\"134\":{\"sling:resourceType\":\"134\"},\"135\":{\"sling:resourceType\":\"135\"},\"136\":{\"sling:resourceType\":\"136\"},\"137\":{\"sling:resourceType\":\"137\"},\"138\":{\"sling:resourceType\":\"138\"},\"139\":{\"sling:resourceType\":\"139\"},\"140\":{\"sling:resourceType\":\"140\"},\"141\":{\"sling:resourceType\":\"141\"},\"142\":{\"sling:resourceType\":\"142\"},\"143\":{\"sling:resourceType\":\"143\"},\"144\":{\"sling:resourceType\":\"144\"},\"145\":{\"sling:resourceType\":\"145\"},\"146\":{\"sling:resourceType\":\"146\"},\"147\":{\"sling:resourceType\":\"147\"},\"148\":{\"sling:resourceType\":\"148\"},\"149\":{\"sling:resourceType\":\"149\"},\"150\":{\"sling:resourceType\":\"150\"},\"151\":{\"sling:resourceType\":\"151\"},\"152\":{\"sling:resourceType\":\"152\"},\"153\":{\"sling:resourceType\":\"153\"},\"154\":{\"sling:resourceType\":\"154\"},\"155\":{\"sling:resourceType\":\"155\"},\"156\":{\"sling:resourceType\":\"156\"},\"157\":{\"sling:resourceType\":\"157\"},\"158\":{\"sling:resourceType\":\"158\"},\"159\":{\"sling:resourceType\":\"159\"},\"160\":{\"sling:resourceType\":\"160\"},\"161\":{\"sling:resourceType\":\"161\"},\"162\":{\"sling:resourceType\":\"162\"},\"163\":{\"sling:resourceType\":\"163\"},\"164\":{\"sling:resourceType\":\"164\"},\"165\":{\"sling:resourceType\":\"165\"},\"166\":{\"sling:resourceType\":\"166\"},\"167\":{\"sling:resourceType\":\"167\"},\"168\":{\"sling:resourceType\":\"168\"},\"169\":{\"sling:resourceType\":\"169\"},\"170\":{\"sling:resourceType\":\"170\"},\"171\":{\"sling:resourceType\":\"171\"},\"172\":{\"sling:resourceType\":\"172\"},\"173\":{\"sling:resourceType\":\"173\"},\"174\":{\"sling:resourceType\":\"174\"},\"175\":{\"sling:resourceType\":\"175\"},\"176\":{\"sling:resourceType\":\"176\"},\"177\":{\"sling:resourceType\":\"177\"},\"178\":{\"sling:resourceType\":\"178\"},\"179\":{\"sling:resourceType\":\"179\"},\"180\":{\"sling:resourceType\":\"180\"},\"181\":{\"sling:resourceType\":\"181\"},\"182\":{\"sling:resourceType\":\"182\"},\"183\":{\"sling:resourceType\":\"183\"},\"184\":{\"sling:resourceType\":\"184\"},\"185\":{\"sling:resourceType\":\"185\"},\"186\":{\"sling:resourceType\":\"186\"},\"187\":{\"sling:resourceType\":\"187\"},\"188\":{\"sling:resourceType\":\"188\"},\"189\":{\"sling:resourceType\":\"189\"},\"190\":{\"sling:resourceType\":\"190\"},\"191\":{\"sling:resourceType\":\"191\"},\"192\":{\"sling:resourceType\":\"192\"},\"193\":{\"sling:resourceType\":\"193\"},\"194\":{\"sling:resourceType\":\"194\"},\"195\":{\"sling:resourceType\":\"195\"},\"196\":{\"sling:resourceType\":\"196\"},\"197\":{\"sling:resourceType\":\"197\"},\"198\":{\"sling:resourceType\":\"198\"},\"199\":{\"sling:resourceType\":\"199\"},\"200\":{\"sling:resourceType\":\"200\"},\"201\":{\"sling:resourceType\":\"201\"},\"202\":{\"sling:resourceType\":\"202\"},\"203\":{\"sling:resourceType\":\"203\"},\"204\":{\"sling:resourceType\":\"204\"},\"205\":{\"sling:resourceType\":\"205\"},\"206\":{\"sling:resourceType\":\"206\"},\"207\":{\"sling:resourceType\":\"207\"},\"208\":{\"sling:resourceType\":\"208\"},\"209\":{\"sling:resourceType\":\"209\"},\"210\":{\"sling:resourceType\":\"210\"},\"211\":{\"sling:resourceType\":\"211\"},\"212\":{\"sling:resourceType\":\"212\"},\"213\":{\"sling:resourceType\":\"213\"},\"214\":{\"sling:resourceType\":\"214\"},\"215\":{\"sling:resourceType\":\"215\"},\"216\":{\"sling:resourceType\":\"216\"},\"217\":{\"sling:resourceType\":\"217\"},\"218\":{\"sling:resourceType\":\"218\"},\"219\":{\"sling:resourceType\":\"219\"},\"220\":{\"sling:resourceType\":\"220\"},\"221\":{\"sling:resourceType\":\"221\"},\"222\":{\"sling:resourceType\":\"222\"},\"223\":{\"sling:resourceType\":\"223\"},\"224\":{\"sling:resourceType\":\"224\"},\"225\":{\"sling:resourceType\":\"225\"},\"226\":{\"sling:resourceType\":\"226\"},\"227\":{\"sling:resourceType\":\"227\"},\"228\":{\"sling:resourceType\":\"228\"},\"229\":{\"sling:resourceType\":\"229\"},\"230\":{\"sling:resourceType\":\"230\"},\"231\":{\"sling:resourceType\":\"231\"},\"232\":{\"sling:resourceType\":\"232\"},\"233\":{\"sling:resourceType\":\"233\"},\"234\":{\"sling:resourceType\":\"234\"},\"235\":{\"sling:resourceType\":\"235\"},\"236\":{\"sling:resourceType\":\"236\"},\"237\":{\"sling:resourceType\":\"237\"},\"238\":{\"sling:resourceType\":\"238\"},\"239\":{\"sling:resourceType\":\"239\"},\"240\":{\"sling:resourceType\":\"240\"},\"241\":{\"sling:resourceType\":\"241\"},\"242\":{\"sling:resourceType\":\"242\"},\"243\":{\"sling:resourceType\":\"243\"},\"244\":{\"sling:resourceType\":\"244\"},\"245\":{\"sling:resourceType\":\"245\"},\"246\":{\"sling:resourceType\":\"246\"},\"247\":{\"sling:resourceType\":\"247\"},\"248\":{\"sling:resourceType\":\"248\"},\"249\":{\"sling:resourceType\":\"249\"},\"250\":{\"sling:resourceType\":\"250\"},\"251\":{\"sling:resourceType\":\"251\"},\"252\":{\"sling:resourceType\":\"252\"},\"253\":{\"sling:resourceType\":\"253\"},\"254\":{\"sling:resourceType\":\"254\"},\"255\":{\"sling:resourceType\":\"255\"},\"256\":{\"sling:resourceType\":\"256\"},\"257\":{\"sling:resourceType\":\"257\"},\"258\":{\"sling:resourceType\":\"258\"},\"259\":{\"sling:resourceType\":\"259\"},\"260\":{\"sling:resourceType\":\"260\"},\"261\":{\"sling:resourceType\":\"261\"},\"262\":{\"sling:resourceType\":\"262\"},\"263\":{\"sling:resourceType\":\"263\"},\"264\":{\"sling:resourceType\":\"264\"},\"265\":{\"sling:resourceType\":\"265\"},\"266\":{\"sling:resourceType\":\"266\"},\"267\":{\"sling:resourceType\":\"267\"},\"268\":{\"sling:resourceType\":\"268\"},\"269\":{\"sling:resourceType\":\"269\"},\"270\":{\"sling:resourceType\":\"270\"},\"271\":{\"sling:resourceType\":\"271\"},\"272\":{\"sling:resourceType\":\"272\"},\"273\":{\"sling:resourceType\":\"273\"},\"274\":{\"sling:resourceType\":\"274\"},\"275\":{\"sling:resourceType\":\"275\"},\"276\":{\"sling:resourceType\":\"276\"},\"277\":{\"sling:resourceType\":\"277\"},\"278\":{\"sling:resourceType\":\"278\"},\"279\":{\"sling:resourceType\":\"279\"},\"280\":{\"sling:resourceType\":\"280\"},\"281\":{\"sling:resourceType\":\"281\"},\"282\":{\"sling:resourceType\":\"282\"},\"283\":{\"sling:resourceType\":\"283\"},\"284\":{\"sling:resourceType\":\"284\"},\"285\":{\"sling:resourceType\":\"285\"},\"286\":{\"sling:resourceType\":\"286\"},\"287\":{\"sling:resourceType\":\"287\"},\"288\":{\"sling:resourceType\":\"288\"},\"289\":{\"sling:resourceType\":\"289\"},\"290\":{\"sling:resourceType\":\"290\"},\"291\":{\"sling:resourceType\":\"291\"},\"292\":{\"sling:resourceType\":\"292\"},\"293\":{\"sling:resourceType\":\"293\"},\"294\":{\"sling:resourceType\":\"294\"},\"295\":{\"sling:resourceType\":\"295\"},\"296\":{\"sling:resourceType\":\"296\"},\"297\":{\"sling:resourceType\":\"297\"},\"298\":{\"sling:resourceType\":\"298\"},\"299\":{\"sling:resourceType\":\"299\"},\"300\":{\"sling:resourceType\":\"300\"},\"301\":{\"sling:resourceType\":\"301\"},\"302\":{\"sling:resourceType\":\"302\"},\"303\":{\"sling:resourceType\":\"303\"},\"304\":{\"sling:resourceType\":\"304\"},\"305\":{\"sling:resourceType\":\"305\"},\"306\":{\"sling:resourceType\":\"306\"},\"307\":{\"sling:resourceType\":\"307\"},\"308\":{\"sling:resourceType\":\"308\"},\"309\":{\"sling:resourceType\":\"309\"},\"310\":{\"sling:resourceType\":\"310\"},\"311\":{\"sling:resourceType\":\"311\"},\"312\":{\"sling:resourceType\":\"312\"},\"313\":{\"sling:resourceType\":\"313\"},\"314\":{\"sling:resourceType\":\"314\"},\"315\":{\"sling:resourceType\":\"315\"},\"316\":{\"sling:resourceType\":\"316\"},\"317\":{\"sling:resourceType\":\"317\"},\"318\":{\"sling:resourceType\":\"318\"},\"319\":{\"sling:resourceType\":\"319\"},\"320\":{\"sling:resourceType\":\"320\"},\"321\":{\"sling:resourceType\":\"321\"},\"322\":{\"sling:resourceType\":\"322\"},\"323\":{\"sling:resourceType\":\"323\"},\"324\":{\"sling:resourceType\":\"324\"},\"325\":{\"sling:resourceType\":\"325\"},\"326\":{\"sling:resourceType\":\"326\"},\"327\":{\"sling:resourceType\":\"327\"},\"328\":{\"sling:resourceType\":\"328\"},\"329\":{\"sling:resourceType\":\"329\"},\"330\":{\"sling:resourceType\":\"330\"},\"331\":{\"sling:resourceType\":\"331\"},\"332\":{\"sling:resourceType\":\"332\"},\"333\":{\"sling:resourceType\":\"333\"},\"334\":{\"sling:resourceType\":\"334\"},\"335\":{\"sling:resourceType\":\"335\"},\"336\":{\"sling:resourceType\":\"336\"},\"337\":{\"sling:resourceType\":\"337\"},\"338\":{\"sling:resourceType\":\"338\"},\"339\":{\"sling:resourceType\":\"339\"},\"340\":{\"sling:resourceType\":\"340\"},\"341\":{\"sling:resourceType\":\"341\"},\"342\":{\"sling:resourceType\":\"342\"},\"343\":{\"sling:resourceType\":\"343\"},\"344\":{\"sling:resourceType\":\"344\"},\"345\":{\"sling:resourceType\":\"345\"},\"346\":{\"sling:resourceType\":\"346\"},\"347\":{\"sling:resourceType\":\"347\"},\"348\":{\"sling:resourceType\":\"348\"},\"349\":{\"sling:resourceType\":\"349\"},\"350\":{\"sling:resourceType\":\"350\"},\"351\":{\"sling:resourceType\":\"351\"},\"352\":{\"sling:resourceType\":\"352\"},\"353\":{\"sling:resourceType\":\"353\"},\"354\":{\"sling:resourceType\":\"354\"},\"355\":{\"sling:resourceType\":\"355\"},\"356\":{\"sling:resourceType\":\"356\"},\"357\":{\"sling:resourceType\":\"357\"},\"358\":{\"sling:resourceType\":\"358\"},\"359\":{\"sling:resourceType\":\"359\"},\"360\":{\"sling:resourceType\":\"360\"},\"361\":{\"sling:resourceType\":\"361\"},\"362\":{\"sling:resourceType\":\"362\"},\"363\":{\"sling:resourceType\":\"363\"},\"364\":{\"sling:resourceType\":\"364\"},\"365\":{\"sling:resourceType\":\"365\"},\"366\":{\"sling:resourceType\":\"366\"},\"367\":{\"sling:resourceType\":\"367\"},\"368\":{\"sling:resourceType\":\"368\"},\"369\":{\"sling:resourceType\":\"369\"},\"370\":{\"sling:resourceType\":\"370\"},\"371\":{\"sling:resourceType\":\"371\"},\"372\":{\"sling:resourceType\":\"372\"},\"373\":{\"sling:resourceType\":\"373\"},\"374\":{\"sling:resourceType\":\"374\"},\"375\":{\"sling:resourceType\":\"375\"},\"376\":{\"sling:resourceType\":\"376\"},\"377\":{\"sling:resourceType\":\"377\"},\"378\":{\"sling:resourceType\":\"378\"},\"379\":{\"sling:resourceType\":\"379\"},\"380\":{\"sling:resourceType\":\"380\"},\"381\":{\"sling:resourceType\":\"381\"},\"382\":{\"sling:resourceType\":\"382\"},\"383\":{\"sling:resourceType\":\"383\"},\"384\":{\"sling:resourceType\":\"384\"},\"385\":{\"sling:resourceType\":\"385\"},\"386\":{\"sling:resourceType\":\"386\"},\"387\":{\"sling:resourceType\":\"387\"},\"388\":{\"sling:resourceType\":\"388\"},\"389\":{\"sling:resourceType\":\"389\"},\"390\":{\"sling:resourceType\":\"390\"},\"391\":{\"sling:resourceType\":\"391\"},\"392\":{\"sling:resourceType\":\"392\"},\"393\":{\"sling:resourceType\":\"393\"},\"394\":{\"sling:resourceType\":\"394\"},\"395\":{\"sling:resourceType\":\"395\"},\"396\":{\"sling:resourceType\":\"396\"},\"397\":{\"sling:resourceType\":\"397\"},\"398\":{\"sling:resourceType\":\"398\"},\"399\":{\"sling:resourceType\":\"399\"},\"400\":{\"sling:resourceType\":\"400\"},\"401\":{\"sling:resourceType\":\"401\"},\"402\":{\"sling:resourceType\":\"402\"},\"403\":{\"sling:resourceType\":\"403\"},\"404\":{\"sling:resourceType\":\"404\"},\"405\":{\"sling:resourceType\":\"405\"},\"406\":{\"sling:resourceType\":\"406\"},\"407\":{\"sling:resourceType\":\"407\"},\"408\":{\"sling:resourceType\":\"408\"},\"409\":{\"sling:resourceType\":\"409\"},\"410\":{\"sling:resourceType\":\"410\"},\"411\":{\"sling:resourceType\":\"411\"},\"412\":{\"sling:resourceType\":\"412\"},\"413\":{\"sling:resourceType\":\"413\"},\"414\":{\"sling:resourceType\":\"414\"},\"415\":{\"sling:resourceType\":\"415\"},\"416\":{\"sling:resourceType\":\"416\"},\"417\":{\"sling:resourceType\":\"417\"},\"418\":{\"sling:resourceType\":\"418\"},\"419\":{\"sling:resourceType\":\"419\"},\"420\":{\"sling:resourceType\":\"420\"},\"421\":{\"sling:resourceType\":\"421\"},\"422\":{\"sling:resourceType\":\"422\"},\"423\":{\"sling:resourceType\":\"423\"},\"424\":{\"sling:resourceType\":\"424\"},\"425\":{\"sling:resourceType\":\"425\"},\"426\":{\"sling:resourceType\":\"426\"},\"427\":{\"sling:resourceType\":\"427\"},\"428\":{\"sling:resourceType\":\"428\"},\"429\":{\"sling:resourceType\":\"429\"},\"430\":{\"sling:resourceType\":\"430\"},\"431\":{\"sling:resourceType\":\"431\"},\"432\":{\"sling:resourceType\":\"432\"},\"433\":{\"sling:resourceType\":\"433\"},\"434\":{\"sling:resourceType\":\"434\"},\"435\":{\"sling:resourceType\":\"435\"},\"436\":{\"sling:resourceType\":\"436\"},\"437\":{\"sling:resourceType\":\"437\"},\"438\":{\"sling:resourceType\":\"438\"},\"439\":{\"sling:resourceType\":\"439\"},\"440\":{\"sling:resourceType\":\"440\"},\"441\":{\"sling:resourceType\":\"441\"},\"442\":{\"sling:resourceType\":\"442\"},\"443\":{\"sling:resourceType\":\"443\"},\"444\":{\"sling:resourceType\":\"444\"},\"445\":{\"sling:resourceType\":\"445\"},\"446\":{\"sling:resourceType\":\"446\"},\"447\":{\"sling:resourceType\":\"447\"},\"448\":{\"sling:resourceType\":\"448\"},\"449\":{\"sling:resourceType\":\"449\"},\"450\":{\"sling:resourceType\":\"450\"},\"451\":{\"sling:resourceType\":\"451\"},\"452\":{\"sling:resourceType\":\"452\"},\"453\":{\"sling:resourceType\":\"453\"},\"454\":{\"sling:resourceType\":\"454\"},\"455\":{\"sling:resourceType\":\"455\"},\"456\":{\"sling:resourceType\":\"456\"},\"457\":{\"sling:resourceType\":\"457\"},\"458\":{\"sling:resourceType\":\"458\"},\"459\":{\"sling:resourceType\":\"459\"},\"460\":{\"sling:resourceType\":\"460\"},\"461\":{\"sling:resourceType\":\"461\"},\"462\":{\"sling:resourceType\":\"462\"},\"463\":{\"sling:resourceType\":\"463\"},\"464\":{\"sling:resourceType\":\"464\"},\"465\":{\"sling:resourceType\":\"465\"},\"466\":{\"sling:resourceType\":\"466\"},\"467\":{\"sling:resourceType\":\"467\"},\"468\":{\"sling:resourceType\":\"468\"},\"469\":{\"sling:resourceType\":\"469\"},\"470\":{\"sling:resourceType\":\"470\"},\"471\":{\"sling:resourceType\":\"471\"},\"472\":{\"sling:resourceType\":\"472\"},\"473\":{\"sling:resourceType\":\"473\"},\"474\":{\"sling:resourceType\":\"474\"},\"475\":{\"sling:resourceType\":\"475\"},\"476\":{\"sling:resourceType\":\"476\"},\"477\":{\"sling:resourceType\":\"477\"},\"478\":{\"sling:resourceType\":\"478\"},\"479\":{\"sling:resourceType\":\"479\"},\"480\":{\"sling:resourceType\":\"480\"},\"481\":{\"sling:resourceType\":\"481\"},\"482\":{\"sling:resourceType\":\"482\"},\"483\":{\"sling:resourceType\":\"483\"},\"484\":{\"sling:resourceType\":\"484\"},\"485\":{\"sling:resourceType\":\"485\"},\"486\":{\"sling:resourceType\":\"486\"},\"487\":{\"sling:resourceType\":\"487\"},\"488\":{\"sling:resourceType\":\"488\"},\"489\":{\"sling:resourceType\":\"489\"},\"490\":{\"sling:resourceType\":\"490\"},\"491\":{\"sling:resourceType\":\"491\"},\"492\":{\"sling:resourceType\":\"492\"},\"493\":{\"sling:resourceType\":\"493\"},\"494\":{\"sling:resourceType\":\"494\"},\"495\":{\"sling:resourceType\":\"495\"},\"496\":{\"sling:resourceType\":\"496\"},\"497\":{\"sling:resourceType\":\"497\"},\"498\":{\"sling:resourceType\":\"498\"},\"499\":{\"sling:resourceType\":\"499\"},\"500\":{\"sling:resourceType\":\"500\"},\"501\":{\"sling:resourceType\":\"501\"},\"502\":{\"sling:resourceType\":\"502\"},\"503\":{\"sling:resourceType\":\"503\"},\"504\":{\"sling:resourceType\":\"504\"},\"505\":{\"sling:resourceType\":\"505\"},\"506\":{\"sling:resourceType\":\"506\"},\"507\":{\"sling:resourceType\":\"507\"},\"508\":{\"sling:resourceType\":\"508\"},\"509\":{\"sling:resourceType\":\"509\"},\"510\":{\"sling:resourceType\":\"510\"},\"511\":{\"sling:resourceType\":\"511\"},\"512\":{\"sling:resourceType\":\"512\"},\"513\":{\"sling:resourceType\":\"513\"},\"514\":{\"sling:resourceType\":\"514\"},\"515\":{\"sling:resourceType\":\"515\"},\"516\":{\"sling:resourceType\":\"516\"},\"517\":{\"sling:resourceType\":\"517\"},\"518\":{\"sling:resourceType\":\"518\"},\"519\":{\"sling:resourceType\":\"519\"},\"520\":{\"sling:resourceType\":\"520\"},\"521\":{\"sling:resourceType\":\"521\"},\"522\":{\"sling:resourceType\":\"522\"},\"523\":{\"sling:resourceType\":\"523\"},\"524\":{\"sling:resourceType\":\"524\"},\"525\":{\"sling:resourceType\":\"525\"},\"526\":{\"sling:resourceType\":\"526\"},\"527\":{\"sling:resourceType\":\"527\"},\"528\":{\"sling:resourceType\":\"528\"},\"529\":{\"sling:resourceType\":\"529\"},\"530\":{\"sling:resourceType\":\"530\"},\"531\":{\"sling:resourceType\":\"531\"},\"532\":{\"sling:resourceType\":\"532\"},\"533\":{\"sling:resourceType\":\"533\"},\"534\":{\"sling:resourceType\":\"534\"},\"535\":{\"sling:resourceType\":\"535\"},\"536\":{\"sling:resourceType\":\"536\"},\"537\":{\"sling:resourceType\":\"537\"},\"538\":{\"sling:resourceType\":\"538\"},\"539\":{\"sling:resourceType\":\"539\"},\"540\":{\"sling:resourceType\":\"540\"},\"541\":{\"sling:resourceType\":\"541\"},\"542\":{\"sling:resourceType\":\"542\"},\"543\":{\"sling:resourceType\":\"543\"},\"544\":{\"sling:resourceType\":\"544\"},\"545\":{\"sling:resourceType\":\"545\"},\"546\":{\"sling:resourceType\":\"546\"},\"547\":{\"sling:resourceType\":\"547\"},\"548\":{\"sling:resourceType\":\"548\"},\"549\":{\"sling:resourceType\":\"549\"},\"550\":{\"sling:resourceType\":\"550\"},\"551\":{\"sling:resourceType\":\"551\"},\"552\":{\"sling:resourceType\":\"552\"},\"553\":{\"sling:resourceType\":\"553\"},\"554\":{\"sling:resourceType\":\"554\"},\"555\":{\"sling:resourceType\":\"555\"},\"556\":{\"sling:resourceType\":\"556\"},\"557\":{\"sling:resourceType\":\"557\"},\"558\":{\"sling:resourceType\":\"558\"},\"559\":{\"sling:resourceType\":\"559\"},\"560\":{\"sling:resourceType\":\"560\"},\"561\":{\"sling:resourceType\":\"561\"},\"562\":{\"sling:resourceType\":\"562\"},\"563\":{\"sling:resourceType\":\"563\"},\"564\":{\"sling:resourceType\":\"564\"},\"565\":{\"sling:resourceType\":\"565\"},\"566\":{\"sling:resourceType\":\"566\"},\"567\":{\"sling:resourceType\":\"567\"},\"568\":{\"sling:resourceType\":\"568\"},\"569\":{\"sling:resourceType\":\"569\"},\"570\":{\"sling:resourceType\":\"570\"},\"571\":{\"sling:resourceType\":\"571\"},\"572\":{\"sling:resourceType\":\"572\"},\"573\":{\"sling:resourceType\":\"573\"},\"574\":{\"sling:resourceType\":\"574\"},\"575\":{\"sling:resourceType\":\"575\"},\"576\":{\"sling:resourceType\":\"576\"},\"577\":{\"sling:resourceType\":\"577\"},\"578\":{\"sling:resourceType\":\"578\"},\"579\":{\"sling:resourceType\":\"579\"},\"580\":{\"sling:resourceType\":\"580\"},\"581\":{\"sling:resourceType\":\"581\"},\"582\":{\"sling:resourceType\":\"582\"},\"583\":{\"sling:resourceType\":\"583\"},\"584\":{\"sling:resourceType\":\"584\"},\"585\":{\"sling:resourceType\":\"585\"},\"586\":{\"sling:resourceType\":\"586\"},\"587\":{\"sling:resourceType\":\"587\"},\"588\":{\"sling:resourceType\":\"588\"},\"589\":{\"sling:resourceType\":\"589\"},\"590\":{\"sling:resourceType\":\"590\"},\"591\":{\"sling:resourceType\":\"591\"},\"592\":{\"sling:resourceType\":\"592\"},\"593\":{\"sling:resourceType\":\"593\"},\"594\":{\"sling:resourceType\":\"594\"},\"595\":{\"sling:resourceType\":\"595\"},\"596\":{\"sling:resourceType\":\"596\"},\"597\":{\"sling:resourceType\":\"597\"},\"598\":{\"sling:resourceType\":\"598\"},\"599\":{\"sling:resourceType\":\"599\"},\"600\":{\"sling:resourceType\":\"600\"},\"601\":{\"sling:resourceType\":\"601\"},\"602\":{\"sling:resourceType\":\"602\"},\"603\":{\"sling:resourceType\":\"603\"},\"604\":{\"sling:resourceType\":\"604\"},\"605\":{\"sling:resourceType\":\"605\"},\"606\":{\"sling:resourceType\":\"606\"},\"607\":{\"sling:resourceType\":\"607\"},\"608\":{\"sling:resourceType\":\"608\"},\"609\":{\"sling:resourceType\":\"609\"},\"610\":{\"sling:resourceType\":\"610\"},\"611\":{\"sling:resourceType\":\"611\"},\"612\":{\"sling:resourceType\":\"612\"},\"613\":{\"sling:resourceType\":\"613\"},\"614\":{\"sling:resourceType\":\"614\"},\"615\":{\"sling:resourceType\":\"615\"},\"616\":{\"sling:resourceType\":\"616\"},\"617\":{\"sling:resourceType\":\"617\"},\"618\":{\"sling:resourceType\":\"618\"},\"619\":{\"sling:resourceType\":\"619\"},\"620\":{\"sling:resourceType\":\"620\"},\"621\":{\"sling:resourceType\":\"621\"},\"622\":{\"sling:resourceType\":\"622\"},\"623\":{\"sling:resourceType\":\"623\"},\"624\":{\"sling:resourceType\":\"624\"},\"625\":{\"sling:resourceType\":\"625\"},\"626\":{\"sling:resourceType\":\"626\"},\"627\":{\"sling:resourceType\":\"627\"},\"628\":{\"sling:resourceType\":\"628\"},\"629\":{\"sling:resourceType\":\"629\"},\"630\":{\"sling:resourceType\":\"630\"},\"631\":{\"sling:resourceType\":\"631\"},\"632\":{\"sling:resourceType\":\"632\"},\"633\":{\"sling:resourceType\":\"633\"},\"634\":{\"sling:resourceType\":\"634\"},\"635\":{\"sling:resourceType\":\"635\"},\"636\":{\"sling:resourceType\":\"636\"},\"637\":{\"sling:resourceType\":\"637\"},\"638\":{\"sling:resourceType\":\"638\"},\"639\":{\"sling:resourceType\":\"639\"},\"640\":{\"sling:resourceType\":\"640\"},\"641\":{\"sling:resourceType\":\"641\"},\"642\":{\"sling:resourceType\":\"642\"},\"643\":{\"sling:resourceType\":\"643\"},\"644\":{\"sling:resourceType\":\"644\"},\"645\":{\"sling:resourceType\":\"645\"},\"646\":{\"sling:resourceType\":\"646\"},\"647\":{\"sling:resourceType\":\"647\"},\"648\":{\"sling:resourceType\":\"648\"},\"649\":{\"sling:resourceType\":\"649\"},\"650\":{\"sling:resourceType\":\"650\"},\"651\":{\"sling:resourceType\":\"651\"},\"652\":{\"sling:resourceType\":\"652\"},\"653\":{\"sling:resourceType\":\"653\"},\"654\":{\"sling:resourceType\":\"654\"},\"655\":{\"sling:resourceType\":\"655\"},\"656\":{\"sling:resourceType\":\"656\"},\"657\":{\"sling:resourceType\":\"657\"},\"658\":{\"sling:resourceType\":\"658\"},\"659\":{\"sling:resourceType\":\"659\"},\"660\":{\"sling:resourceType\":\"660\"},\"661\":{\"sling:resourceType\":\"661\"},\"662\":{\"sling:resourceType\":\"662\"},\"663\":{\"sling:resourceType\":\"663\"},\"664\":{\"sling:resourceType\":\"664\"},\"665\":{\"sling:resourceType\":\"665\"},\"666\":{\"sling:resourceType\":\"666\"},\"667\":{\"sling:resourceType\":\"667\"},\"668\":{\"sling:resourceType\":\"668\"},\"669\":{\"sling:resourceType\":\"669\"},\"670\":{\"sling:resourceType\":\"670\"},\"671\":{\"sling:resourceType\":\"671\"},\"672\":{\"sling:resourceType\":\"672\"},\"673\":{\"sling:resourceType\":\"673\"},\"674\":{\"sling:resourceType\":\"674\"},\"675\":{\"sling:resourceType\":\"675\"},\"676\":{\"sling:resourceType\":\"676\"},\"677\":{\"sling:resourceType\":\"677\"},\"678\":{\"sling:resourceType\":\"678\"},\"679\":{\"sling:resourceType\":\"679\"},\"680\":{\"sling:resourceType\":\"680\"},\"681\":{\"sling:resourceType\":\"681\"},\"682\":{\"sling:resourceType\":\"682\"},\"683\":{\"sling:resourceType\":\"683\"},\"684\":{\"sling:resourceType\":\"684\"},\"685\":{\"sling:resourceType\":\"685\"},\"686\":{\"sling:resourceType\":\"686\"},\"687\":{\"sling:resourceType\":\"687\"},\"688\":{\"sling:resourceType\":\"688\"},\"689\":{\"sling:resourceType\":\"689\"},\"690\":{\"sling:resourceType\":\"690\"},\"691\":{\"sling:resourceType\":\"691\"},\"692\":{\"sling:resourceType\":\"692\"},\"693\":{\"sling:resourceType\":\"693\"},\"694\":{\"sling:resourceType\":\"694\"},\"695\":{\"sling:resourceType\":\"695\"},\"696\":{\"sling:resourceType\":\"696\"},\"697\":{\"sling:resourceType\":\"697\"},\"698\":{\"sling:resourceType\":\"698\"},\"699\":{\"sling:resourceType\":\"699\"},\"700\":{\"sling:resourceType\":\"700\"},\"701\":{\"sling:resourceType\":\"701\"},\"702\":{\"sling:resourceType\":\"702\"},\"703\":{\"sling:resourceType\":\"703\"},\"704\":{\"sling:resourceType\":\"704\"},\"705\":{\"sling:resourceType\":\"705\"},\"706\":{\"sling:resourceType\":\"706\"},\"707\":{\"sling:resourceType\":\"707\"},\"708\":{\"sling:resourceType\":\"708\"},\"709\":{\"sling:resourceType\":\"709\"},\"710\":{\"sling:resourceType\":\"710\"},\"711\":{\"sling:resourceType\":\"711\"},\"712\":{\"sling:resourceType\":\"712\"},\"713\":{\"sling:resourceType\":\"713\"},\"714\":{\"sling:resourceType\":\"714\"},\"715\":{\"sling:resourceType\":\"715\"},\"716\":{\"sling:resourceType\":\"716\"},\"717\":{\"sling:resourceType\":\"717\"},\"718\":{\"sling:resourceType\":\"718\"},\"719\":{\"sling:resourceType\":\"719\"},\"720\":{\"sling:resourceType\":\"720\"},\"721\":{\"sling:resourceType\":\"721\"},\"722\":{\"sling:resourceType\":\"722\"},\"723\":{\"sling:resourceType\":\"723\"},\"724\":{\"sling:resourceType\":\"724\"},\"725\":{\"sling:resourceType\":\"725\"},\"726\":{\"sling:resourceType\":\"726\"},\"727\":{\"sling:resourceType\":\"727\"},\"728\":{\"sling:resourceType\":\"728\"},\"729\":{\"sling:resourceType\":\"729\"},\"730\":{\"sling:resourceType\":\"730\"},\"731\":{\"sling:resourceType\":\"731\"},\"732\":{\"sling:resourceType\":\"732\"},\"733\":{\"sling:resourceType\":\"733\"},\"734\":{\"sling:resourceType\":\"734\"},\"735\":{\"sling:resourceType\":\"735\"},\"736\":{\"sling:resourceType\":\"736\"},\"737\":{\"sling:resourceType\":\"737\"},\"738\":{\"sling:resourceType\":\"738\"},\"739\":{\"sling:resourceType\":\"739\"},\"740\":{\"sling:resourceType\":\"740\"},\"741\":{\"sling:resourceType\":\"741\"},\"742\":{\"sling:resourceType\":\"742\"},\"743\":{\"sling:resourceType\":\"743\"},\"744\":{\"sling:resourceType\":\"744\"},\"745\":{\"sling:resourceType\":\"745\"},\"746\":{\"sling:resourceType\":\"746\"},\"747\":{\"sling:resourceType\":\"747\"},\"748\":{\"sling:resourceType\":\"748\"},\"749\":{\"sling:resourceType\":\"749\"},\"750\":{\"sling:resourceType\":\"750\"},\"751\":{\"sling:resourceType\":\"751\"},\"752\":{\"sling:resourceType\":\"752\"},\"753\":{\"sling:resourceType\":\"753\"},\"754\":{\"sling:resourceType\":\"754\"},\"755\":{\"sling:resourceType\":\"755\"},\"756\":{\"sling:resourceType\":\"756\"},\"757\":{\"sling:resourceType\":\"757\"},\"758\":{\"sling:resourceType\":\"758\"},\"759\":{\"sling:resourceType\":\"759\"},\"760\":{\"sling:resourceType\":\"760\"},\"761\":{\"sling:resourceType\":\"761\"},\"762\":{\"sling:resourceType\":\"762\"},\"763\":{\"sling:resourceType\":\"763\"},\"764\":{\"sling:resourceType\":\"764\"},\"765\":{\"sling:resourceType\":\"765\"},\"766\":{\"sling:resourceType\":\"766\"},\"767\":{\"sling:resourceType\":\"767\"},\"768\":{\"sling:resourceType\":\"768\"},\"769\":{\"sling:resourceType\":\"769\"},\"770\":{\"sling:resourceType\":\"770\"},\"771\":{\"sling:resourceType\":\"771\"},\"772\":{\"sling:resourceType\":\"772\"},\"773\":{\"sling:resourceType\":\"773\"},\"774\":{\"sling:resourceType\":\"774\"},\"775\":{\"sling:resourceType\":\"775\"},\"776\":{\"sling:resourceType\":\"776\"},\"777\":{\"sling:resourceType\":\"777\"},\"778\":{\"sling:resourceType\":\"778\"},\"779\":{\"sling:resourceType\":\"779\"},\"780\":{\"sling:resourceType\":\"780\"},\"781\":{\"sling:resourceType\":\"781\"},\"782\":{\"sling:resourceType\":\"782\"},\"783\":{\"sling:resourceType\":\"783\"},\"784\":{\"sling:resourceType\":\"784\"},\"785\":{\"sling:resourceType\":\"785\"},\"786\":{\"sling:resourceType\":\"786\"},\"787\":{\"sling:resourceType\":\"787\"},\"788\":{\"sling:resourceType\":\"788\"},\"789\":{\"sling:resourceType\":\"789\"},\"790\":{\"sling:resourceType\":\"790\"},\"791\":{\"sling:resourceType\":\"791\"},\"792\":{\"sling:resourceType\":\"792\"},\"793\":{\"sling:resourceType\":\"793\"},\"794\":{\"sling:resourceType\":\"794\"},\"795\":{\"sling:resourceType\":\"795\"},\"796\":{\"sling:resourceType\":\"796\"},\"797\":{\"sling:resourceType\":\"797\"},\"798\":{\"sling:resourceType\":\"798\"},\"799\":{\"sling:resourceType\":\"799\"},\"800\":{\"sling:resourceType\":\"800\"},\"801\":{\"sling:resourceType\":\"801\"},\"802\":{\"sling:resourceType\":\"802\"},\"803\":{\"sling:resourceType\":\"803\"},\"804\":{\"sling:resourceType\":\"804\"},\"805\":{\"sling:resourceType\":\"805\"},\"806\":{\"sling:resourceType\":\"806\"},\"807\":{\"sling:resourceType\":\"807\"},\"808\":{\"sling:resourceType\":\"808\"},\"809\":{\"sling:resourceType\":\"809\"},\"810\":{\"sling:resourceType\":\"810\"},\"811\":{\"sling:resourceType\":\"811\"},\"812\":{\"sling:resourceType\":\"812\"},\"813\":{\"sling:resourceType\":\"813\"},\"814\":{\"sling:resourceType\":\"814\"},\"815\":{\"sling:resourceType\":\"815\"},\"816\":{\"sling:resourceType\":\"816\"},\"817\":{\"sling:resourceType\":\"817\"},\"818\":{\"sling:resourceType\":\"818\"},\"819\":{\"sling:resourceType\":\"819\"},\"820\":{\"sling:resourceType\":\"820\"},\"821\":{\"sling:resourceType\":\"821\"},\"822\":{\"sling:resourceType\":\"822\"},\"823\":{\"sling:resourceType\":\"823\"},\"824\":{\"sling:resourceType\":\"824\"},\"825\":{\"sling:resourceType\":\"825\"},\"826\":{\"sling:resourceType\":\"826\"},\"827\":{\"sling:resourceType\":\"827\"},\"828\":{\"sling:resourceType\":\"828\"},\"829\":{\"sling:resourceType\":\"829\"},\"830\":{\"sling:resourceType\":\"830\"},\"831\":{\"sling:resourceType\":\"831\"},\"832\":{\"sling:resourceType\":\"832\"},\"833\":{\"sling:resourceType\":\"833\"},\"834\":{\"sling:resourceType\":\"834\"},\"835\":{\"sling:resourceType\":\"835\"},\"836\":{\"sling:resourceType\":\"836\"},\"837\":{\"sling:resourceType\":\"837\"},\"838\":{\"sling:resourceType\":\"838\"},\"839\":{\"sling:resourceType\":\"839\"},\"840\":{\"sling:resourceType\":\"840\"},\"841\":{\"sling:resourceType\":\"841\"},\"842\":{\"sling:resourceType\":\"842\"},\"843\":{\"sling:resourceType\":\"843\"},\"844\":{\"sling:resourceType\":\"844\"},\"845\":{\"sling:resourceType\":\"845\"},\"846\":{\"sling:resourceType\":\"846\"},\"847\":{\"sling:resourceType\":\"847\"},\"848\":{\"sling:resourceType\":\"848\"},\"849\":{\"sling:resourceType\":\"849\"},\"850\":{\"sling:resourceType\":\"850\"},\"851\":{\"sling:resourceType\":\"851\"},\"852\":{\"sling:resourceType\":\"852\"},\"853\":{\"sling:resourceType\":\"853\"},\"854\":{\"sling:resourceType\":\"854\"},\"855\":{\"sling:resourceType\":\"855\"},\"856\":{\"sling:resourceType\":\"856\"},\"857\":{\"sling:resourceType\":\"857\"},\"858\":{\"sling:resourceType\":\"858\"},\"859\":{\"sling:resourceType\":\"859\"},\"860\":{\"sling:resourceType\":\"860\"},\"861\":{\"sling:resourceType\":\"861\"},\"862\":{\"sling:resourceType\":\"862\"},\"863\":{\"sling:resourceType\":\"863\"},\"864\":{\"sling:resourceType\":\"864\"},\"865\":{\"sling:resourceType\":\"865\"},\"866\":{\"sling:resourceType\":\"866\"},\"867\":{\"sling:resourceType\":\"867\"},\"868\":{\"sling:resourceType\":\"868\"},\"869\":{\"sling:resourceType\":\"869\"},\"870\":{\"sling:resourceType\":\"870\"},\"871\":{\"sling:resourceType\":\"871\"},\"872\":{\"sling:resourceType\":\"872\"},\"873\":{\"sling:resourceType\":\"873\"},\"874\":{\"sling:resourceType\":\"874\"},\"875\":{\"sling:resourceType\":\"875\"},\"876\":{\"sling:resourceType\":\"876\"},\"877\":{\"sling:resourceType\":\"877\"},\"878\":{\"sling:resourceType\":\"878\"},\"879\":{\"sling:resourceType\":\"879\"},\"880\":{\"sling:resourceType\":\"880\"},\"881\":{\"sling:resourceType\":\"881\"},\"882\":{\"sling:resourceType\":\"882\"},\"883\":{\"sling:resourceType\":\"883\"},\"884\":{\"sling:resourceType\":\"884\"},\"885\":{\"sling:resourceType\":\"885\"},\"886\":{\"sling:resourceType\":\"886\"},\"887\":{\"sling:resourceType\":\"887\"},\"888\":{\"sling:resourceType\":\"888\"},\"889\":{\"sling:resourceType\":\"889\"},\"890\":{\"sling:resourceType\":\"890\"},\"891\":{\"sling:resourceType\":\"891\"},\"892\":{\"sling:resourceType\":\"892\"},\"893\":{\"sling:resourceType\":\"893\"},\"894\":{\"sling:resourceType\":\"894\"},\"895\":{\"sling:resourceType\":\"895\"},\"896\":{\"sling:resourceType\":\"896\"},\"897\":{\"sling:resourceType\":\"897\"},\"898\":{\"sling:resourceType\":\"898\"},\"899\":{\"sling:resourceType\":\"899\"},\"900\":{\"sling:resourceType\":\"900\"},\"901\":{\"sling:resourceType\":\"901\"},\"902\":{\"sling:resourceType\":\"902\"},\"903\":{\"sling:resourceType\":\"903\"},\"904\":{\"sling:resourceType\":\"904\"},\"905\":{\"sling:resourceType\":\"905\"},\"906\":{\"sling:resourceType\":\"906\"},\"907\":{\"sling:resourceType\":\"907\"},\"908\":{\"sling:resourceType\":\"908\"},\"909\":{\"sling:resourceType\":\"909\"},\"910\":{\"sling:resourceType\":\"910\"},\"911\":{\"sling:resourceType\":\"911\"},\"912\":{\"sling:resourceType\":\"912\"},\"913\":{\"sling:resourceType\":\"913\"},\"914\":{\"sling:resourceType\":\"914\"},\"915\":{\"sling:resourceType\":\"915\"},\"916\":{\"sling:resourceType\":\"916\"},\"917\":{\"sling:resourceType\":\"917\"},\"918\":{\"sling:resourceType\":\"918\"},\"919\":{\"sling:resourceType\":\"919\"},\"920\":{\"sling:resourceType\":\"920\"},\"921\":{\"sling:resourceType\":\"921\"},\"922\":{\"sling:resourceType\":\"922\"},\"923\":{\"sling:resourceType\":\"923\"},\"924\":{\"sling:resourceType\":\"924\"},\"925\":{\"sling:resourceType\":\"925\"},\"926\":{\"sling:resourceType\":\"926\"},\"927\":{\"sling:resourceType\":\"927\"},\"928\":{\"sling:resourceType\":\"928\"},\"929\":{\"sling:resourceType\":\"929\"},\"930\":{\"sling:resourceType\":\"930\"},\"931\":{\"sling:resourceType\":\"931\"},\"932\":{\"sling:resourceType\":\"932\"},\"933\":{\"sling:resourceType\":\"933\"},\"934\":{\"sling:resourceType\":\"934\"},\"935\":{\"sling:resourceType\":\"935\"},\"936\":{\"sling:resourceType\":\"936\"},\"937\":{\"sling:resourceType\":\"937\"},\"938\":{\"sling:resourceType\":\"938\"},\"939\":{\"sling:resourceType\":\"939\"},\"940\":{\"sling:resourceType\":\"940\"},\"941\":{\"sling:resourceType\":\"941\"},\"942\":{\"sling:resourceType\":\"942\"},\"943\":{\"sling:resourceType\":\"943\"},\"944\":{\"sling:resourceType\":\"944\"},\"945\":{\"sling:resourceType\":\"945\"},\"946\":{\"sling:resourceType\":\"946\"},\"947\":{\"sling:resourceType\":\"947\"},\"948\":{\"sling:resourceType\":\"948\"},\"949\":{\"sling:resourceType\":\"949\"},\"950\":{\"sling:resourceType\":\"950\"},\"951\":{\"sling:resourceType\":\"951\"},\"952\":{\"sling:resourceType\":\"952\"},\"953\":{\"sling:resourceType\":\"953\"},\"954\":{\"sling:resourceType\":\"954\"},\"955\":{\"sling:resourceType\":\"955\"},\"956\":{\"sling:resourceType\":\"956\"},\"957\":{\"sling:resourceType\":\"957\"},\"958\":{\"sling:resourceType\":\"958\"},\"959\":{\"sling:resourceType\":\"959\"},\"960\":{\"sling:resourceType\":\"960\"},\"961\":{\"sling:resourceType\":\"961\"},\"962\":{\"sling:resourceType\":\"962\"},\"963\":{\"sling:resourceType\":\"963\"},\"964\":{\"sling:resourceType\":\"964\"},\"965\":{\"sling:resourceType\":\"965\"},\"966\":{\"sling:resourceType\":\"966\"},\"967\":{\"sling:resourceType\":\"967\"},\"968\":{\"sling:resourceType\":\"968\"},\"969\":{\"sling:resourceType\":\"969\"},\"970\":{\"sling:resourceType\":\"970\"},\"971\":{\"sling:resourceType\":\"971\"},\"972\":{\"sling:resourceType\":\"972\"},\"973\":{\"sling:resourceType\":\"973\"},\"974\":{\"sling:resourceType\":\"974\"},\"975\":{\"sling:resourceType\":\"975\"},\"976\":{\"sling:resourceType\":\"976\"},\"977\":{\"sling:resourceType\":\"977\"},\"978\":{\"sling:resourceType\":\"978\"},\"979\":{\"sling:resourceType\":\"979\"},\"980\":{\"sling:resourceType\":\"980\"},\"981\":{\"sling:resourceType\":\"981\"},\"982\":{\"sling:resourceType\":\"982\"},\"983\":{\"sling:resourceType\":\"983\"},\"984\":{\"sling:resourceType\":\"984\"},\"985\":{\"sling:resourceType\":\"985\"},\"986\":{\"sling:resourceType\":\"986\"},\"987\":{\"sling:resourceType\":\"987\"},\"988\":{\"sling:resourceType\":\"988\"},\"989\":{\"sling:resourceType\":\"989\"},\"990\":{\"sling:resourceType\":\"990\"},\"991\":{\"sling:resourceType\":\"991\"},\"992\":{\"sling:resourceType\":\"992\"},\"993\":{\"sling:resourceType\":\"993\"},\"994\":{\"sling:resourceType\":\"994\"},\"995\":{\"sling:resourceType\":\"995\"},\"996\":{\"sling:resourceType\":\"996\"},\"997\":{\"sling:resourceType\":\"997\"},\"998\":{\"sling:resourceType\":\"998\"},\"999\":{\"sling:resourceType\":\"999\"},\"1000\":{\"sling:resourceType\":\"1000\"},\"1001\":{\"sling:resourceType\":\"1001\"},\"1002\":{\"sling:resourceType\":\"1002\"},\"1003\":{\"sling:resourceType\":\"1003\"},\"1004\":{\"sling:resourceType\":\"1004\"},\"1005\":{\"sling:resourceType\":\"1005\"},\"1006\":{\"sling:resourceType\":\"1006\"},\"1007\":{\"sling:resourceType\":\"1007\"},\"1008\":{\"sling:resourceType\":\"1008\"},\"1009\":{\"sling:resourceType\":\"1009\"},\"1010\":{\"sling:resourceType\":\"1010\"},\"1011\":{\"sling:resourceType\":\"1011\"},\"1012\":{\"sling:resourceType\":\"1012\"},\"1013\":{\"sling:resourceType\":\"1013\"},\"1014\":{\"sling:resourceType\":\"1014\"},\"1015\":{\"sling:resourceType\":\"1015\"},\"1016\":{\"sling:resourceType\":\"1016\"},\"1017\":{\"sling:resourceType\":\"1017\"},\"1018\":{\"sling:resourceType\":\"1018\"},\"1019\":{\"sling:resourceType\":\"1019\"},\"1020\":{\"sling:resourceType\":\"1020\"},\"1021\":{\"sling:resourceType\":\"1021\"},\"1022\":{\"sling:resourceType\":\"1022\"},\"1023\":{\"sling:resourceType\":\"1023\"},\"1024\":{\"sling:resourceType\":\"1024\"},\"1025\":{\"sling:resourceType\":\"1025\"},\"1026\":{\"sling:resourceType\":\"1026\"},\"1027\":{\"sling:resourceType\":\"1027\"},\"1028\":{\"sling:resourceType\":\"1028\"},\"1029\":{\"sling:resourceType\":\"1029\"},\"1030\":{\"sling:resourceType\":\"1030\"},\"1031\":{\"sling:resourceType\":\"1031\"},\"1032\":{\"sling:resourceType\":\"1032\"},\"1033\":{\"sling:resourceType\":\"1033\"},\"1034\":{\"sling:resourceType\":\"1034\"},\"1035\":{\"sling:resourceType\":\"1035\"},\"1036\":{\"sling:resourceType\":\"1036\"},\"1037\":{\"sling:resourceType\":\"1037\"},\"1038\":{\"sling:resourceType\":\"1038\"},\"1039\":{\"sling:resourceType\":\"1039\"},\"1040\":{\"sling:resourceType\":\"1040\"},\"1041\":{\"sling:resourceType\":\"1041\"},\"1042\":{\"sling:resourceType\":\"1042\"},\"1043\":{\"sling:resourceType\":\"1043\"},\"1044\":{\"sling:resourceType\":\"1044\"},\"1045\":{\"sling:resourceType\":\"1045\"},\"1046\":{\"sling:resourceType\":\"1046\"},\"1047\":{\"sling:resourceType\":\"1047\"},\"1048\":{\"sling:resourceType\":\"1048\"},\"1049\":{\"sling:resourceType\":\"1049\"},\"1050\":{\"sling:resourceType\":\"1050\"},\"1051\":{\"sling:resourceType\":\"1051\"},\"1052\":{\"sling:resourceType\":\"1052\"},\"1053\":{\"sling:resourceType\":\"1053\"},\"1054\":{\"sling:resourceType\":\"1054\"},\"1055\":{\"sling:resourceType\":\"1055\"},\"1056\":{\"sling:resourceType\":\"1056\"},\"1057\":{\"sling:resourceType\":\"1057\"},\"1058\":{\"sling:resourceType\":\"1058\"},\"1059\":{\"sling:resourceType\":\"1059\"},\"1060\":{\"sling:resourceType\":\"1060\"},\"1061\":{\"sling:resourceType\":\"1061\"},\"1062\":{\"sling:resourceType\":\"1062\"},\"1063\":{\"sling:resourceType\":\"1063\"},\"1064\":{\"sling:resourceType\":\"1064\"},\"1065\":{\"sling:resourceType\":\"1065\"},\"1066\":{\"sling:resourceType\":\"1066\"},\"1067\":{\"sling:resourceType\":\"1067\"},\"1068\":{\"sling:resourceType\":\"1068\"},\"1069\":{\"sling:resourceType\":\"1069\"},\"1070\":{\"sling:resourceType\":\"1070\"},\"1071\":{\"sling:resourceType\":\"1071\"},\"1072\":{\"sling:resourceType\":\"1072\"},\"1073\":{\"sling:resourceType\":\"1073\"},\"1074\":{\"sling:resourceType\":\"1074\"},\"1075\":{\"sling:resourceType\":\"1075\"},\"1076\":{\"sling:resourceType\":\"1076\"},\"1077\":{\"sling:resourceType\":\"1077\"},\"1078\":{\"sling:resourceType\":\"1078\"},\"1079\":{\"sling:resourceType\":\"1079\"},\"1080\":{\"sling:resourceType\":\"1080\"},\"1081\":{\"sling:resourceType\":\"1081\"},\"1082\":{\"sling:resourceType\":\"1082\"},\"1083\":{\"sling:resourceType\":\"1083\"},\"1084\":{\"sling:resourceType\":\"1084\"}}",
                response);
    }

    private String getJSON(String path, String depth) throws Throwable {
        SlingJakartaHttpServletRequest request = Builders.newRequestBuilder(
                        context.resourceResolver().getResource(path))
                .withExtension("json")
                .withSelectors(depth)
                .withRequestMethod("GET")
                .buildJakartaRequest();

        SlingJakartaHttpServletResponseResult response =
                Builders.newResponseBuilder().buildJakartaResponseResult();
        JsonRenderer renderer = new JsonRenderer(1000, true);
        renderer.render(request, response);
        return response.getOutputAsString();
    }
}
