/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.servlets.resolver.internal.helper.LocationCollector;
import org.apache.sling.servlets.resolver.internal.helper.WeightedResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResourceCollector {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractResourceCollector.class);
    protected static final String CACHE_KEY_CHILDREN_LIST = AbstractResourceCollector.class.getName() + ".childrenList";
    protected static final String CACHE_KEY_RESOURCES = AbstractResourceCollector.class.getName() + ".resources";
    protected final String baseResourceType;
    protected final String extension;
    protected int hashCode;
    protected final String resourceType;
    protected final String resourceSuperType;
    protected final String[] executionPaths;
    protected boolean useResourceCaching;

    protected AbstractResourceCollector(String baseResourceType, String resourceType, String resourceSuperType, String extension, String[] executionPaths, boolean useResourceCaching) {
        this.baseResourceType = baseResourceType;
        this.resourceType = resourceType;
        this.resourceSuperType = resourceSuperType;
        this.extension = extension;
        this.executionPaths = executionPaths;
        this.useResourceCaching = useResourceCaching;
    }

    public final Collection<Resource> getServlets(ResourceResolver resolver, List<String> scriptExtensions) {
        TreeSet resources = new TreeSet((o1, o2) -> {
            String o1Parent = ResourceUtil.getParent((String)o1.getPath());
            String o2Parent = ResourceUtil.getParent((String)o2.getPath());
            if (o1Parent != null && o2Parent != null && o1Parent.equals(o2Parent)) {
                String o2ScriptWithoutExtension;
                String o1ScriptWithoutExtension;
                String o1ScriptName = o1.getName();
                String o2ScriptName = o2.getName();
                String o1Extension = this.getScriptExtension(o1ScriptName);
                String o2Extension = this.getScriptExtension(o2ScriptName);
                if (StringUtils.isNotEmpty((CharSequence)o1Extension) && StringUtils.isNotEmpty((CharSequence)o2Extension) && (o1ScriptWithoutExtension = o1ScriptName.substring(0, o1ScriptName.lastIndexOf("." + o1Extension))).equals(o2ScriptWithoutExtension = o2ScriptName.substring(0, o2ScriptName.lastIndexOf("." + o2Extension)))) {
                    int o2ExtensionIndex;
                    int o1ExtensionIndex = scriptExtensions.indexOf(o1Extension);
                    if (o1ExtensionIndex == (o2ExtensionIndex = scriptExtensions.indexOf(o2Extension)) || o1ExtensionIndex == -1 || o2ExtensionIndex == -1) {
                        return o1.compareTo((WeightedResource)o2);
                    }
                    if (o1ExtensionIndex > o2ExtensionIndex) {
                        return -1;
                    }
                    return 1;
                }
            }
            return o1.compareTo((WeightedResource)o2);
        });
        List<Resource> locations = LocationCollector.getLocations(this.resourceType, this.resourceSuperType, this.baseResourceType, resolver, this.useResourceCaching);
        locations.forEach(locationRes -> this.getWeightedResources(resources, (Resource)locationRes));
        ArrayList<Resource> result = new ArrayList<Resource>(resources.size());
        result.addAll(resources);
        return result;
    }

    protected abstract void getWeightedResources(Set<WeightedResource> var1, Resource var2);

    protected final void addWeightedResource(Set<WeightedResource> resources, Resource resource, int numSelectors, int methodPrefixWeight) {
        WeightedResource lr = new WeightedResource(resources.size(), resource, numSelectors, methodPrefixWeight);
        resources.add(lr);
    }

    @NotNull
    protected final Resource getResource(@NotNull ResourceResolver resolver, @NotNull String path, boolean useCaching) {
        Resource res = AbstractResourceCollector.getResourceOrNull(resolver, path, useCaching);
        if (res == null) {
            res = new SyntheticResource(resolver, path, "$synthetic$");
        }
        return res;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractResourceCollector)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        AbstractResourceCollector o = (AbstractResourceCollector)obj;
        return this.stringEquals(this.resourceType, o.resourceType) && this.stringEquals(this.resourceSuperType, o.resourceSuperType) && this.stringEquals(this.extension, o.extension) && this.stringEquals(this.baseResourceType, o.baseResourceType);
    }

    public int hashCode() {
        return this.hashCode;
    }

    protected boolean stringEquals(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    private String getScriptExtension(String scriptName) {
        int lastIndexOf = scriptName.lastIndexOf(46);
        if (lastIndexOf > -1 && lastIndexOf < scriptName.length() - 1) {
            return scriptName.substring(lastIndexOf + 1);
        }
        return null;
    }

    @NotNull
    static List<Resource> getChildrenList(@NotNull Resource parent, boolean useCaching) {
        ArrayList<Resource> childList = new ArrayList<Resource>();
        Map childrenListMap = null;
        if (useCaching) {
            Map cache = parent.getResourceResolver().getPropertyMap();
            if (!cache.containsKey(CACHE_KEY_CHILDREN_LIST)) {
                childrenListMap = new ConcurrentHashMap<String, ArrayList<Resource>>();
                cache.put(CACHE_KEY_CHILDREN_LIST, childrenListMap);
            } else {
                Object entry = cache.get(CACHE_KEY_CHILDREN_LIST);
                if (entry instanceof Map) {
                    childrenListMap = (Map)cache.get(CACHE_KEY_CHILDREN_LIST);
                } else {
                    LOG.debug("Found key '{}' used with the unexpected type '{}', not caching the resource children list", (Object)CACHE_KEY_CHILDREN_LIST, (Object)entry.getClass().getName());
                }
            }
            if (childrenListMap != null && childrenListMap.containsKey(parent.getPath())) {
                List result = (List)childrenListMap.get(parent.getPath());
                LOG.trace("getChildrenList cache-hit for {} with {} child resources", (Object)parent.getPath(), (Object)result.size());
                return result;
            }
        }
        Iterator childrenIterator = parent.listChildren();
        while (childrenIterator.hasNext()) {
            childList.add((Resource)childrenIterator.next());
        }
        if (useCaching && childrenListMap != null) {
            childrenListMap.put(parent.getPath(), childList);
            LOG.trace("getChildrenList cache-miss for {} with {} child resources", (Object)parent.getPath(), (Object)childList.size());
        }
        return childList;
    }

    public static void clearCache(@NotNull ResourceResolver resolver) {
        Object o2;
        Object o1 = resolver.getPropertyMap().get(CACHE_KEY_CHILDREN_LIST);
        if (o1 instanceof Map) {
            Map childrenListMap = (Map)o1;
            childrenListMap.clear();
        }
        if ((o2 = resolver.getPropertyMap().get(CACHE_KEY_RESOURCES)) instanceof Map) {
            Map resourceMap = (Map)o2;
            resourceMap.clear();
        }
    }

    @Nullable
    public static Resource getResourceOrNull(@NotNull ResourceResolver resolver, @NotNull String path, boolean useCaching) {
        Object o = resolver.getPropertyMap().get(CACHE_KEY_RESOURCES);
        if (useCaching) {
            if (o instanceof Map) {
                Map resourceMap = (Map)o;
                if (resourceMap.containsKey(path)) {
                    LOG.trace("getResourceOrNull cache-hit for path {}", (Object)path);
                    return (Resource)resourceMap.get(path);
                }
                LOG.trace("getResourceOrNull cache-miss for path {}", (Object)path);
                Resource resource = resolver.getResource(path);
                resourceMap.put(path, resource);
                return resource;
            }
            if (o == null) {
                LOG.trace("getResourceOrNull cache-miss on init for path {}", (Object)path);
                HashMap<String, Resource> resourceMap = new HashMap<String, Resource>();
                resolver.getPropertyMap().put(CACHE_KEY_RESOURCES, resourceMap);
                Resource resource = resolver.getResource(path);
                resourceMap.put(path, resource);
                return resource;
            }
            LOG.debug("Found key '{}' used with the unexpected type '{}', not caching the resource for path {}", new Object[]{CACHE_KEY_RESOURCES, o.getClass().getName(), path});
        }
        return resolver.getResource(path);
    }
}

