/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.codegen;

import com.google.gxp.com.google.common.base.Function;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.base.Parameter;
import com.google.gxp.compiler.base.Root;
import com.google.gxp.compiler.base.Tree;
import com.google.gxp.compiler.codegen.BaseCodeGenerator;
import com.google.gxp.compiler.io.CIndenter;

public abstract class BracesCodeGenerator<T extends Tree<Root>>
extends BaseCodeGenerator<T> {
    protected final Root root;

    protected BracesCodeGenerator(T tree) {
        super(tree);
        this.root = ((Tree)tree).getRoot();
    }

    protected static abstract class Worker {
        protected final CIndenter out;
        protected final AlertSink alertSink;
        private static final String COMMENT_FORMAT = "// %s: L%d, C%d";
        private static final String BANNER_FORMAT = BaseCodeGenerator.loadFormat("codegen/banner");
        protected Function<Parameter, String> paramToCallName = new Function<Parameter, String>(){

            @Override
            public String apply(Parameter param) {
                return param.getPrimaryName();
            }
        };

        protected Worker(Appendable out, AlertSink alertSink, String ... halfIndentMarkers) {
            this.out = new CIndenter(out, halfIndentMarkers);
            this.alertSink = Preconditions.checkNotNull(alertSink);
        }

        protected SourcePosition getDefaultSourcePosition() {
            return null;
        }

        protected String makeTailComment(SourcePosition pos) {
            return String.format(COMMENT_FORMAT, pos.getSourceName(), pos.getLine(), pos.getColumn());
        }

        protected final void appendLine() {
            this.appendLine(null, "");
        }

        protected final void appendLine(CharSequence line) {
            this.appendLine(this.getDefaultSourcePosition(), line);
        }

        protected final void appendLine(SourcePosition pos, CharSequence line) {
            String tailComment = pos != null && !((Object)line).toString().contains(pos.getSourceName()) ? this.makeTailComment(pos) : "";
            this.out.appendLine(line, tailComment);
        }

        protected final void formatLine(String lineFormat, Object ... args) {
            this.formatLine(this.getDefaultSourcePosition(), lineFormat, args);
        }

        protected final void formatLine(SourcePosition sourcePosition, String lineFormat, Object ... args) {
            this.appendLine(sourcePosition, String.format(lineFormat, args));
        }

        protected void appendBanner() {
            this.appendLine(null, BANNER_FORMAT);
        }

        protected void appendHeader(Root root) {
            this.appendBanner();
        }

        protected void appendFooter() {
            this.appendBanner();
        }
    }
}

