/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.net.URI;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.openejb.client.AbstractConnectionStrategy;
import org.apache.openejb.client.ClusterMetaData;
import org.apache.openejb.client.RoundRobinConnectionStrategy;
import org.apache.openejb.client.event.FailoverSelection;
import org.apache.openejb.client.event.StickyFailoverSelection;

public class StickyConnectionStrategy
extends AbstractConnectionStrategy {
    private final AbstractConnectionStrategy secondaryConnectionStrategy;

    public StickyConnectionStrategy() {
        this(new RoundRobinConnectionStrategy());
    }

    public StickyConnectionStrategy(AbstractConnectionStrategy secondaryConnectionStrategy) {
        this.secondaryConnectionStrategy = secondaryConnectionStrategy;
    }

    public AbstractConnectionStrategy getSecondaryConnectionStrategy() {
        return this.secondaryConnectionStrategy;
    }

    @Override
    protected FailoverSelection createFailureEvent(Set<URI> remaining, Set<URI> failed, URI uri) {
        return new StickyFailoverSelection(remaining, failed, uri);
    }

    @Override
    protected Iterable<URI> createIterable(ClusterMetaData cluster) {
        return new StickyIterable(cluster);
    }

    public class StickyIterable
    implements Iterable<URI> {
        private final ClusterMetaData cluster;
        private final Iterable<URI> iterable;

        public StickyIterable(ClusterMetaData cluster) {
            this.cluster = cluster;
            this.iterable = StickyConnectionStrategy.this.secondaryConnectionStrategy.createIterable(cluster);
        }

        @Override
        public Iterator<URI> iterator() {
            return new StickyIterator();
        }

        public class StickyIterator
        implements Iterator<URI> {
            private Iterator<URI> iterator;
            private URI last;
            private boolean first = true;

            private StickyIterator() {
                this.setLast(StickyIterable.this.cluster.getLastLocation());
            }

            private void setLast(URI lastLocation) {
                this.last = lastLocation;
            }

            @Override
            public boolean hasNext() {
                return this.first && this.last != null || this.getIterator().hasNext();
            }

            @Override
            public URI next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.first && this.last != null) {
                    this.first = false;
                    return this.last;
                }
                Iterator<URI> iterator = this.getIterator();
                return iterator.next();
            }

            private Iterator<URI> getIterator() {
                if (this.iterator == null) {
                    this.iterator = StickyIterable.this.iterable.iterator();
                }
                return this.iterator;
            }

            @Override
            public void remove() {
            }
        }
    }
}

