/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.faulttolerance;

import io.smallrye.faulttolerance.FaultToleranceBinding;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;

public class MPFaultToleranceCDIExtension
implements Extension {
    private List<Class> faultToleranceAnnotations = Arrays.asList(CircuitBreaker.class, Retry.class, Timeout.class, Asynchronous.class, Fallback.class, Bulkhead.class);

    <X> void addFaultToleranceInterceptorBinding(@Observes ProcessAnnotatedType<X> pat, BeanManager bm) {
        if (this.hasFaultToleranceAnnotations((Annotated)pat.getAnnotatedType())) {
            pat.configureAnnotatedType().add((Annotation)FaultToleranceBinding.Literal.INSTANCE);
            return;
        }
        for (AnnotatedMethod m : pat.getAnnotatedType().getMethods()) {
            if (!this.hasFaultToleranceAnnotations((Annotated)m)) continue;
            pat.configureAnnotatedType().add((Annotation)FaultToleranceBinding.Literal.INSTANCE);
            return;
        }
    }

    private boolean hasFaultToleranceAnnotations(Annotated annotated) {
        for (Class annotation : this.faultToleranceAnnotations) {
            if (!annotated.isAnnotationPresent(annotation)) continue;
            return true;
        }
        return false;
    }
}

