            title   DOSFILES

; increase the number of Dos file handles
; Copyright (C) 1996,98 by Peter Breitenlohner
; Distributed under terms of GNU General Public License

; to be included into main program

DATA        segment word
            extrn   prefixseg:word     ; psp segment
            extrn   tryfiles:byte      ; shall we try to get more handles?
DATA        ends

CODE        segment word
            assume  cs:CODE, ds:DATA

            public  dosfiles

; procedure dos_files;
;           increases the number of Dos file handles to the number of
;           Dos files (files=<num> in config.sys)

dosfiles    proc    near

; first we make sure this is Dos Version 3.30 or higher
; and the user has not not specified the '-h' command line option

            mov     ah,30h             ; get Dos version number
            int     21h
            xchg    ah,al
            cmp     ax,031eh
            jb      done               ; less than than 3.30
            xor     al,al              ; don't run twice
            cmp     tryfiles,al
            je      done               ; '-h' command line option
            mov     tryfiles,al

; next we use the (undocumented) Dos function 52h to get the
; list of lists and walk through the sft chain to count the files

            mov     ah,52h             ; get list of lists
            int     21h
            les     bx,[es:bx+4]       ; first sft
            xor     cx,cx
next_sft:   add     cx,[es:bx+4]       ; number files in this block
            les     bx,[es:bx]         ; next sft
            cmp     bx,0ffffh
            jne     next_sft           ; not end of chain
            or      ch,ch
            jnz     done               ; more than 255 files ???
            mov     dx,prefixseg
            mov     es,dx

; the psp segment contains the default handle array as well
; as the number of handles and the pointer to the array

num_h       equ     word ptr [es:32h]  ; num of handles
ptr_h       equ     dword ptr [es:34h] ; ptr to handles
ofs_h       equ     word ptr [es:34h]    ; ofs part of ptr
seg_h       equ     word ptr [es:36h]    ; seg part of ptr

            cmp     cx,num_h
            jna     done               ; already enough handles
            push    ds
            assume  ds:NOTHING

; now we insert the new count and pointer and
; copy the existing handles

            xchg    cx,num_h
            lds     si,ptr_h           ; ds:si -> old handles
            mov     di,offset handles
            mov     ofs_h,di
            mov     bx,cs
            mov     seg_h,bx
            mov     es,bx              ; es:di -> new handles
            cld
            rep movsb                  ; copy handles
            pop     ds

done:       ret

dosfiles    endp

handles:    db      0ffh dup (0ffh)

CODE        ends

            end
